/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.interception;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="LitterInterception", author="Peter Krause", description="Calculates daily interception based on DICKINSON 1984")
public class LitterInterception
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="hru")
    public Attribute.Entity hru;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="hruID")
    public Attribute.Double hruID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute area")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable net-rain")
    public Attribute.Double netRain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="daily snow melt")
    public Attribute.Double snowMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable potE")
    public Attribute.Double potE;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="state variable actE")
    public Attribute.Double actE;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="LitterInterception parameter Cmax")
    public Attribute.Double Cmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="LitterInterception parameter Cmin")
    public Attribute.Double Cmin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="horizons")
    public Attribute.Double horizons;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU attribute maximum MPS")
    public Attribute.DoubleArray maxMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU attribute maximum LPS")
    public Attribute.DoubleArray maxLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU state var actual MPS")
    public Attribute.DoubleArray actMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU state var actual LPS")
    public Attribute.DoubleArray actLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU state var saturation of MPS")
    public Attribute.DoubleArray satMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU state var saturation of LPS")
    public Attribute.DoubleArray satLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maximum infiltration rate in summer [mm/d]")
    public Attribute.Double soilMaxInfSummer;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maximum infiltration rate in winter [mm/d]")
    public Attribute.Double soilMaxInfWinter;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maximum infiltration rate on snow [mm/d]")
    public Attribute.Double soilMaxInfSnow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Litter interception storage [mm]")
    public Attribute.Double LitterInterceptionStorage;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="surface runoff generation")
    public Attribute.Double litterRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="snow depth")
    public Attribute.Double snowDepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="litter infiltration")
    public Attribute.Double litterInfiltration;
    double run_snowDepth;
    double in_Area;
    double run_satSoil;
    double soilSatMps;
    double soilSatLps;
    double soilActMps;
    double soilActLps;
    double soilMaxMps;
    double soilMaxLps;
    double run_LitIntcStorage;
    double[] run_maxMPS;
    double[] run_maxLPS;
    double[] run_actMPS;
    double[] run_actLPS;
    double[] run_satMPS;
    double[] run_satLPS;
    double[] run_inRD2;
    double[] run_satHor;
    double[] run_outRD2;
    double[] run_genRD2;
    int nhor;

    public void init() throws Attribute.Entity.NoSuchAttributeException {
        this.LitterInterceptionStorage.setValue(0.0);
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException {
        double acte = 0.0;
        double sum_input = 0.0;
        double netrain = this.netRain.getValue();
        double snowmelt = this.snowMelt.getValue();
        double pot_E = this.potE.getValue();
        this.in_Area = this.area.getValue();
        double cmax = this.Cmax.getValue();
        double cmin = this.Cmin.getValue();
        this.run_LitIntcStorage = this.LitterInterceptionStorage.getValue();
        this.run_maxMPS = this.maxMPS.getValue();
        this.run_maxLPS = this.maxLPS.getValue();
        this.run_actMPS = this.actMPS.getValue();
        this.run_actLPS = this.actLPS.getValue();
        this.run_satMPS = this.satMPS.getValue();
        this.run_satLPS = this.satLPS.getValue();
        this.nhor = (int)this.horizons.getValue();
        this.run_satHor = new double[this.nhor];
        sum_input = netrain + snowmelt;
        this.run_snowDepth = this.snowDepth.getValue();
        double maxLitIntcCap = cmax * this.in_Area;
        double minLitIntcCap = cmin * this.in_Area;
        this.run_LitIntcStorage += sum_input;
        double maxInf = this.calcMaxInfiltration(this.time.get(2) + 1);
        double potInf = (this.run_LitIntcStorage - minLitIntcCap) / maxLitIntcCap;
        if (potInf < 0.0) {
            potInf = 0.0;
        }
        double inf = potInf > maxInf ? maxInf : potInf;
        this.run_LitIntcStorage -= inf;
        acte = this.run_LitIntcStorage > pot_E ? pot_E : this.run_LitIntcStorage;
        this.run_LitIntcStorage -= acte;
        double rd1litter = this.run_LitIntcStorage > maxLitIntcCap ? this.run_LitIntcStorage - maxLitIntcCap : 0.0;
        this.run_LitIntcStorage -= rd1litter;
        this.actE.setValue(acte);
        this.LitterInterceptionStorage.setValue(this.run_LitIntcStorage);
        this.litterRD1.setValue(rd1litter);
        this.litterInfiltration.setValue(inf);
    }

    public void cleanup() {
        this.LitterInterceptionStorage.setValue(0.0);
    }

    private double calcMaxInfiltration(int nowmonth) {
        double maxInf = 0.0;
        this.calcSoilSaturations(false);
        maxInf = this.run_snowDepth > 0.0 ? this.soilMaxInfSnow.getValue() * this.in_Area : (nowmonth >= 5 & nowmonth <= 10 ? (1.0 - this.run_satSoil) * this.soilMaxInfSummer.getValue() * this.in_Area : (1.0 - this.run_satSoil) * this.soilMaxInfWinter.getValue() * this.in_Area);
        return maxInf;
    }

    private boolean calcSoilSaturations(boolean debug) {
        this.soilMaxMps = 0.0;
        this.soilActMps = 0.0;
        this.soilMaxLps = 0.0;
        this.soilActLps = 0.0;
        this.soilSatMps = 0.0;
        this.soilSatLps = 0.0;
        for (int h = 0; h < this.nhor; ++h) {
            this.run_satLPS[h] = this.run_actLPS[h] > 0.0 && this.run_maxLPS[h] > 0.0 ? this.run_actLPS[h] / this.run_maxLPS[h] : 0.0;
            this.run_satMPS[h] = this.run_actMPS[h] > 0.0 && this.run_maxMPS[h] > 0.0 ? this.run_actMPS[h] / this.run_maxMPS[h] : 0.0;
            if ((this.run_maxLPS[h] > 0.0 | this.run_maxMPS[h] > 0.0) & (this.run_actLPS[h] > 0.0 | this.run_actMPS[h] > 0.0)) {
                this.run_satHor[h] = (this.run_actLPS[h] + this.run_actMPS[h]) / (this.run_maxLPS[h] + this.run_maxMPS[h]);
            } else {
                this.run_satSoil = 0.0;
            }
            this.soilMaxMps += this.run_maxMPS[h];
            this.soilActMps += this.run_actMPS[h];
            this.soilMaxLps += this.run_maxLPS[h];
            this.soilActLps += this.run_actLPS[h];
        }
        if ((this.soilMaxLps > 0.0 | this.soilMaxMps > 0.0) & (this.soilActLps > 0.0 | this.soilActMps > 0.0)) {
            this.run_satSoil = (this.soilActLps + this.soilActMps) / (this.soilMaxLps + this.soilMaxMps);
            this.soilSatMps = this.soilActMps / this.soilMaxMps;
            this.soilSatLps = this.soilActLps / this.soilMaxLps;
        } else {
            this.run_satSoil = 0.0;
        }
        return true;
    }
}

