/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="LapseRateAdaptation", author="Sven Kralisch", description="Adaptation of local climate values through elevation difference based on yearly/monthly lapse rates.\n1. Cacluate the elevation difference between modelling unitand climate data source\n2. Adjust the climate value according to the lapse rate and elevation difference", date="2019-10-15", version="1.0_1")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version"), @VersionComments.Entry(version="1.0_1", comment="Fixed bug in fixedMinimum/fixedMaximum evaluation"), @VersionComments.Entry(version="1.1_0", date="2020-04-27", comment="Extended for use of input/output arrays for Precip BIAS correction")})
public class BiasCorrectionMonthlyTemp
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Climate input value")
    public Attribute.DoubleArray inputValues;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Lapse rates for 100m elevation difference, given either as a single values or as 12 (monthly) values")
    public Attribute.Double[] correctionFactors;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The current model time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Calculated output for the modelling entity")
    public Attribute.DoubleArray outputValues;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Absolute possible minimum value for data set", defaultValue="-Infinity")
    public Attribute.Double fixedMinimum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Absolute possible maximum value for data set", defaultValue="Infinity")
    public Attribute.Double fixedMaximum;

    public void init() {
        if (this.correctionFactors.length != 1 && this.correctionFactors.length != 12) {
            this.getModel().getRuntime().sendHalt("Number of lapse rate values must be either 1 or 12!");
        }
    }

    public void run() {
        double[] inputs = this.inputValues.getValue();
        double[] outputs = new double[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            double input = inputs[i];
            if (input != JAMS.getMissingDataValue()) {
                double monthlyCorrectionFactor;
                if (this.correctionFactors.length > 1) {
                    int nowmonth = this.time.get(2);
                    monthlyCorrectionFactor = this.correctionFactors[nowmonth].getValue();
                } else {
                    monthlyCorrectionFactor = this.correctionFactors[0].getValue();
                }
                double result = monthlyCorrectionFactor + input;
                result = Math.min(this.fixedMaximum.getValue(), result);
                outputs[i] = result = Math.max(this.fixedMinimum.getValue(), result);
                continue;
            }
            outputs[i] = JAMS.getMissingDataValue();
        }
        this.outputValues.setValue(outputs);
    }
}

