/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.groundwater;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="GeoFemGroundwater", author="Peter Krause", description="Description")
public class GeoFemGroundwater
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute slope")
    public Attribute.Double slope;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="recision coefficient k")
    public Attribute.Double k;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="groundwater recharge")
    public Attribute.Double gwRecharge;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="groundwater storages")
    public Attribute.Double storage;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="baseflow basQ")
    public Attribute.Double basQ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="baseflow recession coefficient")
    public Attribute.Double gwRecCoeff;

    public void init() {
    }

    public void run() {
        double storage = this.storage.getValue();
        double input = this.gwRecharge.getValue();
        double recTanSlope = 1.0 - Math.tan(this.slope.getValue() * (Math.PI / 180));
        if (recTanSlope < 0.0) {
            recTanSlope = 0.0;
        }
        double gwRec = 1.0 / (this.k.getValue() * recTanSlope);
        double outflow = 1.0 / this.k.getValue() * (storage += input);
        this.storage.setValue(storage -= outflow);
        this.basQ.setValue(outflow);
        this.gwRecCoeff.setValue(this.k.getValue() * recTanSlope);
    }

    public void cleanup() {
    }
}

