/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.analysis;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.util.Vector;
import org.unijena.j2k.statistics.Regression;

@JAMSComponentDescription(title="BaseflowIndex", author="Peter Krause", description="Estimates the relative part of baseflow expressed as baseflow index BFI. The method is based on Wundt, Kille and Demuth and expects a time series of measured daily runoff values for a period of10 yrs or more.")
public class BaseflowIndex
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the current time step")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily runoff value", unit="m\u00b3/s")
    public Attribute.Double dailyRunoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the X% lowest values can be interpreted as human influenced and removed from the analysis. Default value is 5%.", defaultValue="0.05")
    public Attribute.Double lowestValues;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="the baseflow index expressed as the ration of reducedmean monthly low flows and mean monthly runoff")
    public Attribute.Double bfi;
    private Vector<Double> monq = new Vector();
    private Vector<Double> momq = new Vector();
    private Vector<Double> basq = new Vector();
    private Vector<Double> rank = new Vector();
    private int currentMonth = -1;
    private double actMinimum = 9999.9;
    private double actSum = 0.0;
    private int dayCount = 0;

    public void run() {
        int actMonth = this.time.get(2);
        if (this.currentMonth < 0) {
            this.currentMonth = actMonth;
        }
        if (actMonth != this.currentMonth && this.dayCount > 0) {
            double dRo;
            this.momq.add(this.actSum / (double)this.dayCount);
            this.monq.add(this.actMinimum);
            this.actSum = dRo = this.dailyRunoff.getValue();
            this.actMinimum = dRo;
            this.dayCount = 1;
            this.currentMonth = this.currentMonth < 11 ? ++this.currentMonth : 0;
        } else {
            ++this.dayCount;
            double dRo = this.dailyRunoff.getValue();
            this.actSum += dRo;
            if (dRo < this.actMinimum) {
                this.actMinimum = dRo;
            }
        }
    }

    public void cleanup() {
        int idx;
        this.momq.add(this.actSum / (double)this.dayCount);
        this.monq.add(this.actMinimum);
        int size = this.monq.size();
        double meanSum = 0.0;
        double[] minimums = new double[this.monq.size()];
        for (int c = 0; c < size; ++c) {
            meanSum += this.momq.get(c).doubleValue();
            int count = 0;
            double actMin = this.monq.get(0);
            for (int i = 0; i < this.monq.size(); ++i) {
                double val = this.monq.get(i);
                if (!(val < actMin)) continue;
                count = i;
                actMin = val;
            }
            minimums[c] = actMin;
            this.monq.remove(count);
        }
        int nLowVal = (int)((double)size * this.lowestValues.getValue());
        int med = (int)((double)size * 0.5);
        int currCount = 0;
        int i = nLowVal;
        while (i < med) {
            this.basq.add(minimums[i]);
            this.rank.add((double)i + 1.0);
            currCount = i++;
        }
        double[] bq = this.v2da(this.basq);
        double[] rv = this.v2da(this.rank);
        double[] regCoeff = Regression.calcLinReg(rv, bq);
        double rsq = regCoeff[2];
        boolean cont = true;
        double gradient = 0.0;
        double intercept = 0.0;
        while (cont && currCount < this.momq.size() - 1) {
            this.basq.add(minimums[++currCount]);
            this.rank.add((double)currCount + 1.0);
            bq = this.v2da(this.basq);
            rv = this.v2da(this.rank);
            regCoeff = Regression.calcLinReg(rv, bq);
            if (regCoeff[2] >= rsq) {
                cont = true;
                rsq = regCoeff[2];
                continue;
            }
            cont = false;
            this.basq.remove(this.basq.size() - 1);
            this.rank.remove(this.rank.size() - 1);
            bq = this.v2da(this.basq);
            rv = this.v2da(this.rank);
            regCoeff = Regression.calcLinReg(rv, bq);
            intercept = regCoeff[0];
            gradient = regCoeff[1];
            rsq = regCoeff[2];
        }
        int startIdx = this.basq.size() - 1;
        double currRank = this.rank.get(startIdx);
        for (int i2 = idx = (int)currRank + 1; i2 <= this.momq.size(); ++i2) {
            double val = intercept + gradient * (currRank += 1.0);
            this.basq.add(val);
            this.rank.add(currRank);
        }
        bq = this.v2da(this.basq);
        double bq_sum = 0.0;
        for (int i3 = 0; i3 < bq.length; ++i3) {
            bq_sum += bq[i3];
        }
        double longTermBflo = bq_sum / (double)bq.length;
        double longTermMean = meanSum / (double)size;
        this.bfi.setValue(longTermBflo / longTermMean);
        System.out.println("BFI: " + this.bfi.getValue());
    }

    private double[] v2da(Vector inVec) {
        double[] outArr = new double[inVec.size()];
        for (int i = 0; i < inVec.size(); ++i) {
            outArr[i] = (Double)inVec.get(i);
        }
        return outArr;
    }
}

