/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.thornthwaite;

import jams.data.Attribute;
import jams.io.GenericDataReader;
import jams.io.JAMSTableDataArray;
import jams.io.JAMSTableDataConverter;
import jams.io.JAMSTableDataStore;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.io.File;

@JAMSComponentDescription(title="Thorntwaite model climate reader", author="Sven Kralisch", date="30. September 2005", description="This component reads timeseries of temperature and precipitation from an ASCII file")
public class Climate_runoff
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="File containg the data")
    public Attribute.String fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Temperature read from the file")
    public Attribute.Double temp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Precipitation read from the file")
    public Attribute.Double precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Observed Runoff read from the file")
    public Attribute.Double runoff;
    private JAMSTableDataStore store;

    public void init() {
        this.store = new GenericDataReader(this.getModel().getWorkspace().getInputDirectory().getPath() + File.separator + this.fileName.getValue(), false, 4, 6);
    }

    public void run() {
        JAMSTableDataArray da = this.store.getNext();
        double[] vals = JAMSTableDataConverter.toDouble((JAMSTableDataArray)da);
        this.temp.setValue(vals[1]);
        this.precip.setValue(vals[2]);
        this.runoff.setValue(vals[3]);
    }

    public void cleanup() {
        this.store.close();
    }
}

