/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;

public class EGM96 {
    protected String offsetsFilePath;
    protected BufferWrapper deltas;
    protected static Angle INTERVAL = Angle.fromDegrees(0.25);
    protected static int NUM_ROWS = 721;
    protected static int NUM_COLS = 1440;

    public EGM96(String string) throws IOException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.offsetsFilePath = string;
        this.loadOffsetFile();
    }

    protected void loadOffsetFile() throws IOException {
        InputStream inputStream = WWIO.openFileOrResourceStream(this.offsetsFilePath, EGM96.class);
        if (inputStream == null) {
            String string = Logging.getMessage("generic.CannotOpenFile", this.offsetsFilePath);
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        try {
            AVListImpl aVListImpl = new AVListImpl();
            aVListImpl.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.Int16");
            aVListImpl.setValue("gov.nasa.worldwind.avkey.ByteOrder", "gov.nasa.worldwind.avkey.BigEndian");
            this.deltas = BufferWrapper.wrap(WWIO.readStreamToBuffer(inputStream, true), aVListImpl);
        }
        catch (IOException iOException) {
            String string = Logging.getMessage("generic.ExceptionAttemptingToReadFile", this.offsetsFilePath);
            Logging.logger().log(Level.SEVERE, string, iOException);
            throw iOException;
        }
        finally {
            WWIO.closeStream(inputStream, this.offsetsFilePath);
        }
    }

    public double getOffset(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.deltas == null) {
            return 0.0;
        }
        double d = angle.degrees;
        double d2 = angle2.degrees >= 0.0 ? angle2.degrees : angle2.degrees + 360.0;
        int n = (int)((90.0 - d) / EGM96.INTERVAL.degrees);
        if (d <= -90.0) {
            n = NUM_ROWS - 2;
        }
        int n2 = n + 1;
        int n3 = (int)(d2 / EGM96.INTERVAL.degrees);
        int n4 = n3 + 1;
        if (d2 >= 360.0 - EGM96.INTERVAL.degrees) {
            n3 = NUM_COLS - 1;
            n4 = 0;
        }
        double d3 = 90.0 - (double)n * EGM96.INTERVAL.degrees;
        double d4 = (double)n3 * EGM96.INTERVAL.degrees;
        double d5 = this.gePostOffset(n, n3);
        double d6 = this.gePostOffset(n2, n3);
        double d7 = this.gePostOffset(n2, n4);
        double d8 = this.gePostOffset(n, n4);
        double d9 = (d2 - d4) / EGM96.INTERVAL.degrees;
        double d10 = (d3 - d) / EGM96.INTERVAL.degrees;
        double d11 = (1.0 - d9) * (1.0 - d10);
        double d12 = d9 * (1.0 - d10);
        double d13 = d9 * d10;
        double d14 = (1.0 - d9) * d10;
        double d15 = d11 * d6 + d12 * d7 + d13 * d8 + d14 * d5;
        return d15 / 100.0;
    }

    protected double gePostOffset(int n, int n2) {
        int n3 = n * NUM_COLS + n2;
        if (n3 >= this.deltas.length()) {
            System.out.println(n3);
        }
        return this.deltas.getInt(n3);
    }
}

