/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.geom.BilinearInterpolator;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.WWMath;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;

public class FramebufferTexture
implements WWTexture {
    protected WWTexture sourceTexture;
    protected Sector sector;
    protected List<LatLon> corners;
    protected int width;
    protected int height;
    protected TextureCoords textureCoords = new TextureCoords(0.0f, 0.0f, 1.0f, 1.0f);
    protected int tessellationDensity;
    protected static final int DEFAULT_TESSELLATION_DENSITY = 32;

    public FramebufferTexture(WWTexture wWTexture, Sector sector, List<LatLon> list) {
        if (wWTexture == null) {
            String string = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sourceTexture = wWTexture;
        this.sector = sector;
        this.corners = list;
        this.tessellationDensity = 32;
    }

    @Override
    public int getWidth(DrawContext drawContext) {
        return this.width;
    }

    @Override
    public int getHeight(DrawContext drawContext) {
        return this.height;
    }

    public Sector getSector() {
        return this.sector;
    }

    public List<LatLon> getCorners() {
        return this.corners;
    }

    @Override
    public boolean isTextureCurrent(DrawContext drawContext) {
        return drawContext.getTextureCache().getTexture(this) != null;
    }

    @Override
    public Object getImageSource() {
        return this.sourceTexture;
    }

    @Override
    public TextureCoords getTexCoords() {
        return this.textureCoords;
    }

    @Override
    public boolean isTextureInitializationFailed() {
        return this.sourceTexture != null && this.sourceTexture.isTextureInitializationFailed();
    }

    @Override
    public boolean bind(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Texture texture = drawContext.getTextureCache().getTexture(this);
        if (texture == null) {
            texture = this.initializeTexture(drawContext);
        }
        if (texture != null) {
            texture.bind(drawContext.getGL());
        }
        return texture != null;
    }

    @Override
    public void applyInternalTransform(DrawContext drawContext) {
    }

    protected int getTessellationDensity() {
        return this.tessellationDensity;
    }

    protected Texture initializeTexture(DrawContext drawContext) {
        if (!drawContext.isPreRenderMode()) {
            return null;
        }
        if (this.sourceTexture == null || !this.sourceTexture.bind(drawContext)) {
            return null;
        }
        if (this.sourceTexture.getWidth(drawContext) < 1 || this.sourceTexture.getHeight(drawContext) < 1) {
            return null;
        }
        int n = WWMath.powerOfTwoCeiling(this.sourceTexture.getWidth(drawContext));
        int n2 = WWMath.powerOfTwoCeiling(this.sourceTexture.getHeight(drawContext));
        this.width = Math.min(n, drawContext.getView().getViewport().width);
        this.height = Math.min(n2, drawContext.getView().getViewport().height);
        if (!this.generateTexture(drawContext, this.width, this.height)) {
            return null;
        }
        GL gL = drawContext.getGL();
        TextureData textureData = new TextureData(gL.getGLProfile(), 6408, this.width, this.height, 0, 6408, 5121, false, false, false, null, null);
        Texture texture = TextureIO.newTexture(textureData);
        texture.bind(gL);
        gL.glTexParameteri(3553, 10241, 9729);
        gL.glTexParameteri(3553, 10240, 9729);
        gL.glTexParameteri(3553, 10242, 33071);
        gL.glTexParameteri(3553, 10243, 33071);
        gL.glCopyTexImage2D(3553, 0, textureData.getInternalFormat(), 0, 0, textureData.getWidth(), textureData.getHeight(), textureData.getBorder());
        drawContext.getTextureCache().put(this, texture);
        return texture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean generateTexture(DrawContext drawContext, int n, int n2) {
        block9: {
            GL2 gL2 = drawContext.getGL().getGL2();
            OGLStackHandler oGLStackHandler = new OGLStackHandler();
            Matrix matrix = this.computeGeographicToCartesianTransform(this.sector);
            try {
                oGLStackHandler.pushAttrib(gL2, 30720);
                gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                gL2.glClear(16384);
                gL2.glDisable(3042);
                gL2.glDisable(2884);
                gL2.glDisable(2929);
                oGLStackHandler.pushProjectionIdentity(gL2);
                gL2.glViewport(0, 0, n, n2);
                gL2.glOrtho(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
                oGLStackHandler.pushModelviewIdentity(gL2);
                oGLStackHandler.pushTextureIdentity(gL2);
                if (this.sourceTexture == null) break block9;
                try {
                    gL2.glEnable(3553);
                    if (!this.sourceTexture.bind(drawContext)) {
                        boolean bl = false;
                        return bl;
                    }
                    this.sourceTexture.applyInternalTransform(drawContext);
                    gL2.glTexEnvf(8960, 8704, 7681.0f);
                    int n3 = this.getTessellationDensity();
                    this.drawQuad(drawContext, matrix, n3, n3);
                }
                finally {
                    gL2.glTexEnvf(8960, 8704, 8448.0f);
                    gL2.glBindTexture(3553, 0);
                }
            }
            finally {
                oGLStackHandler.pop(gL2);
            }
        }
        return true;
    }

    protected Matrix computeGeographicToCartesianTransform(Sector sector) {
        double d = 2.0 / sector.getDeltaLonDegrees();
        double d2 = 2.0 / sector.getDeltaLatDegrees();
        double d3 = -sector.getMinLongitude().degrees;
        double d4 = -sector.getMinLatitude().degrees;
        Matrix matrix = Matrix.IDENTITY;
        matrix = matrix.multiply(Matrix.fromTranslation(-1.0, -1.0, 0.0));
        matrix = matrix.multiply(Matrix.fromScale(d, d2, 1.0));
        matrix = matrix.multiply(Matrix.fromTranslation(d3, d4, 0.0));
        return matrix;
    }

    protected Vec4 transformToQuadCoordinates(Matrix matrix, LatLon latLon) {
        return new Vec4(latLon.getLongitude().degrees, latLon.getLatitude().degrees, 0.0).transformBy4(matrix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawQuad(DrawContext drawContext, Matrix matrix, int n, int n2) {
        Vec4 vec4 = this.transformToQuadCoordinates(matrix, this.corners.get(0));
        Vec4 vec42 = this.transformToQuadCoordinates(matrix, this.corners.get(1));
        Vec4 vec43 = this.transformToQuadCoordinates(matrix, this.corners.get(2));
        Vec4 vec44 = this.transformToQuadCoordinates(matrix, this.corners.get(3));
        BilinearInterpolator bilinearInterpolator = new BilinearInterpolator(vec4, vec42, vec43, vec44);
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glBegin(5);
        try {
            this.drawQuad(drawContext, bilinearInterpolator, n, n2);
        }
        finally {
            gL2.glEnd();
        }
    }

    protected void drawQuad(DrawContext drawContext, BilinearInterpolator bilinearInterpolator, int n, int n2) {
        double[] dArray = new double[4];
        double d = 1.0f / (float)n;
        double d2 = 1.0f / (float)n2;
        GL2 gL2 = drawContext.getGL().getGL2();
        for (int i = 0; i < n2; ++i) {
            double d3 = (double)i * d2;
            double d4 = (double)(i + 1) * d2;
            if (i != 0) {
                bilinearInterpolator.interpolate((double)n * d, d3, dArray);
                gL2.glTexCoord2d((double)n * d, d3);
                gL2.glVertex3dv(dArray, 0);
                bilinearInterpolator.interpolate(0.0, d3, dArray);
                gL2.glTexCoord2d(0.0, d3);
                gL2.glVertex3dv(dArray, 0);
            }
            for (int j = 0; j <= n; ++j) {
                double d5 = (double)j * d;
                bilinearInterpolator.interpolate(d5, d3, dArray);
                gL2.glTexCoord2d(d5, d3);
                gL2.glVertex3dv(dArray, 0);
                bilinearInterpolator.interpolate(d5, d4, dArray);
                gL2.glTexCoord2d(d5, d4);
                gL2.glVertex3dv(dArray, 0);
            }
        }
    }
}

