/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc;

import gov.nasa.worldwind.ogc.OGCDCType;
import gov.nasa.worldwind.ogc.OGCOnlineResource;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class OGCRequestDescription
extends AbstractXMLEventParser {
    protected QName FORMAT;
    protected QName DCPTYPE;
    protected String requestName;
    protected Set<String> formats;
    protected Set<OGCDCType> dcpTypes;

    public OGCRequestDescription(String string) {
        super(string);
        this.initialize();
    }

    private void initialize() {
        this.FORMAT = new QName(this.getNamespaceURI(), "Format");
        this.DCPTYPE = new QName(this.getNamespaceURI(), "DCPType");
    }

    @Override
    public XMLEventParser allocate(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent) {
        OGCDCType oGCDCType = null;
        if (xMLEventParserContext.isStartElement(xMLEvent, this.DCPTYPE)) {
            oGCDCType = new OGCDCType(this.getNamespaceURI());
        }
        return xMLEventParserContext.allocate(xMLEvent, oGCDCType);
    }

    @Override
    public Object parse(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (this.formats != null) {
            this.formats.clear();
        }
        if (this.dcpTypes != null) {
            this.dcpTypes.clear();
        }
        if (xMLEvent.isStartElement()) {
            this.setRequestName(xMLEvent.asStartElement().getName().getLocalPart());
        }
        return super.parse(xMLEventParserContext, xMLEvent, objectArray);
    }

    @Override
    protected void doParseEventContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        Object object;
        XMLEventParser xMLEventParser;
        if (xMLEventParserContext.isStartElement(xMLEvent, this.FORMAT)) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.addFormat(string);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.DCPTYPE) && (xMLEventParser = this.allocate(xMLEventParserContext, xMLEvent)) != null && (object = xMLEventParser.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object instanceof OGCDCType) {
            this.addDCPType((OGCDCType)object);
        }
    }

    public OGCOnlineResource getOnlineResouce(String string, String string2) {
        for (OGCDCType oGCDCType : this.getDCPTypes()) {
            OGCOnlineResource oGCOnlineResource = oGCDCType.getOnlineResouce(string, string2);
            if (oGCOnlineResource == null) continue;
            return oGCOnlineResource;
        }
        return null;
    }

    public Set<String> getFormats() {
        if (this.formats != null) {
            return this.formats;
        }
        return Collections.emptySet();
    }

    protected void setFormats(Set<String> set) {
        this.formats = set;
    }

    protected void addFormat(String string) {
        if (this.formats == null) {
            this.formats = new HashSet<String>();
        }
        this.formats.add(string);
    }

    protected void setDCPTypes(Set<OGCDCType> set) {
        this.dcpTypes = set;
    }

    public Set<OGCDCType> getDCPTypes() {
        if (this.dcpTypes != null) {
            return this.dcpTypes;
        }
        return Collections.emptySet();
    }

    public void addDCPType(OGCDCType oGCDCType) {
        if (this.dcpTypes == null) {
            this.dcpTypes = new HashSet<OGCDCType>();
        }
        this.dcpTypes.add(oGCDCType);
    }

    public String getRequestName() {
        return this.requestName;
    }

    protected void setRequestName(String string) {
        this.requestName = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getRequestName() != null) {
            stringBuilder.append(this.getRequestName()).append("\n");
        }
        stringBuilder.append("\tFormats: ");
        for (String object : this.getFormats()) {
            stringBuilder.append("\t").append(object).append(", ");
        }
        stringBuilder.append("\n\tDCPTypes:\n");
        for (OGCDCType oGCDCType : this.getDCPTypes()) {
            stringBuilder.append("\t\t").append(oGCDCType.toString()).append("\n");
        }
        return stringBuilder.toString();
    }
}

