/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom.coords;

import gov.nasa.worldwind.geom.coords.PolarCoordConverter;
import gov.nasa.worldwind.globes.Globe;

public class UPSCoordConverter {
    public static final int UPS_NO_ERROR = 0;
    private static final int UPS_LAT_ERROR = 1;
    private static final int UPS_LON_ERROR = 2;
    public static final int UPS_HEMISPHERE_ERROR = 4;
    public static final int UPS_EASTING_ERROR = 8;
    public static final int UPS_NORTHING_ERROR = 16;
    private static final int UPS_A_ERROR = 32;
    private static final int UPS_INV_F_ERROR = 64;
    private static final double PI = Math.PI;
    private static final double MAX_LAT = 1.5707963267948966;
    private static final double MIN_NORTH_LAT = 1.2566370614359172;
    private static final double MIN_SOUTH_LAT = -1.2566370614359172;
    private static final double MAX_ORIGIN_LAT = 1.4157155848011311;
    private static final double MIN_EAST_NORTH = 0.0;
    private static final double MAX_EAST_NORTH = 4000000.0;
    private double UPS_Origin_Latitude = 1.4157155848011311;
    private double UPS_Origin_Longitude = 0.0;
    private final Globe globe;
    private double UPS_a = 6378137.0;
    private double UPS_f = 0.0033528106647474805;
    private double UPS_False_Easting = 2000000.0;
    private double UPS_False_Northing = 2000000.0;
    private double false_easting = 0.0;
    private double false_northing = 0.0;
    private double UPS_Easting = 0.0;
    private double UPS_Northing = 0.0;
    private double Easting = 0.0;
    private double Northing = 0.0;
    private String Hemisphere = "gov.nasa.worldwind.avkey.North";
    private double Latitude = 0.0;
    private double Longitude = 0.0;
    private PolarCoordConverter polarConverter = new PolarCoordConverter();

    UPSCoordConverter(Globe globe) {
        this.globe = globe;
        if (globe != null) {
            double d = globe.getEquatorialRadius();
            double d2 = (globe.getEquatorialRadius() - globe.getPolarRadius()) / globe.getEquatorialRadius();
            this.setUPSParameters(d, d2);
        }
    }

    public long setUPSParameters(double d, double d2) {
        double d3 = 1.0 / d2;
        if (d <= 0.0) {
            return 32L;
        }
        if (d3 < 250.0 || d3 > 350.0) {
            return 64L;
        }
        this.UPS_a = d;
        this.UPS_f = d2;
        return 0L;
    }

    public long convertGeodeticToUPS(double d, double d2) {
        if (d < -1.5707963267948966 || d > 1.5707963267948966) {
            return 1L;
        }
        if (d < 0.0 && d > -1.2566370614359172) {
            return 1L;
        }
        if (d >= 0.0 && d < 1.2566370614359172) {
            return 1L;
        }
        if (d2 < -Math.PI || d2 > Math.PI * 2) {
            return 2L;
        }
        if (d < 0.0) {
            this.UPS_Origin_Latitude = -1.4157155848011311;
            this.Hemisphere = "gov.nasa.worldwdind.avkey.South";
        } else {
            this.UPS_Origin_Latitude = 1.4157155848011311;
            this.Hemisphere = "gov.nasa.worldwind.avkey.North";
        }
        this.polarConverter.setPolarStereographicParameters(this.UPS_a, this.UPS_f, this.UPS_Origin_Latitude, this.UPS_Origin_Longitude, this.false_easting, this.false_northing);
        this.polarConverter.convertGeodeticToPolarStereographic(d, d2);
        this.UPS_Easting = this.UPS_False_Easting + this.polarConverter.getEasting();
        this.UPS_Northing = this.UPS_False_Northing + this.polarConverter.getNorthing();
        if ("gov.nasa.worldwdind.avkey.South".equals(this.Hemisphere)) {
            this.UPS_Northing = this.UPS_False_Northing - this.polarConverter.getNorthing();
        }
        this.Easting = this.UPS_Easting;
        this.Northing = this.UPS_Northing;
        return 0L;
    }

    public double getEasting() {
        return this.Easting;
    }

    public double getNorthing() {
        return this.Northing;
    }

    public String getHemisphere() {
        return this.Hemisphere;
    }

    public long convertUPSToGeodetic(String string, double d, double d2) {
        long l = 0L;
        if (!"gov.nasa.worldwind.avkey.North".equals(string) && !"gov.nasa.worldwdind.avkey.South".equals(string)) {
            l |= 4L;
        }
        if (d < 0.0 || d > 4000000.0) {
            l |= 8L;
        }
        if (d2 < 0.0 || d2 > 4000000.0) {
            l |= 0x10L;
        }
        if ("gov.nasa.worldwind.avkey.North".equals(string)) {
            this.UPS_Origin_Latitude = 1.4157155848011311;
        }
        if ("gov.nasa.worldwdind.avkey.South".equals(string)) {
            this.UPS_Origin_Latitude = -1.4157155848011311;
        }
        if (l == 0L) {
            this.polarConverter.setPolarStereographicParameters(this.UPS_a, this.UPS_f, this.UPS_Origin_Latitude, this.UPS_Origin_Longitude, this.UPS_False_Easting, this.UPS_False_Northing);
            this.polarConverter.convertPolarStereographicToGeodetic(d, d2);
            this.Latitude = this.polarConverter.getLatitude();
            this.Longitude = this.polarConverter.getLongitude();
            if (this.Latitude < 0.0 && this.Latitude > -1.2566370614359172) {
                l |= 1L;
            }
            if (this.Latitude >= 0.0 && this.Latitude < 1.2566370614359172) {
                l |= 1L;
            }
        }
        return l;
    }

    public double getLatitude() {
        return this.Latitude;
    }

    public double getLongitude() {
        return this.Longitude;
    }
}

