/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom.coords;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.coords.TMCoordConverter;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;

public class TMCoord {
    private final Angle latitude;
    private final Angle longitude;
    private final Angle originLatitude;
    private final Angle centralMeridian;
    private final double falseEasting;
    private final double falseNorthing;
    private final double scale;
    private final double easting;
    private final double northing;

    public static TMCoord fromLatLon(Angle angle, Angle angle2, Globe globe, Double d, Double d2, Angle angle3, Angle angle4, double d3, double d4, double d5) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle3 == null || angle4 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        TMCoordConverter tMCoordConverter = new TMCoordConverter();
        if (globe != null) {
            d = globe.getEquatorialRadius();
            d2 = (globe.getEquatorialRadius() - globe.getPolarRadius()) / globe.getEquatorialRadius();
        } else if (d == null || d2 == null) {
            d = tMCoordConverter.getA();
            d2 = tMCoordConverter.getF();
        }
        long l = tMCoordConverter.setTransverseMercatorParameters(d, d2, angle3.radians, angle4.radians, d3, d4, d5);
        if (l == 0L) {
            l = tMCoordConverter.convertGeodeticToTransverseMercator(angle.radians, angle2.radians);
        }
        if (l != 0L && l != 512L) {
            String string = Logging.getMessage("Coord.TMConversionError");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new TMCoord(angle, angle2, tMCoordConverter.getEasting(), tMCoordConverter.getNorthing(), angle3, angle4, d3, d4, d5);
    }

    public static TMCoord fromTM(double d, double d2, Globe globe, Angle angle, Angle angle2, double d3, double d4, double d5) {
        double d6;
        double d7;
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        TMCoordConverter tMCoordConverter = new TMCoordConverter();
        if (globe != null) {
            d7 = globe.getEquatorialRadius();
            d6 = (globe.getEquatorialRadius() - globe.getPolarRadius()) / globe.getEquatorialRadius();
        } else {
            d7 = tMCoordConverter.getA();
            d6 = tMCoordConverter.getF();
        }
        long l = tMCoordConverter.setTransverseMercatorParameters(d7, d6, angle.radians, angle2.radians, d3, d4, d5);
        if (l == 0L) {
            l = tMCoordConverter.convertTransverseMercatorToGeodetic(d, d2);
        }
        if (l != 0L && l != 512L) {
            String string = Logging.getMessage("Coord.TMConversionError");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new TMCoord(Angle.fromRadians(tMCoordConverter.getLatitude()), Angle.fromRadians(tMCoordConverter.getLongitude()), d, d2, angle, angle2, d3, d4, d5);
    }

    public TMCoord(Angle angle, Angle angle2, double d, double d2, Angle angle3, Angle angle4, double d3, double d4, double d5) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle3 == null || angle4 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.latitude = angle;
        this.longitude = angle2;
        this.easting = d;
        this.northing = d2;
        this.originLatitude = angle3;
        this.centralMeridian = angle4;
        this.falseEasting = d3;
        this.falseNorthing = d4;
        this.scale = d5;
    }

    public Angle getLatitude() {
        return this.latitude;
    }

    public Angle getLongitude() {
        return this.longitude;
    }

    public Angle getOriginLatitude() {
        return this.originLatitude;
    }

    public Angle getCentralMeridian() {
        return this.centralMeridian;
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    public double getScale() {
        return this.scale;
    }

    public double getEasting() {
        return this.easting;
    }

    public double getNorthing() {
        return this.northing;
    }
}

