/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.rpf.RPFBoundingRectangleSection;
import gov.nasa.worldwind.formats.rpf.RPFFrameFileIndexSection;
import gov.nasa.worldwind.formats.rpf.RPFHeaderSection;
import gov.nasa.worldwind.formats.rpf.RPFLocationSection;
import java.nio.ByteBuffer;

public class RPFFileComponents {
    private ByteBuffer buffer;
    private RPFHeaderSection headerSection;
    private RPFLocationSection locationSection;

    public RPFFileComponents(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
        this.headerSection = new RPFHeaderSection(byteBuffer);
        byteBuffer.position(this.headerSection.locationSectionLocation);
        this.locationSection = new RPFLocationSection(byteBuffer);
    }

    public RPFHeaderSection getRPFHeaderSection() {
        return this.headerSection;
    }

    public RPFFrameFileIndexSection getRPFFrameFileIndexSection() {
        if (0 < this.locationSection.getFrameFileIndexSectionSubheaderLength()) {
            this.buffer.position(this.locationSection.getFrameFileIndexSectionSubheaderLocation());
            return new RPFFrameFileIndexSection(this.buffer);
        }
        return null;
    }

    public RPFBoundingRectangleSection getRPFBoundingRectangleSection() {
        if (0 < this.locationSection.getBoundaryRectangleSectionSubheaderLength()) {
            this.buffer.position(this.locationSection.getBoundaryRectangleSectionSubheaderLocation());
            return new RPFBoundingRectangleSection(this.buffer);
        }
        return null;
    }
}

