/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import org.gdal.gdal.Dataset;
import org.gdal.osr.SpatialReference;

public class GDALMetadata {
    protected static final String NITF_ONAME = "NITF_ONAME";
    protected static final String NITF_ISORCE = "NITF_ISORCE";
    protected static final String NITF_IREP = "NITF_IREP";
    protected static final String NITF_ABPP = "NITF_ABPP";
    protected static final String NITF_FBKGC = "NITF_FBKGC";
    protected static final String NITF_DYNAMIC_RANGE = "NITF_USE00A_DYNAMIC_RANGE";

    protected GDALMetadata() {
    }

    public static AVList extractExtendedAndFormatSpecificMetadata(Dataset dataset, AVList aVList, AVList aVList2) throws IllegalArgumentException, WWRuntimeException {
        if (null == dataset) {
            String string = Logging.getMessage("nullValue.DataSetIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (null == aVList) {
            aVList = new AVListImpl();
        }
        try {
            Hashtable hashtable = dataset.GetMetadata_Dict("");
            if (null != hashtable) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string;
                    Object v;
                    Object k = enumeration.nextElement();
                    if (null == k || !(k instanceof String) || WWUtil.isEmpty(v = hashtable.get(string = (String)k))) continue;
                    aVList.setValue(string, v);
                }
            }
        }
        catch (Throwable throwable) {
            Logging.logger().log(Level.FINE, throwable.getMessage(), throwable);
        }
        return GDALMetadata.mapExtendedMetadata(dataset, aVList, aVList2);
    }

    protected static AVList mapExtendedMetadata(Dataset dataset, AVList aVList, AVList aVList2) {
        String string;
        AVList aVList3 = aVList2 = null == aVList2 ? new AVListImpl() : aVList2;
        if (null == aVList) {
            return aVList2;
        }
        GDALMetadata.convertToWorldWind(aVList, aVList2);
        String string2 = string = null != dataset ? dataset.GetDriver().getShortName() : "";
        if ("NITF".equals(string)) {
            GDALMetadata.mapNITFMetadata(aVList, aVList2);
        }
        return aVList2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void mapNITFMetadata(AVList aVList, AVList aVList2) {
        String[] stringArray;
        Object object;
        if (aVList.hasKey(NITF_ONAME)) {
            // empty if block
        }
        if (aVList.hasKey(NITF_ISORCE)) {
            // empty if block
        }
        if (aVList.hasKey(NITF_IREP)) {
            // empty if block
        }
        if (aVList.hasKey(NITF_ABPP) && !WWUtil.isEmpty(object = aVList.getValue(NITF_ABPP)) && object instanceof String && null != (stringArray = WWUtil.convertStringToInteger((String)object))) {
            aVList2.setValue("gov.nasa.worldwind.avkey.RasterBand.ActualBitsPerPixel", stringArray);
        }
        if (aVList.hasKey(NITF_DYNAMIC_RANGE) && !WWUtil.isEmpty(object = aVList.getValue(NITF_DYNAMIC_RANGE)) && object instanceof String && null != (stringArray = WWUtil.convertStringToDouble((String)object))) {
            aVList2.setValue("gov.nasa.worldwind.avkey.RasterBand.MaxPixelValue", stringArray);
        }
        if (!aVList.hasKey(NITF_FBKGC) || WWUtil.isEmpty(object = aVList.getValue(NITF_FBKGC)) || !(object instanceof String)) return;
        try {
            stringArray = ((String)object).split(",");
            if (null == stringArray) return;
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.CannotCreateColor", object);
            Logging.logger().severe(string);
        }
    }

    public static AVList convertToWorldWind(AVList aVList, AVList aVList2) {
        String string;
        String string2;
        String string3;
        String string4;
        if (null == aVList2) {
            aVList2 = new AVListImpl();
        }
        if (null == aVList) {
            return aVList2;
        }
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        Integer n = null;
        if (aVList.hasKey("GEOTIFF_CHAR__ProjectedCSTypeGeoKey")) {
            int n2;
            string5 = aVList.getStringValue("GEOTIFF_CHAR__ProjectedCSTypeGeoKey");
            string5 = null != string5 ? string5.toUpperCase() : null;
            int n3 = n2 = null != string5 ? string5.indexOf("ZONE_") : -1;
            if (n2 != -1) {
                string6 = string5.substring(n2 + 5, string5.length());
                String string10 = string6 = null != string6 ? string6.toUpperCase() : null;
            }
        }
        if (null == string5 && aVList.hasKey("IMG__PROJECTION_NAME")) {
            string5 = aVList.getStringValue("IMG__PROJECTION_NAME");
            String string11 = string5 = null != string5 ? string5.toUpperCase() : null;
        }
        if (null == string6 && aVList.hasKey("IMG__PROJECTION_ZONE")) {
            string6 = aVList.getStringValue("IMG__PROJECTION_ZONE");
            String string12 = string6 = null != string6 ? string6.toUpperCase() : null;
        }
        if (null != string5 && string5.contains("UTM")) {
            aVList2.setValue("gov.nasa.worldwind.avkey.CoordinateSystem", "gov.nasa.worldwind.avkey.CoordinateSystem.Projected");
            aVList2.setValue("gov.nasa.worldwind.avkey.Projection.Name", "gov.nasa.worldwind.avkey.Projection.UTM");
            if (null != string6) {
                if (string6.endsWith("N")) {
                    aVList2.setValue("gov.nasa.worldwind.avkey.Projection.Hemisphere", "gov.nasa.worldwind.avkey.North");
                    string6 = string6.substring(0, string6.length() - 1);
                } else if (string6.endsWith("S")) {
                    aVList2.setValue("gov.nasa.worldwind.avkey.Projection.Hemisphere", "gov.nasa.worldwdind.avkey.South");
                    string6 = string6.substring(0, string6.length() - 1);
                }
                Integer n4 = WWUtil.makeInteger(string6.trim());
                if (n4 != null && n4 >= 1 && n4 <= 60) {
                    aVList2.setValue("gov.nasa.worldwind.avkey.Projection.Zone", n4);
                }
            }
        }
        if (aVList.hasKey("IMG__SPHEROID_NAME") && (string4 = aVList.getStringValue("IMG__SPHEROID_NAME")) != null && (string4 = string4.toUpperCase()).contains("WGS") && string4.contains("84")) {
            string8 = "WGS84";
            string7 = "WGS84";
            aVList2.setValue("gov.nasa.worldwind.avkey.Projection.Datum", string8);
        }
        if (aVList.hasKey("IMG__HORIZONTAL_UNITS") && (string3 = aVList.getStringValue("IMG__HORIZONTAL_UNITS")) != null) {
            if ((string3 = string3.toLowerCase()).contains("meter") || string3.contains("metre")) {
                string9 = "gov.nasa.worldwind.avkey.Unit.Meter";
            }
            if (string3.contains("feet") || string3.contains("foot")) {
                string9 = "gov.nasa.worldwind.avkey.Unit.Foot";
            }
            if (null != string9) {
                aVList2.setValue("gov.nasa.worldwind.avkey.Projection.Units", string9);
            }
        }
        if (aVList.hasKey("GEOTIFF_NUM__3072__ProjectedCSTypeGeoKey") && (string2 = aVList.getStringValue("GEOTIFF_NUM__3072__ProjectedCSTypeGeoKey")) != null) {
            n = WWUtil.makeInteger(string2.trim());
        }
        if (null == n && aVList.hasKey("GEO__ProjectedCSTypeGeoKey") && (string = aVList.getStringValue("GEO__ProjectedCSTypeGeoKey")) != null) {
            n = WWUtil.makeInteger(string.trim());
        }
        if (null != n) {
            aVList2.setValue("gov.nasa.worldwind.avkey.Projection.EPSG.Code", n);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if ("gov.nasa.worldwind.avkey.CoordinateSystem.Projected".equals(aVList2.getValue("gov.nasa.worldwind.avkey.CoordinateSystem"))) {
            if ("gov.nasa.worldwind.avkey.Projection.UTM".equals(aVList2.getValue("gov.nasa.worldwind.avkey.Projection.Name"))) {
                stringBuffer.append("+proj=utm");
            }
            if (aVList2.hasKey("gov.nasa.worldwind.avkey.Projection.Zone")) {
                stringBuffer.append(" +zone=").append(aVList2.getValue("gov.nasa.worldwind.avkey.Projection.Zone"));
            }
            if (aVList2.hasKey("gov.nasa.worldwind.avkey.Projection.Datum")) {
                stringBuffer.append(" +ellps=").append(aVList2.getValue("gov.nasa.worldwind.avkey.Projection.Datum"));
                stringBuffer.append(" +datum=").append(aVList2.getValue("gov.nasa.worldwind.avkey.Projection.Datum"));
            }
            if (aVList2.hasKey("gov.nasa.worldwind.avkey.Projection.Units")) {
                stringBuffer.append(" +units=").append("gov.nasa.worldwind.avkey.Unit.Meter".equals(aVList2.getValue("gov.nasa.worldwind.avkey.Projection.Units")) ? "m" : "f");
            }
            try {
                SpatialReference spatialReference = new SpatialReference();
                spatialReference.ImportFromProj4(stringBuffer.toString());
                aVList2.setValue("gov.nasa.worldwind.avkey.SpatialReference.WKT", spatialReference.ExportToWkt());
            }
            catch (Throwable throwable) {
                Logging.logger().log(Level.FINEST, throwable.getMessage(), throwable);
            }
        }
        return aVList2;
    }
}

