/*
 * Decompiled with CFR 0.152.
 */
package jams.explorer.gui;

import jams.JAMS;
import jams.JAMSLogging;
import jams.data.Attribute;
import jams.data.JAMSCalendar;
import jams.explorer.gui.CancelableSwingWorker;
import jams.explorer.gui.DSPanel;
import jams.explorer.spreadsheet.JAMSSpreadSheet;
import jams.gui.tools.GUIHelper;
import jams.tools.StringTools;
import jams.workspace.dsproc.AbstractDataStoreProcessor;
import jams.workspace.dsproc.DataMatrix;
import jams.workspace.dsproc.DataStoreProcessor;
import jams.workspace.dsproc.TimeSpaceProcessor;
import jams.workspace.stores.ShapeFileDataStore;
import jams.worldwind.data.DataTransfer3D;
import jams.worldwind.ui.view.GlobeView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TimeSpaceDSPanel
extends DSPanel {
    private static final Dimension LIST_DIMENSION = new Dimension(450, 270);
    private TimeSpaceProcessor proc;
    private GridBagLayout mainLayout;
    private JList timeList;
    private JList entityList;
    private JList monthList;
    private JList yearList;
    private JTextField timeField;
    private JPanel outerPanel;
    private JPanel aggregationPanel;
    private GridBagLayout aggregationLayout;
    private final HashMap<String, DSPanel.AttribRadioButton> defaultWeightingMap = new HashMap();
    private final HashMap<String, DSPanel.AttribRadioButton> defaultAggregationMap = new HashMap();
    private final Action[] actions = new Action[]{new AbstractAction(JAMS.i18n((String)"TIME_STEP")){

        @Override
        public void actionPerformed(ActionEvent e) {
            TimeSpaceDSPanel.this.showTimeStep();
        }
    }, new AbstractAction(JAMS.i18n((String)"TEMP._MEAN")){

        @Override
        public void actionPerformed(ActionEvent e) {
            TimeSpaceDSPanel.this.showTempMean();
        }
    }, new AbstractAction(JAMS.i18n((String)"SPATIAL_ENTITY")){

        @Override
        public void actionPerformed(ActionEvent e) {
            TimeSpaceDSPanel.this.showSpatEntity();
        }
    }, new AbstractAction(JAMS.i18n((String)"SPATIAL_MEAN")){

        @Override
        public void actionPerformed(ActionEvent e) {
            TimeSpaceDSPanel.this.showSpatEntity();
        }
    }, new AbstractAction(JAMS.i18n((String)"CROSSPRODUCT")){

        @Override
        public void actionPerformed(ActionEvent e) {
            TimeSpaceDSPanel.this.showCrossProduct();
        }
    }, new AbstractAction(JAMS.i18n((String)"TO_WW")){

        @Override
        public void actionPerformed(ActionEvent e) {
            TimeSpaceDSPanel.this.showInWorldWind();
            GlobeView.getInstance().toTop();
        }
    }, new AbstractAction(JAMS.i18n((String)"MONTHLY_MEAN")){

        @Override
        public void actionPerformed(ActionEvent e) {
            TimeSpaceDSPanel.this.showMonthlyMean();
        }
    }, new AbstractAction(JAMS.i18n((String)"YEARLY_MEAN")){

        @Override
        public void actionPerformed(ActionEvent e) {
            TimeSpaceDSPanel.this.showYearlyMean();
        }
    }};
    private final Action timePoint = this.actions[0];
    private final Action timeMean = this.actions[1];
    private final Action spacePoint = this.actions[2];
    private final Action spaceMean = this.actions[3];
    private final Action crossProduct = this.actions[4];
    private final Action toWW = this.actions[5];
    private final Action monthMean = this.actions[6];
    private final Action yearMean = this.actions[7];
    private final Action cacheReset = new AbstractAction(JAMS.i18n((String)"RESET_CACHES")){

        @Override
        public void actionPerformed(ActionEvent e) {
            TimeSpaceDSPanel.this.resetCaches();
        }
    };
    private final Action indexReset = new AbstractAction(JAMS.i18n((String)"RELOAD_INDEX")){

        @Override
        public void actionPerformed(ActionEvent e) {
            TimeSpaceDSPanel.this.resetIndex();
        }
    };
    private final Action freeTempMean = new AbstractAction(JAMS.i18n((String)"TEMP._MEAN_(FILTER)")){

        @Override
        public void actionPerformed(ActionEvent e) {
            TimeSpaceDSPanel.this.showFreeTempMean();
        }
    };

    public TimeSpaceDSPanel() {
        this.init();
    }

    private void init() {
        JButton button;
        JAMSLogging.registerLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.Show, (Logger)Logger.getLogger(TimeSpaceDSPanel.class.getName()));
        for (Action a : this.actions) {
            a.setEnabled(false);
        }
        this.freeTempMean.setEnabled(false);
        this.cacheReset.setEnabled(false);
        this.indexReset.setEnabled(false);
        this.outerPanel = new JPanel();
        this.mainLayout = new GridBagLayout();
        this.outerPanel.setLayout(this.mainLayout);
        this.timeList = new JList();
        this.timeList.setSelectionMode(2);
        JScrollPane timeListScroll = new JScrollPane(this.timeList);
        timeListScroll.setVerticalScrollBarPolicy(22);
        this.timeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (TimeSpaceDSPanel.this.timeList.getSelectedValues().length == 1) {
                        TimeSpaceDSPanel.this.timePoint.setEnabled(true);
                        TimeSpaceDSPanel.this.timeMean.setEnabled(false);
                        if (TimeSpaceDSPanel.this.entityList.getSelectedValues().length > 0) {
                            TimeSpaceDSPanel.this.crossProduct.setEnabled(true);
                            TimeSpaceDSPanel.this.toWW.setEnabled(true);
                        }
                    } else if (TimeSpaceDSPanel.this.timeList.getSelectedValues().length > 1) {
                        TimeSpaceDSPanel.this.timePoint.setEnabled(false);
                        TimeSpaceDSPanel.this.timeMean.setEnabled(true);
                        if (TimeSpaceDSPanel.this.entityList.getSelectedValues().length > 0) {
                            TimeSpaceDSPanel.this.crossProduct.setEnabled(true);
                            TimeSpaceDSPanel.this.toWW.setEnabled(true);
                        }
                    } else {
                        TimeSpaceDSPanel.this.timePoint.setEnabled(false);
                        TimeSpaceDSPanel.this.timeMean.setEnabled(false);
                        TimeSpaceDSPanel.this.crossProduct.setEnabled(false);
                    }
                }
            }
        });
        this.timeList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() >= 2) {
                    int begn = 0;
                    int end = list.getModel().getSize() - 1;
                    if (end >= 0) {
                        list.setSelectionInterval(begn, end);
                    }
                }
            }
        });
        this.entityList = new JList();
        JScrollPane entityListScroll = new JScrollPane(this.entityList);
        entityListScroll.setVerticalScrollBarPolicy(22);
        this.entityList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (TimeSpaceDSPanel.this.entityList.getSelectedValues().length == 1) {
                        TimeSpaceDSPanel.this.spacePoint.setEnabled(true);
                        TimeSpaceDSPanel.this.spaceMean.setEnabled(false);
                        if (TimeSpaceDSPanel.this.timeList.getSelectedValues().length > 0) {
                            TimeSpaceDSPanel.this.crossProduct.setEnabled(true);
                            TimeSpaceDSPanel.this.toWW.setEnabled(true);
                        }
                    } else if (TimeSpaceDSPanel.this.entityList.getSelectedValues().length > 1) {
                        TimeSpaceDSPanel.this.spacePoint.setEnabled(false);
                        TimeSpaceDSPanel.this.spaceMean.setEnabled(true);
                        if (TimeSpaceDSPanel.this.timeList.getSelectedValues().length > 0) {
                            TimeSpaceDSPanel.this.crossProduct.setEnabled(true);
                            TimeSpaceDSPanel.this.toWW.setEnabled(true);
                        }
                    } else {
                        TimeSpaceDSPanel.this.spacePoint.setEnabled(false);
                        TimeSpaceDSPanel.this.spaceMean.setEnabled(false);
                        TimeSpaceDSPanel.this.crossProduct.setEnabled(false);
                    }
                }
            }
        });
        this.entityList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() >= 2) {
                    int begn = 0;
                    int end = list.getModel().getSize() - 1;
                    if (end >= 0) {
                        list.setSelectionInterval(begn, end);
                    }
                }
            }
        });
        this.monthList = new JList();
        this.monthList.setSelectionMode(0);
        JScrollPane monthListScroll = new JScrollPane(this.monthList);
        this.monthList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (TimeSpaceDSPanel.this.monthList.getSelectedValues().length == 1) {
                        TimeSpaceDSPanel.this.monthMean.setEnabled(true);
                    } else {
                        TimeSpaceDSPanel.this.monthMean.setEnabled(false);
                    }
                }
            }
        });
        this.yearList = new JList();
        this.yearList.setSelectionMode(0);
        JScrollPane yearListScroll = new JScrollPane(this.yearList);
        this.yearList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (TimeSpaceDSPanel.this.yearList.getSelectedValues().length == 1) {
                        TimeSpaceDSPanel.this.yearMean.setEnabled(true);
                    } else {
                        TimeSpaceDSPanel.this.yearMean.setEnabled(false);
                    }
                }
            }
        });
        GUIHelper.addGBComponent((Container)this.outerPanel, (GridBagLayout)this.mainLayout, (Component)new JLabel(JAMS.i18n((String)"ATTRIBUTE/AGGREGATION:")), (int)0, (int)10, (int)1, (int)1, (double)0.0, (double)0.0);
        this.aggregationLayout = new GridBagLayout();
        this.aggregationPanel = new JPanel();
        this.aggregationPanel.setAutoscrolls(true);
        this.aggregationPanel.setLayout(this.aggregationLayout);
        JScrollPane aggregationScroll = new JScrollPane(this.aggregationPanel);
        aggregationScroll.setVerticalScrollBarPolicy(22);
        aggregationScroll.setPreferredSize(LIST_DIMENSION);
        aggregationScroll.getVerticalScrollBar().setUnitIncrement(50);
        GUIHelper.addGBComponent((Container)this.outerPanel, (GridBagLayout)this.mainLayout, (Component)aggregationScroll, (int)0, (int)20, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.outerPanel, (GridBagLayout)this.mainLayout, (Component)new JLabel(JAMS.i18n((String)"TIME_STEPS:")), (int)10, (int)10, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.outerPanel, (GridBagLayout)this.mainLayout, (Component)timeListScroll, (int)10, (int)20, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.outerPanel, (GridBagLayout)this.mainLayout, (Component)new JLabel(JAMS.i18n((String)"ENTITIY_IDS:")), (int)20, (int)10, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.outerPanel, (GridBagLayout)this.mainLayout, (Component)entityListScroll, (int)20, (int)20, (int)1, (int)1, (double)0.0, (double)0.0);
        JPanel buttonPanelA = new JPanel();
        GridBagLayout panelALayout = new GridBagLayout();
        buttonPanelA.setLayout(panelALayout);
        for (int i = 0; i <= 5; ++i) {
            Action a = this.actions[i];
            button = new JButton(a);
            GUIHelper.addGBComponent((Container)buttonPanelA, (GridBagLayout)panelALayout, (Component)button, (int)0, (int)i, (int)1, (int)1, (double)0.0, (double)0.0);
        }
        JPanel filterPanel = new JPanel();
        GridBagLayout filterPanelLayout = new GridBagLayout();
        filterPanel.setLayout(filterPanelLayout);
        filterPanel.setBorder(BorderFactory.createEtchedBorder());
        GUIHelper.addGBComponent((Container)filterPanel, (GridBagLayout)filterPanelLayout, (Component)new JLabel(JAMS.i18n((String)"TIME_FILTER:")), (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
        this.timeField = new JTextField();
        this.timeField.setPreferredSize(new Dimension(100, 20));
        this.timeField.setEnabled(false);
        this.timeField.setToolTipText(JAMS.i18n((String)"DATE_EXPRESSION_WITH_WILDCARDS"));
        this.timeField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                TimeSpaceDSPanel.this.toggleFreeTempMeanButton();
            }
        });
        this.timeField.addActionListener(this.freeTempMean);
        GUIHelper.addGBComponent((Container)filterPanel, (GridBagLayout)filterPanelLayout, (Component)this.timeField, (int)0, (int)10, (int)1, (int)1, (double)0.0, (double)0.0);
        button = new JButton(this.freeTempMean);
        GUIHelper.addGBComponent((Container)filterPanel, (GridBagLayout)filterPanelLayout, (Component)button, (int)0, (int)20, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)buttonPanelA, (GridBagLayout)panelALayout, (Component)filterPanel, (int)0, (int)10, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.outerPanel, (GridBagLayout)this.mainLayout, (Component)buttonPanelA, (int)40, (int)20, (int)1, (int)1, (double)0.0, (double)0.0);
        this.add(this.outerPanel);
    }

    public static void main_(String[] args) throws Exception {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        TimeSpaceDSPanel tsp = new TimeSpaceDSPanel();
        JFrame frame = new JFrame();
        JScrollPane scroll = new JScrollPane(tsp);
        frame.add(scroll);
        frame.setPreferredSize(new Dimension(800, 500));
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
        LogManager.getLogManager().reset();
        Logger globalLogger = Logger.getLogger("");
        GUIHelper.setupLogHandler((Logger)globalLogger, null);
        DataStoreProcessor dsdb = new DataStoreProcessor(new File("d:/jamsapplication/JAMS-Gehlberg/output/current/HRULoop.dat"));
        dsdb.addImportProgressObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                System.out.println("IMPORT PROGRESS: " + arg);
            }
        });
        if (!dsdb.existsH2DBFiles()) {
            dsdb.createDB();
        }
        TimeSpaceProcessor tsproc = new TimeSpaceProcessor((AbstractDataStoreProcessor)dsdb);
        tsp.setTsProc(tsproc);
    }

    public TimeSpaceProcessor getProc() {
        return this.proc;
    }

    private void createDB() {
        this.workerDlg.setInderminate(false);
        this.workerDlg.setTask(new CancelableSwingWorker(){

            @Override
            public int cancel() {
                TimeSpaceDSPanel.this.dsdb.cancelCreateIndex();
                return -1;
            }

            public Object doInBackground() {
                try {
                    TimeSpaceDSPanel.this.dsdb.createDB();
                }
                catch (IOException ex) {
                    Logger.getLogger(TimeSpaceDSPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (SQLException ex) {
                    Logger.getLogger(TimeSpaceDSPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ClassNotFoundException ex) {
                    Logger.getLogger(TimeSpaceDSPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                return null;
            }
        });
        try {
            if (!this.dsdb.existsH2DB() || this.dsdb.isDBObsolete()) {
                this.workerDlg.execute();
            }
            if (!this.dsdb.existsH2DB()) {
                this.clearPanel();
            }
            this.setTsProc(new TimeSpaceProcessor(this.dsdb));
        }
        catch (SQLException ex) {
            Logger.getLogger(TimeSpaceDSPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(TimeSpaceDSPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void resetIndex() {
        try {
            this.dsdb.clearDB();
        }
        catch (SQLException ex) {
            Logger.getLogger(TimeSpaceDSPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.createDB();
    }

    private void setTsProc(TimeSpaceProcessor tsproc) throws SQLException, IOException {
        this.proc = tsproc;
        this.timeList.setModel(new AbstractListModel(){
            JAMSCalendar[] dates;
            {
                this.dates = TimeSpaceDSPanel.this.getProc().getTimeSteps();
            }

            @Override
            public int getSize() {
                return this.dates.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.dates[i];
            }
        });
        this.entityList.setModel(new AbstractListModel(){
            Long[] ids;
            {
                this.ids = TimeSpaceDSPanel.this.getProc().getEntityIDs();
            }

            @Override
            public int getSize() {
                return this.ids.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.ids[i];
            }
        });
        this.yearList.setModel(new AbstractListModel(){
            int[] years;
            {
                this.years = TimeSpaceDSPanel.this.getProc().getYears();
            }

            @Override
            public int getSize() {
                return this.years.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.years[i];
            }
        });
        this.monthList.setModel(new AbstractListModel(){
            int[] months = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};

            @Override
            public int getSize() {
                return this.months.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.months[i];
            }
        });
        ArrayList attribs = this.getProc().getDataStoreProcessor().getAttributes();
        float scale = 0.6f;
        Dimension labelDim = new Dimension(30, 30);
        Image image = new ImageIcon(ClassLoader.getSystemResource("jams/explorer/resources/images/jade_mean.png")).getImage();
        image = image.getScaledInstance(Math.round((float)image.getWidth(null) * scale), Math.round((float)image.getHeight(null) * scale), 4);
        JLabel label = new JLabel(new ImageIcon(image));
        label.setPreferredSize(labelDim);
        label.setToolTipText(JAMS.i18n((String)"CALC_AVG"));
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)label, (int)10, (int)5, (int)1, (int)1, (double)0.0, (double)0.0);
        image = new ImageIcon(ClassLoader.getSystemResource("jams/explorer/resources/images/jade_sum.png")).getImage();
        image = image.getScaledInstance(Math.round((float)image.getWidth(null) * scale), Math.round((float)image.getHeight(null) * scale), 4);
        label = new JLabel(new ImageIcon(image));
        label.setPreferredSize(labelDim);
        label.setToolTipText(JAMS.i18n((String)"CALC_SUM"));
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)label, (int)12, (int)5, (int)1, (int)1, (double)0.0, (double)0.0);
        image = new ImageIcon(ClassLoader.getSystemResource("jams/explorer/resources/images/jade_wmean.png")).getImage();
        image = image.getScaledInstance(Math.round((float)image.getWidth(null) * scale), Math.round((float)image.getHeight(null) * scale), 4);
        label = new JLabel(new ImageIcon(image));
        label.setPreferredSize(labelDim);
        label.setToolTipText(JAMS.i18n((String)"CALC_WSUM"));
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)label, (int)14, (int)5, (int)1, (int)1, (double)0.0, (double)0.0);
        image = new ImageIcon(ClassLoader.getSystemResource("jams/explorer/resources/images/jade_y.png")).getImage();
        image = image.getScaledInstance(Math.round((float)image.getWidth(null) * scale), Math.round((float)image.getHeight(null) * scale), 4);
        label = new JLabel(new ImageIcon(image));
        label.setPreferredSize(labelDim);
        label.setToolTipText(JAMS.i18n((String)"POST_NOTHING"));
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)label, (int)20, (int)5, (int)1, (int)1, (double)0.0, (double)0.0);
        image = new ImageIcon(ClassLoader.getSystemResource("jams/explorer/resources/images/jade_ydiva.png")).getImage();
        image = image.getScaledInstance(Math.round((float)image.getWidth(null) * scale), Math.round((float)image.getHeight(null) * scale), 4);
        label = new JLabel(new ImageIcon(image));
        label.setPreferredSize(labelDim);
        label.setToolTipText(JAMS.i18n((String)"POST_DIVA"));
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)label, (int)22, (int)5, (int)1, (int)1, (double)0.0, (double)0.0);
        image = new ImageIcon(ClassLoader.getSystemResource("jams/explorer/resources/images/jade_ytimesa.png")).getImage();
        image = image.getScaledInstance(Math.round((float)image.getWidth(null) * scale), Math.round((float)image.getHeight(null) * scale), 4);
        label = new JLabel(new ImageIcon(image));
        label.setPreferredSize(labelDim);
        label.setToolTipText(JAMS.i18n((String)"POST_TIMESA"));
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)label, (int)24, (int)5, (int)1, (int)1, (double)0.0, (double)0.0);
        int i = 0;
        ArrayList<JCheckBox> allChecks = new ArrayList<JCheckBox>();
        for (AbstractDataStoreProcessor.AttributeData attrib : attribs) {
            DSPanel.AttribCheckBox attribCheck = new DSPanel.AttribCheckBox(attrib, attrib.getName());
            attribCheck.setSelected(attrib.isSelected());
            attribCheck.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DSPanel.AttribCheckBox thisCheck = (DSPanel.AttribCheckBox)e.getSource();
                    if (!thisCheck.isSelected() && TimeSpaceDSPanel.this.attribCombo.getSelectedItem().toString().equals(thisCheck.getText())) {
                        GUIHelper.showInfoDlg((Component)TimeSpaceDSPanel.this.parent, (String)JAMS.i18n((String)"AREA_ATTRIBUTE_HAS_BEEN_RESET!"), (String)JAMS.i18n((String)"INFO"));
                        TimeSpaceDSPanel.this.attribCombo.setSelectedIndex(0);
                        thisCheck.setSelected(false);
                    }
                    thisCheck.attrib.setSelected(thisCheck.isSelected());
                }
            });
            allChecks.add(attribCheck);
            GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)attribCheck, (int)5, (int)(i + 10), (int)1, (int)1, (double)0.0, (double)0.0);
            DSPanel.AttribRadioButton aggregationButton1 = new DSPanel.AttribRadioButton(attrib, 2);
            DSPanel.AttribRadioButton aggregationButton2 = new DSPanel.AttribRadioButton(attrib, 1);
            DSPanel.AttribRadioButton aggregationButton3 = new DSPanel.AttribRadioButton(attrib, 3);
            DSPanel.AttribRadioButton weightingButton1 = new DSPanel.AttribRadioButton(attrib, 1);
            DSPanel.AttribRadioButton weightingButton2 = new DSPanel.AttribRadioButton(attrib, 3);
            DSPanel.AttribRadioButton weightingButton3 = new DSPanel.AttribRadioButton(attrib, 2);
            ItemListener aggregationButtonListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        return;
                    }
                    DSPanel.AttribRadioButton thisButton = (DSPanel.AttribRadioButton)e.getSource();
                    if (TimeSpaceDSPanel.this.attribCombo.getSelectedIndex() == 0 && thisButton.processingType == 3) {
                        DSPanel.AttribRadioButton defaultButton = (DSPanel.AttribRadioButton)TimeSpaceDSPanel.this.defaultAggregationMap.get(thisButton.attrib.getName());
                        GUIHelper.showInfoDlg((Component)TimeSpaceDSPanel.this.parent, (String)String.format(JAMS.i18n((String)"NO_AREA_ATTRIBUTE_HAS_BEEN_CHOSEN!_SKIPPING_WEIGHTED_AGGREGATION_FOR_ATTRIBUTE"), thisButton.attrib.getName()));
                        if (defaultButton != null) {
                            defaultButton.setSelected(true);
                        }
                        return;
                    }
                    thisButton.attrib.setAggregationType(thisButton.processingType);
                    TimeSpaceDSPanel.this.setCheckBox(thisButton.attrib.getName());
                }
            };
            this.defaultAggregationMap.put(attrib.getName(), aggregationButton1);
            aggregationButton1.setSelected(true);
            this.defaultWeightingMap.put(attrib.getName(), weightingButton1);
            weightingButton1.setSelected(true);
            ItemListener weightingButtonListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        return;
                    }
                    DSPanel.AttribRadioButton thisButton = (DSPanel.AttribRadioButton)e.getSource();
                    if (TimeSpaceDSPanel.this.attribCombo.getSelectedIndex() == 0 && thisButton.processingType != 1) {
                        DSPanel.AttribRadioButton defaultButton = (DSPanel.AttribRadioButton)TimeSpaceDSPanel.this.defaultWeightingMap.get(thisButton.attrib.getName());
                        GUIHelper.showInfoDlg((Component)TimeSpaceDSPanel.this.parent, (String)String.format(JAMS.i18n((String)"NO_AREA_ATTRIBUTE_HAS_BEEN_CHOSEN!_SKIPPING_WEIGHTED_AGGREGATION_FOR_ATTRIBUTE"), thisButton.attrib.getName()));
                        if (defaultButton != null) {
                            defaultButton.setSelected(true);
                        }
                        return;
                    }
                    thisButton.attrib.setWeightingType(thisButton.processingType);
                    TimeSpaceDSPanel.this.setCheckBox(thisButton.attrib.getName());
                }
            };
            aggregationButton1.addItemListener(aggregationButtonListener);
            aggregationButton2.addItemListener(aggregationButtonListener);
            aggregationButton3.addItemListener(aggregationButtonListener);
            weightingButton1.addItemListener(weightingButtonListener);
            weightingButton2.addItemListener(weightingButtonListener);
            weightingButton3.addItemListener(weightingButtonListener);
            ButtonGroup bGroup1 = new ButtonGroup();
            bGroup1.add(aggregationButton1);
            bGroup1.add(aggregationButton2);
            bGroup1.add(aggregationButton3);
            ButtonGroup bGroup2 = new ButtonGroup();
            bGroup2.add(weightingButton1);
            bGroup2.add(weightingButton2);
            bGroup2.add(weightingButton3);
            GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)aggregationButton1, (int)10, (int)(i + 10), (int)1, (int)1, (double)0.0, (double)0.0, (int)11);
            GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)aggregationButton2, (int)12, (int)(i + 10), (int)1, (int)1, (double)0.0, (double)0.0, (int)11);
            GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)aggregationButton3, (int)14, (int)(i + 10), (int)1, (int)1, (double)0.0, (double)0.0, (int)11);
            GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)weightingButton1, (int)20, (int)(i + 10), (int)1, (int)1, (double)0.0, (double)0.0, (int)11);
            GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)weightingButton2, (int)22, (int)(i + 10), (int)1, (int)1, (double)0.0, (double)0.0, (int)11);
            GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)weightingButton3, (int)24, (int)(i + 10), (int)1, (int)1, (double)0.0, (double)0.0, (int)11);
            ++i;
        }
        JPanel space = new JPanel();
        Dimension spaceDim = new Dimension(2, 1);
        space.setPreferredSize(spaceDim);
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)space, (int)7, (int)5, (int)1, (int)1, (double)0.0, (double)0.0);
        JSeparator sep = new JSeparator();
        sep.setOrientation(1);
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)sep, (int)8, (int)4, (int)1, (int)(i + 8), (double)0.0, (double)0.0);
        space = new JPanel();
        space.setPreferredSize(spaceDim);
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)space, (int)9, (int)5, (int)1, (int)1, (double)0.0, (double)0.0);
        space = new JPanel();
        space.setPreferredSize(spaceDim);
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)space, (int)15, (int)5, (int)1, (int)1, (double)0.0, (double)0.0);
        sep = new JSeparator();
        sep.setOrientation(1);
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)sep, (int)16, (int)4, (int)1, (int)(i + 8), (double)0.0, (double)0.0);
        space = new JPanel();
        space.setPreferredSize(spaceDim);
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)space, (int)17, (int)5, (int)1, (int)1, (double)0.0, (double)0.0);
        space = new JPanel();
        space.setPreferredSize(spaceDim);
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)space, (int)25, (int)5, (int)1, (int)1, (double)0.0, (double)0.0);
        sep = new JSeparator();
        sep.setOrientation(0);
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)sep, (int)1, (int)7, (int)25, (int)1, (double)0.0, (double)0.0);
        sep = new JSeparator();
        sep.setOrientation(0);
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)sep, (int)1, (int)4, (int)25, (int)1, (double)0.0, (double)0.0);
        space = new JPanel();
        space.setPreferredSize(new Dimension(1, 5));
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)space, (int)5, (int)0, (int)1, (int)1, (double)0.0, (double)0.0, (int)11);
        space = new JPanel();
        space.setPreferredSize(new Dimension(1, 5));
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)space, (int)5, (int)2, (int)1, (int)1, (double)0.0, (double)0.0, (int)11);
        label = new JLabel(JAMS.i18n((String)"AREA_ATTRIBUTE"));
        label.setHorizontalTextPosition(4);
        label.setHorizontalAlignment(11);
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)label, (int)5, (int)1, (int)2, (int)1, (double)1.0, (double)0.0, (int)1);
        String[] attribNames = new String[attribs.size() + 1];
        attribNames[0] = JAMS.i18n((String)"[CHOOSE]");
        i = 1;
        for (AbstractDataStoreProcessor.AttributeData attrib : attribs) {
            attribNames[i++] = attrib.getName();
        }
        this.attribCombo = new DSPanel.AttribComboBox(allChecks);
        this.attribCombo.setModel(new DefaultComboBoxModel<String>(attribNames));
        this.attribCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DSPanel.AttribComboBox thisCombo = (DSPanel.AttribComboBox)e.getSource();
                if (thisCombo.getSelectedIndex() != 0) {
                    TimeSpaceDSPanel.this.setCheckBox(thisCombo.getSelectedItem().toString());
                } else {
                    for (DSPanel.AttribRadioButton b : TimeSpaceDSPanel.this.defaultWeightingMap.values()) {
                        b.setSelected(true);
                    }
                    for (DSPanel.AttribRadioButton b : TimeSpaceDSPanel.this.defaultAggregationMap.values()) {
                        b.setSelected(true);
                    }
                }
            }
        });
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)this.attribCombo, (int)8, (int)1, (int)17, (int)1, (double)0.0, (double)0.0);
        DSPanel.GroupCheckBox allOnOffCheck = new DSPanel.GroupCheckBox(JAMS.i18n((String)"ALL_ON/OFF"), allChecks);
        allOnOffCheck.setSelected(false);
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)allOnOffCheck, (int)5, (int)5, (int)1, (int)1, (double)0.0, (double)0.0);
        space = new JPanel();
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)space, (int)6, (int)(i + 11), (int)1, (int)1, (double)1.0, (double)1.0);
        allOnOffCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DSPanel.GroupCheckBox thisCheck = (DSPanel.GroupCheckBox)e.getSource();
                boolean selected = thisCheck.isSelected();
                ArrayList<JCheckBox> allChecks = thisCheck.checkBoxList;
                for (JCheckBox checkBox : allChecks) {
                    checkBox.setSelected(selected);
                }
            }
        });
        this.aggregationPanel.updateUI();
        this.cacheReset.setEnabled(true);
        this.timeField.setEnabled(true);
        this.indexReset.setEnabled(true);
        tsproc.addProcessingProgressObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                TimeSpaceDSPanel.this.workerDlg.setProgress(Integer.parseInt(arg.toString()));
            }
        });
    }

    private boolean setCheckBox(String theLabel) {
        for (JCheckBox check : this.attribCombo.checkBoxList) {
            if (!theLabel.equals(check.getText())) continue;
            check.setSelected(true);
            return true;
        }
        return false;
    }

    private void clearPanel() {
        this.timeList.setEnabled(false);
        this.entityList.setEnabled(false);
        this.yearList.setEnabled(false);
        this.monthList.setEnabled(false);
        this.cacheReset.setEnabled(false);
        this.timeField.setEnabled(false);
        this.indexReset.setEnabled(false);
        this.toWW.setEnabled(false);
    }

    private void showInWorldWind() {
        this.workerDlg.setInderminate(false);
        this.workerDlg.setProgress(0);
        ArrayList<JCheckBox> attribs = this.attribCombo.checkBoxList;
        this.workerDlg.setTask(new CancelableSwingWorker(){
            int progress;
            DataTransfer3D transfer;
            DataMatrix[] m;
            ArrayList<String> attributeNames = new ArrayList();
            int weightAttribIndex = -1;

            public Void doInBackground() {
                this.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getPropertyName().equals("progress")) {
                            TimeSpaceDSPanel.this.workerDlg.setProgress((Integer)evt.getNewValue());
                        }
                    }
                });
                try {
                    String weightAttribName = TimeSpaceDSPanel.this.attribCombo.getSelectedItem().toString();
                    List entities = TimeSpaceDSPanel.this.entityList.getSelectedValuesList();
                    List times = TimeSpaceDSPanel.this.timeList.getSelectedValuesList();
                    String[] entitiesString = new String[entities.size()];
                    int numAttribs = 0;
                    for (AbstractDataStoreProcessor.AttributeData attribute : TimeSpaceDSPanel.this.proc.getDataStoreProcessor().getAttributes()) {
                        if (!attribute.isSelected()) continue;
                        this.attributeNames.add(attribute.getName());
                        ++numAttribs;
                    }
                    this.attributeNames.remove(weightAttribName);
                    if (this.attributeNames.isEmpty()) {
                        GUIHelper.showInfoDlg((Component)TimeSpaceDSPanel.this.parent, (String)"Please select one or more attributes!", (String)"Warning");
                        return null;
                    }
                    int k = 0;
                    long[] entityIds = new long[entities.size()];
                    for (Object id : entities) {
                        entityIds[k] = Long.parseLong(id.toString());
                        entitiesString[k] = id.toString();
                        ++k;
                    }
                    k = 0;
                    String[] dateIds = new String[times.size()];
                    for (Object date : times) {
                        dateIds[k++] = date.toString();
                    }
                    DataMatrix w = null;
                    int position = 0;
                    ArrayList<DataMatrix> matrixList = new ArrayList<DataMatrix>();
                    for (AbstractDataStoreProcessor.AttributeData attribute : TimeSpaceDSPanel.this.proc.getDataStoreProcessor().getAttributes()) {
                        if (!attribute.isSelected() || !attribute.getName().equals(weightAttribName)) continue;
                        w = TimeSpaceDSPanel.this.proc.getCrossProduct(entityIds, dateIds, position);
                        this.progress = Math.round(++position * 100 / numAttribs);
                        this.setProgress(this.progress);
                    }
                    for (AbstractDataStoreProcessor.AttributeData attribute : TimeSpaceDSPanel.this.proc.getDataStoreProcessor().getAttributes()) {
                        if (!attribute.isSelected() || attribute.getName().equals(weightAttribName)) continue;
                        DataMatrix m = TimeSpaceDSPanel.this.proc.getCrossProduct(entityIds, dateIds, position);
                        switch (attribute.getWeightingType()) {
                            case 3: {
                                m.elementDivide(w);
                                break;
                            }
                            case 2: {
                                m.elementMultiply(w);
                                break;
                            }
                        }
                        matrixList.add(m);
                        this.progress = Math.round(++position * 100 / numAttribs);
                        this.setProgress(this.progress);
                    }
                    this.setProgress(100);
                    this.m = matrixList.toArray(new DataMatrix[matrixList.size()]);
                    String[] attribs = this.attributeNames.toArray(new String[this.attributeNames.size()]);
                    this.transfer = new DataTransfer3D(this.m, entitiesString, dateIds, attribs);
                    String selectedShape = (String)TimeSpaceDSPanel.this.outputSpreadSheet.getShapeSelector().getSelectedItem();
                    if (StringTools.isEmptyString((String)selectedShape)) {
                        Logger.getLogger(JAMSSpreadSheet.class.getName()).log(Level.WARNING, "No shape selected.");
                        return null;
                    }
                    ShapeFileDataStore dataStore = (ShapeFileDataStore)TimeSpaceDSPanel.this.explorer.getWorkspace().getInputDataStore(selectedShape);
                    if (dataStore == null) {
                        Logger.getLogger(JAMSSpreadSheet.class.getName()).log(Level.WARNING, "No datastore found.");
                        return null;
                    }
                    URI uri = dataStore.getUri();
                    if (uri == null) {
                        Logger.getLogger(JAMSSpreadSheet.class.getName()).log(Level.WARNING, "error: can't access shapefile! path is: " + dataStore.getShapeFile().getAbsolutePath());
                        return null;
                    }
                    JAMSLogging.unregisterLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.Show, (Logger)Logger.getLogger(JAMSSpreadSheet.class.getName()));
                    Logger.getLogger(JAMSSpreadSheet.class.getName()).log(Level.INFO, "Using Shapefile " + selectedShape + " / KEY COLUMN: " + dataStore.getKeyColumn());
                    JAMSLogging.registerLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.Show, (Logger)Logger.getLogger(JAMSSpreadSheet.class.getName()));
                    this.transfer.setShapeFileDataStore(dataStore);
                    TimeSpaceDSPanel.this.workerDlg.setInderminate(true);
                    GlobeView view = GlobeView.getInstance();
                    boolean result = view.addJAMSExplorerData(this.transfer);
                    if (result) {
                        view.show();
                    }
                }
                catch (SQLException ex) {
                    TimeSpaceDSPanel.this.explorer.getRuntime().handle((Throwable)ex);
                }
                catch (IOException ex) {
                    TimeSpaceDSPanel.this.explorer.getRuntime().handle((Throwable)ex);
                }
                catch (Throwable t) {
                    TimeSpaceDSPanel.this.explorer.getRuntime().handle(t);
                }
                return null;
            }

            @Override
            public int cancel() {
                TimeSpaceDSPanel.this.proc.sendAbortOperation();
                return 0;
            }
        });
        this.workerDlg.execute();
    }

    private void showTimeStep() {
        if (this.timeList.getSelectedValues().length == 0 || this.timeList.getSelectedValues().length > 1) {
            return;
        }
        this.workerDlg.setInderminate(true);
        this.workerDlg.setTask(new SwingWorker<Object, Void>(){
            DataMatrix m = null;
            int weightAttribIndex = -1;

            @Override
            public Object doInBackground() {
                JAMSCalendar date = (JAMSCalendar)TimeSpaceDSPanel.this.timeList.getSelectedValue();
                JAMSCalendar[] dates = new JAMSCalendar[]{date};
                if (date == null) {
                    return this.m;
                }
                if (TimeSpaceDSPanel.this.attribCombo.getSelectedIndex() != 0) {
                    AbstractDataStoreProcessor.AttributeData attrib;
                    this.weightAttribIndex = 0;
                    String weightAttribName = TimeSpaceDSPanel.this.attribCombo.getSelectedItem().toString();
                    Iterator iterator = TimeSpaceDSPanel.this.dsdb.getAttributes().iterator();
                    while (iterator.hasNext() && !(attrib = (AbstractDataStoreProcessor.AttributeData)iterator.next()).getName().equals(weightAttribName)) {
                        if (!attrib.isSelected()) continue;
                        ++this.weightAttribIndex;
                    }
                }
                try {
                    this.m = TimeSpaceDSPanel.this.getProc().getTemporalAggregate((Attribute.Calendar[])dates, this.weightAttribIndex);
                }
                catch (SQLException ex) {
                    Logger.getLogger(TimeSpaceDSPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(TimeSpaceDSPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (Throwable ex) {
                    Logger.getLogger(TimeSpaceDSPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                return this.m;
            }

            @Override
            public void done() {
                TimeSpaceDSPanel.this.loadData(this.m, false);
            }
        });
        this.workerDlg.execute();
    }

    private void showTempMean() {
        if (this.timeList.getSelectedValues().length == 0) {
            return;
        }
        this.workerDlg.setInderminate(false);
        this.workerDlg.setProgress(0);
        this.workerDlg.setTask(new CancelableSwingWorker(){
            DataMatrix m = null;
            int weightAttribIndex = -1;

            public Object doInBackground() {
                try {
                    Object[] objects = TimeSpaceDSPanel.this.timeList.getSelectedValues();
                    ArrayList<JAMSCalendar> dateList = new ArrayList<JAMSCalendar>();
                    for (Object o : objects) {
                        dateList.add((JAMSCalendar)o);
                    }
                    JAMSCalendar[] dates = dateList.toArray(new JAMSCalendar[dateList.size()]);
                    if (TimeSpaceDSPanel.this.attribCombo.getSelectedIndex() != 0) {
                        AbstractDataStoreProcessor.AttributeData attrib;
                        this.weightAttribIndex = 0;
                        String weightAttribName = TimeSpaceDSPanel.this.attribCombo.getSelectedItem().toString();
                        Iterator iterator = TimeSpaceDSPanel.this.dsdb.getAttributes().iterator();
                        while (iterator.hasNext() && !(attrib = (AbstractDataStoreProcessor.AttributeData)iterator.next()).getName().equals(weightAttribName)) {
                            if (!attrib.isSelected()) continue;
                            ++this.weightAttribIndex;
                        }
                    }
                    TimeSpaceProcessor tsproc = TimeSpaceDSPanel.this.getProc();
                    this.m = tsproc.getTemporalAggregate((Attribute.Calendar[])dates, this.weightAttribIndex);
                }
                catch (SQLException ex) {
                    Logger.getLogger(TimeSpaceDSPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(TimeSpaceDSPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                return null;
            }

            @Override
            public void done() {
                TimeSpaceDSPanel.this.loadData(this.m, false);
            }

            @Override
            public int cancel() {
                TimeSpaceDSPanel.this.proc.sendAbortOperation();
                return 0;
            }
        });
        this.workerDlg.execute();
    }

    private void showMonthlyMean() {
        if (this.monthList.getSelectedValues().length == 0) {
            return;
        }
        this.workerDlg.setInderminate(false);
        this.workerDlg.setProgress(0);
        this.workerDlg.setTask(new CancelableSwingWorker(){
            DataMatrix m;

            public Object doInBackground() {
                try {
                    int month = (Integer)TimeSpaceDSPanel.this.monthList.getSelectedValue();
                    this.m = TimeSpaceDSPanel.this.getProc().getMonthlyMean(month);
                }
                catch (SQLException ex) {
                    Logger.getLogger(TimeSpaceDSPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(TimeSpaceDSPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                return null;
            }

            @Override
            public void done() {
                TimeSpaceDSPanel.this.loadData(this.m, false);
            }

            @Override
            public int cancel() {
                TimeSpaceDSPanel.this.proc.sendAbortOperation();
                return 0;
            }
        });
        this.workerDlg.execute();
    }

    private void showYearlyMean() {
        if (this.yearList.getSelectedValues().length == 0) {
            return;
        }
        this.workerDlg.setInderminate(false);
        this.workerDlg.setProgress(0);
        this.workerDlg.setTask(new CancelableSwingWorker(){
            DataMatrix m;

            public Object doInBackground() {
                try {
                    int year = (Integer)TimeSpaceDSPanel.this.yearList.getSelectedValue();
                    this.m = TimeSpaceDSPanel.this.proc.getYearlyMean(year);
                }
                catch (SQLException ex) {
                    Logger.getLogger(TimeSpaceDSPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(TimeSpaceDSPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                return null;
            }

            @Override
            public void done() {
                TimeSpaceDSPanel.this.loadData(this.m, false);
            }

            @Override
            public int cancel() {
                TimeSpaceDSPanel.this.proc.sendAbortOperation();
                return 0;
            }
        });
        this.workerDlg.execute();
    }

    private void showSpatEntity() {
        if (this.entityList.getSelectedValues().length == 0) {
            return;
        }
        this.workerDlg.setInderminate(false);
        this.workerDlg.setProgress(0);
        this.workerDlg.setTask(new CancelableSwingWorker(){
            DataMatrix m = null;
            int weightAttribIndex = -1;

            public Object doInBackground() {
                try {
                    TimeSpaceProcessor tsproc = TimeSpaceDSPanel.this.getProc();
                    Object[] objects = TimeSpaceDSPanel.this.entityList.getSelectedValues();
                    if (TimeSpaceDSPanel.this.attribCombo.getSelectedIndex() != 0) {
                        AbstractDataStoreProcessor.AttributeData attrib;
                        this.weightAttribIndex = 0;
                        String weightAttribName = TimeSpaceDSPanel.this.attribCombo.getSelectedItem().toString();
                        Iterator iterator = TimeSpaceDSPanel.this.dsdb.getAttributes().iterator();
                        while (iterator.hasNext() && !(attrib = (AbstractDataStoreProcessor.AttributeData)iterator.next()).getName().equals(weightAttribName)) {
                            if (!attrib.isSelected()) continue;
                            ++this.weightAttribIndex;
                        }
                    }
                    long[] ids = new long[objects.length];
                    int c = 0;
                    for (Object o : objects) {
                        ids[c++] = (Long)o;
                    }
                    this.m = tsproc.getSpatialSum(ids, this.weightAttribIndex);
                }
                catch (SQLException ex) {
                    Logger.getLogger(TimeSpaceDSPanel.class.getName()).log(Level.SEVERE, null, ex);
                    this.cancel();
                }
                catch (IOException ex) {
                    Logger.getLogger(TimeSpaceDSPanel.class.getName()).log(Level.SEVERE, null, ex);
                    this.cancel();
                }
                catch (Throwable t) {
                    Logger.getLogger(TimeSpaceDSPanel.class.getName()).log(Level.SEVERE, "An error occured during data extraction!", t);
                    this.cancel();
                }
                return null;
            }

            @Override
            public void done() {
                if (this.m != null) {
                    TimeSpaceDSPanel.this.loadData(this.m, true);
                }
            }

            @Override
            public int cancel() {
                TimeSpaceDSPanel.this.getProc().sendAbortOperation();
                return 0;
            }
        });
        this.workerDlg.execute();
    }

    public static void main(String[] args) {
        String s = "2020-08-20";
        String p = "*-(05|06|07)-*";
        p = p.replaceAll("\\*", ".*");
        boolean b = s.matches(p);
        System.out.println(b);
    }

    private void showFreeTempMean() {
        String filter = this.timeField.getText();
        if (filter.isEmpty()) {
            return;
        }
        filter = filter.replaceAll("\\*", ".*");
        ListModel model = this.timeList.getModel();
        ArrayList<Integer> a = new ArrayList<Integer>();
        for (int i = 0; i < model.getSize(); ++i) {
            String item = model.getElementAt(i).toString();
            if (!item.matches(filter)) continue;
            a.add(i);
        }
        int[] indices = new int[a.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = (Integer)a.get(i);
        }
        this.timeList.setSelectedIndices(indices);
    }

    private void showCrossProduct() {
        this.workerDlg.setInderminate(true);
        this.workerDlg.setProgress(0);
        this.workerDlg.setTask(new CancelableSwingWorker(){
            DataMatrix m;
            DataMatrix w;

            public Object doInBackground() {
                try {
                    List times = TimeSpaceDSPanel.this.timeList.getSelectedValuesList();
                    String[] dateIDs = new String[times.size()];
                    for (int c = 0; c < dateIDs.length; ++c) {
                        dateIDs[c] = times.get(c).toString();
                    }
                    List entities = TimeSpaceDSPanel.this.entityList.getSelectedValuesList();
                    long[] entityIDs = new long[entities.size()];
                    for (int c = 0; c < entityIDs.length; ++c) {
                        entityIDs[c] = Long.parseLong(entities.get(c).toString());
                    }
                    String weightAttribName = TimeSpaceDSPanel.this.attribCombo.getSelectedItem().toString();
                    int position = 0;
                    int weightingType = 0;
                    for (AbstractDataStoreProcessor.AttributeData attribute : TimeSpaceDSPanel.this.proc.getDataStoreProcessor().getAttributes()) {
                        if (!attribute.isSelected()) continue;
                        if (!attribute.getName().equals(weightAttribName)) {
                            this.m = TimeSpaceDSPanel.this.getProc().getCrossProduct(entityIDs, dateIDs, position);
                            weightingType = attribute.getWeightingType();
                            break;
                        }
                        ++position;
                    }
                    position = 0;
                    for (AbstractDataStoreProcessor.AttributeData attribute : TimeSpaceDSPanel.this.proc.getDataStoreProcessor().getAttributes()) {
                        if (!attribute.isSelected()) continue;
                        if (attribute.getName().equals(weightAttribName)) {
                            this.w = TimeSpaceDSPanel.this.getProc().getCrossProduct(entityIDs, dateIDs, position);
                            break;
                        }
                        ++position;
                    }
                    if (this.w != null && this.m != null) {
                        switch (weightingType) {
                            case 3: {
                                this.m.elementDivide(this.w);
                                break;
                            }
                            case 2: {
                                this.m.elementMultiply(this.w);
                                break;
                            }
                        }
                    } else if (this.w != null) {
                        this.m = this.w;
                    } else if (this.w == null && this.m == null) {
                        GUIHelper.showInfoDlg((Component)TimeSpaceDSPanel.this.parent, (String)"Please select one or more attributes!", (String)"Information");
                    }
                }
                catch (SQLException ex) {
                    Logger.getLogger(TimeSpaceDSPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(TimeSpaceDSPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (Throwable ex) {
                    Logger.getLogger(TimeSpaceDSPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                return null;
            }

            @Override
            public void done() {
                TimeSpaceDSPanel.this.loadData(this.m, true);
            }

            @Override
            public int cancel() {
                TimeSpaceDSPanel.this.getProc().sendAbortOperation();
                return 0;
            }
        });
        this.workerDlg.execute();
    }

    private void toggleFreeTempMeanButton() {
        String filter = this.timeField.getText();
        if (filter.isEmpty()) {
            this.freeTempMean.setEnabled(false);
        } else {
            this.freeTempMean.setEnabled(true);
        }
    }

    private void resetCaches() {
        try {
            this.getProc().deleteCache();
        }
        catch (SQLException ex) {
            Logger.getLogger(TimeSpaceDSPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void createProc(File file) {
        this.workerDlg.setTitle(this.workerDlg.getTitle() + " [" + file.getName() + "]");
        this.dsdb = new DataStoreProcessor(file);
        this.dsdb.addImportProgressObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                TimeSpaceDSPanel.this.workerDlg.setProgress(Integer.parseInt(arg.toString()));
            }
        });
        this.createDB();
        this.outputDSFile = file;
    }
}

