/*
 * Decompiled with CFR 0.152.
 */
package jams.explorer.ensembles.gui;

import jams.explorer.ensembles.api.Model;
import jams.explorer.ensembles.gui.EnsembleControlPanel;
import jams.explorer.ensembles.implementation.AbstractModel;
import jams.explorer.ensembles.implementation.ClimateEnsemble;
import jams.explorer.ensembles.implementation.ClimateEnsembleProcessor;
import jams.explorer.ensembles.implementation.ClimateModel;
import java.awt.Color;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class EnsembleTable
extends JTable {
    Logger logger = Logger.getLogger(EnsembleTable.class.getName());
    ClimateEnsemble ensemble;
    Object[][] tableData;

    public EnsembleTable(ClimateEnsemble ensemble) {
        EnsembleControlPanel.registerLogHandler(this.logger);
        this.tableData = null;
        this.setEnsemble(ensemble);
        this.setSelectionModel(new MyListSelectionModel());
        this.setSelectionBackground(new Color(128, 128, 255));
        this.setModel(this.getTableModel());
    }

    public void fireSelectionChangeNotification() {
        int index = this.getSelectedRow();
        ((MyListSelectionModel)this.getSelectionModel()).fireValueChanged(index, index);
    }

    public void setEnsemble(ClimateEnsemble ensemble) {
        this.logger.entering(this.getClass().getName(), "setEnsemble");
        this.ensemble = ensemble;
        this.setModel(this.getTableModel());
        this.logger.exiting(this.getClass().getName(), "setEnsemble");
    }

    public String getOutput(int row) {
        if (this.tableData == null) {
            return null;
        }
        return this.tableData[row][1].toString();
    }

    public Set<String> getSelectedOutputs() {
        TreeSet<String> selection = new TreeSet<String>();
        for (Object[] row : this.tableData) {
            if (!((Boolean)row[0]).booleanValue()) continue;
            selection.add(row[1].toString());
        }
        return selection;
    }

    @Override
    public void selectAll() {
        for (Object[] tableData1 : this.tableData) {
            tableData1[0] = true;
        }
        ((DefaultTableModel)this.getModel()).fireTableDataChanged();
    }

    public void deselectAll() {
        for (Object[] tableData1 : this.tableData) {
            tableData1[0] = false;
        }
        ((DefaultTableModel)this.getModel()).fireTableDataChanged();
    }

    public void invertSelection() {
        for (Object[] tableData1 : this.tableData) {
            tableData1[0] = (Boolean)tableData1[0] == false;
        }
        ((DefaultTableModel)this.getModel()).fireTableDataChanged();
    }

    private TableModel getTableModel() {
        Object model2;
        if (this.ensemble == null) {
            return new DefaultTableModel(new String[]{"", "", "", "", ""}, 1);
        }
        this.logger.entering(this.getClass().getName(), "getTableModel()");
        TreeMap<String, EnsembleOutputFile> outputs = new TreeMap<String, EnsembleOutputFile>();
        for (Object model2 : this.ensemble.getModelSet()) {
            for (String outputDir : ((ClimateModel)model2).getOutputs()) {
                for (File outputFile : ((ClimateModel)model2).getOutputFiles(outputDir)) {
                    EnsembleOutputFile output = (EnsembleOutputFile)outputs.get(outputFile.getName());
                    if (output == null) {
                        output = new EnsembleOutputFile(outputFile.getName());
                    }
                    output.register(outputDir);
                    outputs.put(output.toString(), output);
                }
            }
            ((AbstractModel)model2).addModelDataChangeListener(new Model.ModelDataChangeListener(){

                @Override
                public void changed(Model model, String key) {
                    if (key.compareTo("output") != 0) {
                        return;
                    }
                    EnsembleTable.this.logger.entering(this.getClass().getName(), "changed()");
                    int oldSelection = EnsembleTable.this.getSelectedRow();
                    TreeMap<String, EnsembleOutputFile> outputs = new TreeMap<String, EnsembleOutputFile>();
                    for (ClimateModel model2 : EnsembleTable.this.ensemble.getModelSet()) {
                        for (String outputDir : model2.getOutputs()) {
                            for (File outputFile : model2.getOutputFiles(outputDir)) {
                                EnsembleOutputFile output = (EnsembleOutputFile)outputs.get(outputFile.getName());
                                if (output == null) {
                                    output = new EnsembleOutputFile(outputFile.getName());
                                }
                                output.register(outputDir);
                                outputs.put(output.toString(), output);
                            }
                        }
                    }
                    int i = 0;
                    for (EnsembleOutputFile e : outputs.values()) {
                        EnsembleTable.this.tableData[i][0] = true;
                        EnsembleTable.this.tableData[i][1] = e;
                        try {
                            ClimateEnsembleProcessor proc = new ClimateEnsembleProcessor(EnsembleTable.this.ensemble, e.outputFileName);
                            EnsembleTable.this.tableData[i][2] = proc.getNettoModelCount(e.outputFileName);
                        }
                        catch (Throwable t) {
                            EnsembleTable.this.tableData[i][2] = 0;
                            EnsembleTable.this.logger.log(Level.WARNING, "Oh, while reading the ensemble output, an error occured", t);
                        }
                        ++i;
                    }
                    EnsembleTable.this.getSelectionModel().setSelectionInterval(oldSelection, oldSelection);
                    EnsembleTable.this.fireSelectionChangeNotification();
                    EnsembleTable.this.logger.exiting(this.getClass().getName(), "changed()");
                }
            });
        }
        this.tableData = new Object[outputs.size()][3];
        int i = 0;
        for (EnsembleOutputFile e : outputs.values()) {
            this.tableData[i][0] = true;
            this.tableData[i][1] = e;
            try {
                ClimateEnsembleProcessor proc = new ClimateEnsembleProcessor(this.ensemble, e.outputFileName);
                this.tableData[i][2] = proc.getNettoModelCount(e.outputFileName);
            }
            catch (Throwable t) {
                this.tableData[i][2] = 0;
                this.logger.log(Level.WARNING, "Oh, while reading the ensemble output, an error occured", t);
            }
            ++i;
        }
        model2 = new DefaultTableModel(this.tableData, new String[]{"Selected", "Time Periode", "Group", "Name", "Datasets"}){

            @Override
            public Class<?> getColumnClass(int col) {
                switch (col) {
                    case 0: {
                        return Boolean.class;
                    }
                    case 4: {
                        return Integer.class;
                    }
                }
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 0;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                if (col == 0) {
                    try {
                        EnsembleTable.this.tableData[row][0] = Boolean.parseBoolean(value.toString());
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (col == 0) {
                    return EnsembleTable.this.tableData[row][0];
                }
                String s = super.getValueAt(row, 1).toString();
                if (col == 1) {
                    if (s.contains("Jaehrlich")) {
                        return "j\u00e4hrlich";
                    }
                    if (s.contains("Halbjaehrliche")) {
                        return "halbj\u00e4hrlich";
                    }
                    if (s.contains("Jahreszeitlich")) {
                        return "jahreszeitliche";
                    }
                    if (s.contains("Taegliche")) {
                        return "t\u00e4gliche";
                    }
                    if (s.contains("Dekadisch-jahreszeitliche")) {
                        return "dekadisch-jahreszeitlich";
                    }
                    if (s.contains("Dekadische")) {
                        return "dekadisch";
                    }
                    if (s.contains("monatliche")) {
                        return "monatlich";
                    }
                    if (s.contains("Aggregationsintervalle")) {
                        return "benutzerdefiniert";
                    }
                    return "";
                }
                if (col == 2) {
                    if (s.contains("Klimaparameter")) {
                        return "Klimaparameter";
                    }
                    if (s.contains("Klimakennwerte")) {
                        return "Klimakennwert";
                    }
                    if (s.contains("Tau-Wert")) {
                        return "Tau-Wert";
                    }
                    if (s.contains("Gleitendes Mittel")) {
                        return "Gleitendes Mittel";
                    }
                    if (s.contains("P-Werte")) {
                        return "P-Wert";
                    }
                }
                if (col == 3) {
                    int index1 = s.lastIndexOf("_");
                    if (index1 == -1) {
                        return s;
                    }
                    int index2 = (s = s.substring(0, index1)).lastIndexOf("_");
                    if (index2 == -1) {
                        return s;
                    }
                    return s.substring(index2 + 1);
                }
                if (col == 4) {
                    return EnsembleTable.this.tableData[row][2].toString();
                }
                return "";
            }
        };
        this.logger.exiting(this.getClass().getName(), "getTableModel()");
        return model2;
    }

    private class MyListSelectionModel
    extends DefaultListSelectionModel {
        public MyListSelectionModel() {
            this.setSelectionMode(0);
        }

        @Override
        public void fireValueChanged(int firstIndex, int lastIndex) {
            super.fireValueChanged(firstIndex, lastIndex);
        }
    }

    class EnsembleOutputFile {
        String outputFileName;
        Set<String> outputDirectories = new TreeSet<String>();

        EnsembleOutputFile(String outputFileName) {
            this.outputFileName = outputFileName;
        }

        void register(String outputDirectory) {
            this.outputDirectories.add(outputDirectory);
        }

        void remove(String outputDirectory) {
            this.outputDirectories.remove(outputDirectory);
        }

        Set<String> getOutputDirectories() {
            return Collections.unmodifiableSet(this.outputDirectories);
        }

        public String toString() {
            return this.outputFileName;
        }
    }
}

