/*
 * Decompiled with CFR 0.152.
 */
package jams.explorer;

import jams.JAMS;
import jams.JAMSException;
import jams.JAMSLogging;
import jams.explorer.JAMSExplorer;
import jams.explorer.OutputPanelFactory;
import jams.explorer.gui.DataCollectionView;
import jams.explorer.gui.InputDSInfoPanel;
import jams.explorer.gui.TSPanel;
import jams.explorer.gui.TreePanel;
import jams.explorer.spreadsheet.JAMSSpreadSheet;
import jams.explorer.tree.DSTreeNode;
import jams.explorer.tree.FileObject;
import jams.gui.tools.GUIHelper;
import jams.tools.FileTools;
import jams.tools.StringTools;
import jams.workspace.stores.InputDataStore;
import jams.workspace.stores.StandardInputDataStore;
import jams.workspace.stores.TSDataStore;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import optas.data.DataCollection;

public class DisplayManager
implements Observer {
    private InputDSInfoPanel inputDSInfoPanel;
    private TSPanel tsPanel;
    private TreePanel treePanel;
    private HashMap<String, Component> dataPanels = new HashMap();
    private JAMSExplorer explorer;
    private JAMSSpreadSheet spreadSheet = null;

    public DisplayManager(JAMSExplorer explorer) {
        this.explorer = explorer;
        this.treePanel = new TreePanel(explorer);
        this.inputDSInfoPanel = new InputDSInfoPanel();
        this.treePanel.getTree().addObserver(this);
        JAMSLogging.registerLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.Show, (Logger)Logger.getLogger(DisplayManager.class.getName()));
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg == null) {
            this.inputDSInfoPanel.updateDS(null);
            return;
        }
        DSTreeNode node = (DSTreeNode)arg;
        if (node.getType() == 3) {
            try {
                StandardInputDataStore store = (StandardInputDataStore)this.explorer.getWorkspace().getInputDataStore(node.toString());
                this.inputDSInfoPanel.updateDS(store);
            }
            catch (Exception e) {
                Logger.getLogger(DisplayManager.class.getName()).log(Level.SEVERE, null, e);
            }
        } else if (node.getType() == 4) {
            // empty if block
        }
    }

    public synchronized void removeAllDisplays() {
        for (String name : this.dataPanels.keySet()) {
            this.removeDisplay(name);
        }
    }

    public void removeDisplay(String name) {
        Component panel = this.dataPanels.get(name);
        this.explorer.getExplorerFrame().getTPane().remove(panel);
        this.dataPanels.remove(name);
    }

    public void removeDisplay(Component panel) {
        for (Map.Entry<String, Component> e : this.dataPanels.entrySet()) {
            if (e.getValue() != panel) continue;
            this.removeDisplay(e.getKey());
        }
    }

    public void displayDS(DSTreeNode node) {
        if (node == null) {
            return;
        }
        switch (node.getType()) {
            case 3: {
                String dsID = node.toString();
                InputDataStore store = this.explorer.getWorkspace().getInputDataStore(dsID);
                if (this.dataPanels.containsKey(dsID)) {
                    Component panel = this.dataPanels.get(dsID);
                    this.explorer.getExplorerFrame().getTPane().setSelectedComponent(panel);
                    return;
                }
                if (!(store instanceof TSDataStore)) break;
                this.spreadSheet = new JAMSSpreadSheet(this.explorer);
                this.spreadSheet.init();
                this.spreadSheet.setID(dsID);
                this.dataPanels.put(dsID, this.spreadSheet);
                this.explorer.getExplorerFrame().getTPane().addTab(dsID, this.spreadSheet);
                this.explorer.getExplorerFrame().getTPane().setSelectedComponent(this.spreadSheet);
                try {
                    this.spreadSheet.loadTSDS((TSDataStore)store, this.explorer.getWorkspace().getInputDirectory());
                }
                catch (Throwable e) {
                    GUIHelper.showErrorDlg((Component)this.explorer.getExplorerFrame(), (String)(JAMS.i18n((String)"AN_ERROR_OCCURED_WHILE_TRYING_TO_READ_FROM_DATASTORE_") + store.getID() + "\"\n" + e.toString() + "\n" + StringTools.getStackTraceString((StackTraceElement[])e.getStackTrace())), (String)JAMS.i18n((String)"ERROR"));
                }
                break;
            }
            case 4: {
                FileObject fo = (FileObject)node.getUserObject();
                File datFile = fo.getFile();
                String dsID = this.getIdFromName(datFile);
                if (this.dataPanels.containsKey(dsID)) {
                    Component panel = this.dataPanels.get(dsID);
                    if (this.explorer.getExplorerFrame().getTPane().indexOfComponent(panel) != -1) {
                        this.explorer.getExplorerFrame().getTPane().setSelectedComponent(panel);
                    } else {
                        this.explorer.getExplorerFrame().getTPane().addTab(dsID, panel);
                    }
                    return;
                }
                try {
                    Component outputPanel = OutputPanelFactory.getOutputDSPanel(this.explorer, fo, dsID);
                    this.dataPanels.put(dsID, outputPanel);
                    this.explorer.getExplorerFrame().getTPane().addTab(dsID, outputPanel);
                    this.explorer.getExplorerFrame().getTPane().setSelectedComponent(outputPanel);
                    break;
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(DisplayManager.class.getName()).log(Level.SEVERE, null, ex);
                    break;
                }
                catch (IOException ex) {
                    Logger.getLogger(DisplayManager.class.getName()).log(Level.SEVERE, null, ex);
                    break;
                }
                catch (JAMSException jAMSException) {
                    // empty catch block
                }
            }
        }
    }

    public DataCollection getCurrentDataCollection() {
        JComponent panel = (JComponent)this.explorer.getExplorerFrame().getTPane().getSelectedComponent();
        if (panel == null) {
            return null;
        }
        if (panel instanceof DataCollectionView) {
            DataCollectionView dcView = (DataCollectionView)panel;
            return dcView.getDataCollection();
        }
        return null;
    }

    public void deleteDS(DSTreeNode node) {
        if (node == null) {
            return;
        }
        switch (node.getType()) {
            case 3: {
                break;
            }
            case 4: {
                FileObject fo = (FileObject)node.getUserObject();
                File datFile = fo.getFile();
                this.deleteOutputFile(datFile);
                this.explorer.getExplorerFrame().update();
                break;
            }
            case 5: {
                File[] outDirs;
                String delDirName = node.getUserObject().toString();
                File currentOutDir = this.explorer.getWorkspace().getOutputDataDirectory();
                if (currentOutDir != null && currentOutDir.getName().equals(delDirName)) break;
                for (File outDir : outDirs = this.explorer.getWorkspace().getOutputDataDirectories()) {
                    if (!outDir.getName().equals(delDirName)) continue;
                    for (File file : this.explorer.getWorkspace().getOutputDataFiles(outDir)) {
                        this.deleteOutputFile(file);
                    }
                    FileTools.deleteFiles((File[])outDir.listFiles());
                    outDir.delete();
                    this.explorer.getExplorerFrame().update();
                }
                break;
            }
        }
    }

    private String getIdFromName(File theFile) {
        String id = theFile.getName() + " " + theFile.getParentFile().getName();
        return id;
    }

    private void deleteOutputFile(File datFile) {
        String dsID = this.getIdFromName(datFile);
        if (this.dataPanels.containsKey(dsID)) {
            this.removeDisplay(dsID);
            this.dataPanels.remove(dsID);
        }
        String fileID = datFile.getName();
        StringTokenizer name_tokenizer = new StringTokenizer(fileID, ".");
        String filename = "";
        filename = name_tokenizer.hasMoreTokens() ? name_tokenizer.nextToken() + ".ttp" : fileID + ".ttp";
        File ttpFile = new File(datFile.getParent(), filename);
        if (ttpFile.exists()) {
            ttpFile.delete();
        }
        if (datFile.exists()) {
            datFile.delete();
        }
    }

    public InputDSInfoPanel getInputDSInfoPanel() {
        return this.inputDSInfoPanel;
    }

    public TreePanel getTreePanel() {
        return this.treePanel;
    }

    public TSPanel getTSPanel() {
        if (this.tsPanel == null) {
            this.tsPanel = new TSPanel(this.explorer);
        }
        return this.tsPanel;
    }

    public JAMSSpreadSheet getSpreadSheet() {
        return this.spreadSheet;
    }
}

