/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.metadata.FileMetadata;

public class ServiceLoader<S>
implements Iterable<Metadata<S>> {
    private static final String SERVICES = "META-INF/services";
    private static final Logger log = Logger.getLogger("ServiceLoader");
    private final String serviceFile;
    private Class<S> expectedType;
    private final ClassLoader loader;
    private Set<Metadata<S>> providers;

    public static <S> ServiceLoader<S> load(Class<S> service) {
        return ServiceLoader.load(service, Thread.currentThread().getContextClassLoader());
    }

    public static <S> ServiceLoader<S> load(Class<S> service, ClassLoader loader) {
        if (loader == null) {
            loader = service.getClassLoader();
        }
        return new ServiceLoader<S>(service, loader);
    }

    public static <S> ServiceLoader<S> loadInstalled(Class<S> service) {
        throw new UnsupportedOperationException("Not implemented");
    }

    private ServiceLoader(Class<S> service, ClassLoader loader) {
        this.loader = loader;
        this.serviceFile = "META-INF/services/" + service.getName();
        this.expectedType = service;
    }

    public void reload() {
        this.providers = new HashSet<Metadata<S>>();
        for (URL serviceFile : this.loadServiceFiles()) {
            this.loadServiceFile(serviceFile);
        }
    }

    private List<URL> loadServiceFiles() {
        ArrayList<URL> serviceFiles = new ArrayList<URL>();
        try {
            Enumeration<URL> serviceFileEnumerator = this.loader.getResources(this.serviceFile);
            while (serviceFileEnumerator.hasMoreElements()) {
                serviceFiles.add(serviceFileEnumerator.nextElement());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load resources from " + this.serviceFile, e);
        }
        return serviceFiles;
    }

    @SuppressWarnings(value={"OS_OPEN_STREAM"}, justification="False positive")
    private void loadServiceFile(URL serviceFile) {
        InputStream is = null;
        try {
            is = serviceFile.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String serviceClassName = null;
            int i = 0;
            while ((serviceClassName = reader.readLine()) != null) {
                ++i;
                if ((serviceClassName = this.trim(serviceClassName)).length() <= 0) continue;
                this.loadService(serviceClassName, serviceFile, i);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read services file " + serviceFile);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not close services file " + serviceFile, e);
                }
            }
        }
    }

    private String trim(String line) {
        int comment = line.indexOf(35);
        if (comment > -1) {
            line = line.substring(0, comment);
        }
        return line.trim();
    }

    private void loadService(String serviceClassName, URL file, int lineNumber) {
        Class<S> serviceClass = this.loadClass(serviceClassName);
        if (serviceClass == null) {
            return;
        }
        S serviceInstance = this.prepareInstance(serviceClass);
        if (serviceInstance == null) {
            return;
        }
        this.providers.add(new FileMetadata<S>(serviceInstance, file, lineNumber));
    }

    private Class<? extends S> loadClass(String serviceClassName) {
        Class<?> clazz = null;
        Class<S> serviceClass = null;
        try {
            clazz = this.loader.loadClass(serviceClassName);
            serviceClass = clazz.asSubclass(this.expectedType);
        }
        catch (ClassNotFoundException e) {
            log.warning("Could not load service class " + serviceClassName);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Service class " + serviceClassName + " didn't implement the Extension interface");
        }
        return serviceClass;
    }

    private S prepareInstance(Class<? extends S> serviceClass) {
        try {
            Constructor<S> constructor = serviceClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoClassDefFoundError e) {
            log.log(Level.WARNING, "Could not instantiate service class " + serviceClass.getName(), e);
            return null;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error instantiating " + serviceClass, e.getCause());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Error instantiating " + serviceClass, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error instantiating " + serviceClass, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error instantiating " + serviceClass, e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Error instantiating " + serviceClass, e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Error instantiating " + serviceClass, e);
        }
    }

    @Override
    public Iterator<Metadata<S>> iterator() {
        if (this.providers == null) {
            this.reload();
        }
        return this.providers.iterator();
    }

    public String toString() {
        return "Services for " + this.serviceFile;
    }
}

