/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.reader;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.interceptor.InvocationContext;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.interceptor.builder.MethodReference;
import org.jboss.weld.interceptor.reader.DefaultInterceptorMetadata;
import org.jboss.weld.interceptor.reader.TargetClassInterceptorMetadata;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorFactory;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.metadata.MethodMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.interceptor.util.InterceptionTypeRegistry;
import org.jboss.weld.interceptor.util.InterceptorMetadataException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ValidatorMessage;
import org.jboss.weld.security.SetAccessibleAction;
import org.jboss.weld.util.collections.WeldCollections;
import org.slf4j.cal10n.LocLogger;

public class InterceptorMetadataUtils {
    protected static final String OBJECT_CLASS_NAME = Object.class.getName();
    private static final LocLogger LOG = LoggerFactory.loggerFactory().getLogger(Category.REFLECTION);

    public static InterceptorMetadata readMetadataForInterceptorClass(InterceptorFactory<?> interceptorReference) {
        return new DefaultInterceptorMetadata(interceptorReference, InterceptorMetadataUtils.buildMethodMap(interceptorReference.getClassMetadata(), false));
    }

    public static <T> TargetClassInterceptorMetadata readMetadataForTargetClass(ClassMetadata<T> classMetadata) {
        return new TargetClassInterceptorMetadata(classMetadata, InterceptorMetadataUtils.buildMethodMap(classMetadata, true));
    }

    public static boolean isInterceptorMethod(InterceptionType interceptionType, MethodMetadata method, boolean forTargetClass) {
        if (!method.getSupportedInterceptionTypes().contains((Object)interceptionType)) {
            return false;
        }
        if (interceptionType.isLifecycleCallback()) {
            if (forTargetClass) {
                return InterceptorMetadataUtils.isValidTargetClassLifecycleInterceptorMethod(interceptionType, method);
            }
            return InterceptorMetadataUtils.isValidInterceptorClassLifecycleInterceptorMethod(interceptionType, method);
        }
        return InterceptorMetadataUtils.isValidBusinessMethodInterceptorMethod(interceptionType, method);
    }

    private static boolean isValidTargetClassLifecycleInterceptorMethod(InterceptionType interceptionType, MethodMetadata method) {
        Method javaMethod = method.getJavaMethod();
        if (!Void.TYPE.equals(method.getReturnType()) && !Object.class.equals(method.getReturnType())) {
            throw new DefinitionException(ValidatorMessage.INTERCEPTOR_METHOD_DOES_NOT_HAVE_VOID_RETURN_TYPE, javaMethod.getName(), javaMethod.getDeclaringClass().getName(), interceptionType.annotationClassName(), Void.TYPE.getName());
        }
        Class<?>[] parameterTypes = javaMethod.getParameterTypes();
        if (parameterTypes.length > 1) {
            throw new DefinitionException(ValidatorMessage.INTERCEPTOR_METHOD_DOES_NOT_HAVE_ZERO_PARAMETERS, javaMethod.getName(), javaMethod.getDeclaringClass().getName(), interceptionType.annotationClassName());
        }
        Class<?>[] exceptionTypes = javaMethod.getExceptionTypes();
        if (exceptionTypes.length != 0) {
            for (Class<?> exceptionType : exceptionTypes) {
                if (RuntimeException.class.isAssignableFrom(exceptionType)) continue;
                LOG.warn(ValidatorMessage.INTERCEPTOR_METHOD_SHOULD_NOT_THROW_CHECKED_EXCEPTIONS, javaMethod.getName(), javaMethod.getDeclaringClass().getName(), exceptionType.getName());
            }
        }
        return parameterTypes.length == 0;
    }

    private static boolean isValidInterceptorClassLifecycleInterceptorMethod(InterceptionType interceptionType, MethodMetadata method) {
        Method javaMethod = method.getJavaMethod();
        if (!Object.class.equals(method.getReturnType()) && !Void.TYPE.equals(method.getReturnType())) {
            throw new DefinitionException(ValidatorMessage.INTERCEPTOR_METHOD_DOES_NOT_RETURN_OBJECT_OR_VOID, javaMethod.getName(), javaMethod.getDeclaringClass().getName(), interceptionType.annotationClassName(), Void.TYPE.getName(), OBJECT_CLASS_NAME);
        }
        Class<?>[] parameterTypes = javaMethod.getParameterTypes();
        if (parameterTypes.length == 0) {
            return false;
        }
        if (parameterTypes.length == 1) {
            if (InvocationContext.class.isAssignableFrom(parameterTypes[0])) {
                return true;
            }
            throw new DefinitionException(ValidatorMessage.INTERCEPTOR_METHOD_DOES_NOT_HAVE_CORRECT_TYPE_OF_PARAMETER, javaMethod.getName(), javaMethod.getDeclaringClass().getName(), interceptionType.annotationClassName(), InvocationContext.class.getName());
        }
        throw new DefinitionException(ValidatorMessage.INTERCEPTOR_METHOD_DOES_NOT_HAVE_EXACTLY_ONE_PARAMETER, javaMethod.getName(), javaMethod.getDeclaringClass().getName(), interceptionType.annotationClassName());
    }

    private static boolean isValidBusinessMethodInterceptorMethod(InterceptionType interceptionType, MethodMetadata method) {
        Method javaMethod = method.getJavaMethod();
        if (!Object.class.equals(method.getReturnType())) {
            throw new DefinitionException(ValidatorMessage.INTERCEPTOR_METHOD_DOES_NOT_RETURN_OBJECT, javaMethod.getName(), javaMethod.getDeclaringClass().getName(), interceptionType.annotationClassName(), OBJECT_CLASS_NAME);
        }
        Class<?>[] parameterTypes = javaMethod.getParameterTypes();
        if (parameterTypes.length != 1) {
            throw new DefinitionException(ValidatorMessage.INTERCEPTOR_METHOD_DOES_NOT_HAVE_EXACTLY_ONE_PARAMETER, javaMethod.getName(), javaMethod.getDeclaringClass().getName(), interceptionType.annotationClassName());
        }
        if (!InvocationContext.class.isAssignableFrom(parameterTypes[0])) {
            throw new DefinitionException(ValidatorMessage.INTERCEPTOR_METHOD_DOES_NOT_HAVE_CORRECT_TYPE_OF_PARAMETER, javaMethod.getName(), javaMethod.getDeclaringClass().getName(), interceptionType.annotationClassName(), InvocationContext.class.getName());
        }
        return true;
    }

    static Map<InterceptionType, List<MethodMetadata>> buildMethodMap(ClassMetadata<?> interceptorClass, boolean forTargetClass) {
        HashMap methodMap = new HashMap();
        ClassMetadata<?> currentClass = interceptorClass;
        HashSet<MethodReference> foundMethods = new HashSet<MethodReference>();
        do {
            HashSet<InterceptionType> detectedInterceptorTypes = new HashSet<InterceptionType>();
            for (MethodMetadata method : currentClass.getDeclaredMethods()) {
                MethodReference methodReference = MethodReference.of(method, Modifier.isPrivate(method.getJavaMethod().getModifiers()));
                if (foundMethods.contains(methodReference)) continue;
                for (InterceptionType interceptionType : InterceptionTypeRegistry.getSupportedInterceptionTypes()) {
                    if (!InterceptorMetadataUtils.isInterceptorMethod(interceptionType, method, forTargetClass)) continue;
                    if (methodMap.get((Object)interceptionType) == null) {
                        methodMap.put(interceptionType, new LinkedList());
                    }
                    if (detectedInterceptorTypes.contains((Object)interceptionType)) {
                        throw new InterceptorMetadataException("Same interception type cannot be specified twice on the same class");
                    }
                    detectedInterceptorTypes.add(interceptionType);
                    AccessController.doPrivileged(SetAccessibleAction.of(method.getJavaMethod()));
                    if (foundMethods.contains(methodReference)) continue;
                    ((List)methodMap.get((Object)interceptionType)).add(0, method);
                }
                foundMethods.add(methodReference);
            }
        } while ((currentClass = currentClass.getSuperclass()) != null && !OBJECT_CLASS_NAME.equals(currentClass.getJavaClass().getName()));
        return WeldCollections.immutableMap(methodMap);
    }
}

