/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index.quadtree;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geotools.index.quadtree.StoreException;

public class Node {
    private Envelope bounds;
    protected int numShapesId;
    protected int[] shapesId;
    protected List subNodes;
    protected Node parent;
    private boolean visited = false;
    private boolean childrenVisited = false;
    protected int id;

    public Node(Envelope bounds, int id, Node parent) {
        this.parent = parent;
        this.id = id;
        this.bounds = new Envelope(bounds);
        this.subNodes = new ArrayList(4);
        this.shapesId = new int[4];
        Arrays.fill(this.shapesId, -1);
    }

    public Envelope getBounds() {
        return this.bounds;
    }

    public void setBounds(Envelope bounds) {
        this.bounds = bounds;
    }

    public int getNumSubNodes() {
        return this.subNodes.size();
    }

    public int getNumShapeIds() {
        return this.numShapesId;
    }

    public void addSubNode(Node node) {
        if (node == null) {
            throw new NullPointerException("Cannot add null to subnodes");
        }
        this.subNodes.add(node);
    }

    public boolean removeSubNode(Node node) {
        return this.subNodes.remove(node);
    }

    public void clearSubNodes() {
        this.subNodes.clear();
    }

    public Node getSubNode(int pos) throws StoreException {
        return (Node)this.subNodes.get(pos);
    }

    public void addShapeId(int id) {
        if (this.shapesId.length == this.numShapesId) {
            int[] newIds = new int[this.numShapesId * 2];
            Arrays.fill(newIds, -1);
            System.arraycopy(this.shapesId, 0, newIds, 0, this.numShapesId);
            this.shapesId = newIds;
        }
        this.shapesId[this.numShapesId] = id;
        ++this.numShapesId;
    }

    public int getShapeId(int pos) {
        if (pos >= this.numShapesId) {
            throw new ArrayIndexOutOfBoundsException("Requsted " + pos + " but size = " + this.numShapesId);
        }
        return this.shapesId[pos];
    }

    public void setShapesId(int[] ids) {
        if (ids == null) {
            this.numShapesId = 0;
        } else {
            this.shapesId = ids;
            this.numShapesId = 0;
            for (int i = 0; i < ids.length && ids[i] != -1; ++i) {
                ++this.numShapesId;
            }
        }
    }

    public int[] getShapesId() {
        return this.shapesId;
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public void setVisited(boolean visited) {
        this.visited = visited;
    }

    public Node getSibling() throws StoreException {
        if (this.parent == null || this.id == this.parent.getNumSubNodes() - 1) {
            return null;
        }
        return this.parent.getSubNode(this.id + 1);
    }

    public boolean isChildrenVisited() {
        return this.childrenVisited;
    }

    public void setChildrenVisited(boolean childrenVisited) {
        this.childrenVisited = childrenVisited;
    }

    public Node copy() throws IOException {
        return new Node(this.bounds, this.id, this.parent);
    }
}

