/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index.rtree.fs;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import org.geotools.index.DataDefinition;
import org.geotools.index.TreeException;
import org.geotools.index.rtree.Entry;
import org.geotools.index.rtree.Node;
import org.geotools.index.rtree.PageStore;
import org.geotools.index.rtree.fs.FileSystemNode;
import org.geotools.index.rtree.fs.Parameters;

public class FileSystemPageStore
extends PageStore {
    protected static final byte B_SHORT = 1;
    protected static final byte B_INTEGER = 2;
    protected static final byte B_LONG = 3;
    protected static final byte B_FLOAT = 4;
    protected static final byte B_DOUBLE = 5;
    protected static final byte B_STRING = 6;
    private static final int DEF_MAX = 50;
    private static final int DEF_MIN = 25;
    private static final short DEF_SPLIT = 1;
    private static final int FILE_VERSION = 19730103;
    private Parameters params = new Parameters();
    private RandomAccessFile raFile;
    private FileChannel channel;
    private ByteBuffer header;
    private FileSystemNode root;

    public FileSystemPageStore(File file) throws TreeException {
        if (file.isDirectory()) {
            throw new TreeException("Cannot use a directory as index!");
        }
        this.params.setMaxNodeEntries(50);
        this.params.setMinNodeEntries(25);
        this.params.setSplitAlg((short)1);
        try {
            this.init(file);
        }
        catch (IOException e) {
            throw new TreeException(e);
        }
    }

    public FileSystemPageStore(File file, DataDefinition def) throws TreeException {
        this(file, def, 50, 25, 1);
    }

    public FileSystemPageStore(File file, DataDefinition def, int maxNodeEntries, int minNodeEntries, short splitAlg) throws TreeException {
        super(def, maxNodeEntries, minNodeEntries, splitAlg);
        if (file.exists() && file.length() != 0L) {
            throw new TreeException("Cannot set dataDefinition, maxNodesEntries and minNodeEntries to the existing index " + file);
        }
        if (file.isDirectory()) {
            throw new TreeException("Cannot use a directory as index!");
        }
        this.params.setDataDef(def);
        this.params.setMaxNodeEntries(maxNodeEntries);
        this.params.setMinNodeEntries(minNodeEntries);
        this.params.setSplitAlg(splitAlg);
        try {
            this.init(file);
        }
        catch (IOException e) {
            throw new TreeException(e);
        }
    }

    private void init(File file) throws IOException, TreeException {
        this.raFile = new RandomAccessFile(file, "rw");
        this.channel = this.raFile.getChannel();
        this.params.setChannel(this.channel);
        try {
            if (file.length() > 0L) {
                this.loadIndex();
            } else {
                this.prepareIndex();
            }
        }
        catch (TreeException e) {
            this.channel.close();
            throw new TreeException(e);
        }
    }

    private void loadIndex() throws IOException, TreeException {
        Charset charset = Charset.forName("US-ASCII");
        ByteBuffer buf = ByteBuffer.allocate(8);
        this.channel.read(buf);
        buf.position(0);
        if (buf.getInt() != 19730103) {
            throw new TreeException("Wrong file version, shoud be 19730103");
        }
        int headerSize = buf.getInt();
        buf.position(0);
        this.header = ByteBuffer.allocate(headerSize);
        this.header.put(buf);
        this.header.mark();
        this.channel.read(this.header);
        this.header.reset();
        this.params.setMaxNodeEntries(this.header.getInt());
        this.params.setMinNodeEntries(this.header.getInt());
        this.params.setSplitAlg(this.header.getShort());
        int chLen = this.header.getInt();
        byte[] bytes = new byte[chLen];
        this.header.get(bytes);
        CharBuffer dummy = charset.decode(ByteBuffer.wrap(bytes));
        dummy.position(0);
        String defCharset = dummy.toString();
        DataDefinition def = new DataDefinition(defCharset);
        byte type = 0;
        int remaining = this.header.remaining();
        for (int i = 0; i < remaining - 8; i += 5) {
            type = this.header.get();
            if (type == 6) {
                def.addField(this.header.getInt());
                continue;
            }
            if (type == 1) {
                def.addField(Short.class);
            } else if (type == 2) {
                def.addField(Integer.class);
            } else if (type == 3) {
                def.addField(Long.class);
            } else if (type == 4) {
                def.addField(Float.class);
            } else if (type == 5) {
                def.addField(Double.class);
            }
            this.header.getInt();
        }
        this.params.setDataDef(def);
        long rootOffset = this.header.getLong();
        this.root = new FileSystemNode(this.params, rootOffset);
    }

    private void prepareIndex() throws IOException, TreeException {
        if (this.params.getDataDef() == null) {
            throw new TreeException("Data definition cannot be null when creating a new index.");
        }
        Charset charset = Charset.forName("US-ASCII");
        ByteBuffer chBuf = charset.encode(this.params.getDataDef().getCharset().name());
        chBuf.position(0);
        int headerSize = 22 + chBuf.capacity() + 5 * this.params.getDataDef().getFieldsCount() + 8;
        this.header = ByteBuffer.allocate(headerSize);
        this.header.putInt(19730103);
        this.header.putInt(headerSize);
        this.header.putInt(this.params.getMaxNodeEntries());
        this.header.putInt(this.params.getMinNodeEntries());
        this.header.putShort(this.params.getSplitAlg());
        this.header.putInt(chBuf.capacity());
        this.header.put(chBuf);
        DataDefinition.Field field = null;
        Class clazz = null;
        for (int i = 0; i < this.params.getDataDef().getFieldsCount(); ++i) {
            field = this.params.getDataDef().getField(i);
            clazz = field.getFieldClass();
            if (clazz.isAssignableFrom(Short.class)) {
                this.header.put((byte)1);
            } else if (clazz.isAssignableFrom(Integer.class)) {
                this.header.put((byte)2);
            } else if (clazz.isAssignableFrom(Long.class)) {
                this.header.put((byte)3);
            } else if (clazz.isAssignableFrom(Float.class)) {
                this.header.put((byte)4);
            } else if (clazz.isAssignableFrom(Double.class)) {
                this.header.put((byte)5);
            } else if (clazz.isAssignableFrom(String.class)) {
                this.header.put((byte)6);
            }
            this.header.putInt(field.getLen());
        }
        this.header.putLong(headerSize);
        this.header.position(0);
        this.channel.write(this.header);
        if (this.params.getForceChannel()) {
            this.channel.force(true);
        }
        this.root = new FileSystemNode(this.params);
        this.root.setLeaf(true);
        this.root.save();
    }

    public Node getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoot(Node node) throws TreeException {
        try {
            FileSystemNode n = (FileSystemNode)node;
            n.setParent(null);
            this.root = n;
            this.header.position(this.header.limit() - 8);
            this.header.putLong(n.getOffset());
            this.header.position(0);
            FileChannel fileChannel = this.channel;
            synchronized (fileChannel) {
                this.channel.position(0L);
                this.channel.write(this.header);
                if (this.params.getForceChannel()) {
                    this.channel.force(true);
                }
            }
        }
        catch (IOException e) {
            throw new TreeException(e);
        }
    }

    public Node getEmptyNode(boolean isLeaf) {
        FileSystemNode node = new FileSystemNode(this.params);
        node.setLeaf(isLeaf);
        return node;
    }

    public Node getNode(Entry parentEntry, Node parent) throws TreeException {
        FileSystemNode node = null;
        long offset = (Long)parentEntry.getData();
        try {
            node = new FileSystemNode(this.params, offset);
            ((Node)node).setParent(parent);
        }
        catch (IOException e) {
            throw new TreeException(e);
        }
        return node;
    }

    public Entry createEntryPointingNode(Node node) {
        FileSystemNode fn = (FileSystemNode)node;
        return new Entry<Long>(new Envelope(fn.getBounds()), new Long(fn.getOffset()));
    }

    public void free(Node node) {
        try {
            FileSystemNode fn = (FileSystemNode)node;
            fn.free();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws TreeException {
        try {
            this.header.position(0);
            FileChannel fileChannel = this.channel;
            synchronized (fileChannel) {
                this.channel.position(0L);
                this.channel.write(this.header);
                this.channel.force(true);
            }
            this.raFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new TreeException(e);
        }
    }

    public int getMaxNodeEntries() {
        return this.params.getMaxNodeEntries();
    }

    public int getMinNodeEntries() {
        return this.params.getMinNodeEntries();
    }

    public short getSplitAlgorithm() {
        return this.params.getSplitAlg();
    }

    public DataDefinition getDataDefinition() {
        return this.params.getDataDef();
    }

    public void setForceChannel(boolean b) {
        this.params.setForceChannel(b);
    }

    public boolean getForceChannel() {
        return this.params.getForceChannel();
    }
}

