/*
 * Decompiled with CFR 0.152.
 */
package jamsui.juice.gui.tree;

import jams.meta.ComponentDescriptor;
import jams.meta.ModelNode;
import jamsui.juice.gui.tree.JAMSTree;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class JAMSNode
extends ModelNode {
    public static final int LIBRARY_TYPE = 3;
    public static final int PACKAGE_TYPE = 4;
    public static final int ARCHIVE_TYPE = 5;
    static final int ICON_WIDTH = 16;
    static final int ICON_HEIGHT = 16;
    static Icon[] NODE_ICON = new Icon[]{new ImageIcon(new ImageIcon(ClassLoader.getSystemResource("resources/images/Component_s.png")).getImage().getScaledInstance(16, 16, 4)), new ImageIcon(new ImageIcon(ClassLoader.getSystemResource("resources/images/Context_s.png")).getImage().getScaledInstance(16, 16, 4)), new ImageIcon(new ImageIcon(ClassLoader.getSystemResource("resources/images/Context_s.png")).getImage().getScaledInstance(16, 16, 4)), new ImageIcon(new ImageIcon(ClassLoader.getSystemResource("resources/images/World_s.png")).getImage().getScaledInstance(16, 16, 4)), new ImageIcon(new ImageIcon(ClassLoader.getSystemResource("resources/images/Folder_s.png")).getImage().getScaledInstance(16, 16, 4)), new ImageIcon(new ImageIcon(ClassLoader.getSystemResource("resources/images/Package_s.png")).getImage().getScaledInstance(16, 16, 4))};
    private int type = 0;
    private JAMSTree tree;
    private Observer observer;

    public JAMSNode(Object o, int type, JAMSTree tree) {
        this(o, tree);
        this.setType(type);
    }

    public JAMSNode(Object o, JAMSTree tree) {
        super(o);
        this.tree = tree;
        if (o instanceof ComponentDescriptor) {
            ComponentDescriptor cd = (ComponentDescriptor)o;
            this.observer = new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    JAMSNode.this.tree.updateUI();
                }
            };
            cd.addObserver(this.observer);
        }
    }

    public void remove() {
        ArrayList<JAMSNode> children = new ArrayList<JAMSNode>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            children.add((JAMSNode)((Object)this.getChildAt(i)));
        }
        for (JAMSNode child : children) {
            child.remove();
        }
        Object o = this.getUserObject();
        if (o instanceof ComponentDescriptor) {
            ComponentDescriptor cd = (ComponentDescriptor)o;
            cd.unregister();
            this.removeObserver();
        }
        this.removeFromParent();
    }

    public void removeObserver() {
        if (this.observer == null) {
            return;
        }
        Object o = this.getUserObject();
        if (o instanceof ComponentDescriptor) {
            ComponentDescriptor cd = (ComponentDescriptor)o;
            cd.deleteObserver(this.observer);
            this.observer = null;
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public JAMSNode clone(JAMSTree target) {
        JAMSNode clone = null;
        ComponentDescriptor cd = ((ComponentDescriptor)this.getUserObject()).cloneNode();
        clone = new JAMSNode(cd, this.getType(), target);
        cd.register(target.getComponentCollection());
        return clone;
    }
}

