/*
 * Decompiled with CFR 0.152.
 */
package jamsui.juice.gui;

import jams.JAMS;
import jamsui.juice.gui.tree.JAMSTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TreePanel
extends JPanel {
    private static final Dimension BUTTON_DIMENSION = new Dimension(40, 20);
    private JScrollPane treeScrollPane = new JScrollPane();
    private JAMSTree tree;
    private JPanel lowerPanel = new JPanel();
    private JButton expandButton;
    private JButton collapseButton;

    public TreePanel() {
        this.setLayout(new BorderLayout());
        this.expandButton = new JButton(JAMS.i18n((String)"+"));
        this.expandButton.setMargin(new Insets(4, 4, 4, 4));
        this.expandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TreePanel.this.tree != null) {
                    TreePanel.this.tree.expandAll();
                }
            }
        });
        this.expandButton.setPreferredSize(BUTTON_DIMENSION);
        this.expandButton.setToolTipText(JAMS.i18n((String)"Expand_Tree"));
        this.collapseButton = new JButton(JAMS.i18n((String)"-"));
        this.collapseButton.setMargin(new Insets(4, 4, 4, 4));
        this.collapseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TreePanel.this.tree != null) {
                    TreePanel.this.tree.collapseAll();
                }
            }
        });
        this.collapseButton.setPreferredSize(BUTTON_DIMENSION);
        this.collapseButton.setToolTipText(JAMS.i18n((String)"Collapse_Tree"));
        this.lowerPanel.add(this.expandButton);
        this.lowerPanel.add(this.collapseButton);
        this.add((Component)this.treeScrollPane, "Center");
        this.add((Component)this.lowerPanel, "South");
    }

    public void addCustomButton(JButton button) {
        button.setPreferredSize(new Dimension(button.getPreferredSize().width, TreePanel.BUTTON_DIMENSION.height));
        this.lowerPanel.add(button);
        this.lowerPanel.updateUI();
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (Component c : this.lowerPanel.getComponents()) {
            c.setEnabled(enabled);
        }
    }

    public void setTree(JAMSTree tree) {
        this.tree = tree;
        this.tree.setExpandsSelectedPaths(true);
        this.treeScrollPane.setViewportView(tree);
    }
}

