/*
 * Decompiled with CFR 0.152.
 */
package jamsui.juice.documentation;

import jams.JAMS;
import jams.JAMSLogging;
import jams.SystemProperties;
import jams.gui.ObserverWorkerDlg;
import jams.gui.WorkerDlg;
import jams.gui.tools.GUIHelper;
import jams.tools.LogTools;
import jamsui.juice.JUICE;
import jamsui.juice.documentation.Bundle;
import jamsui.juice.documentation.DocumentationException;
import jamsui.juice.documentation.DocumentationGenerator;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.cli.CommandLineOptions;
import org.apache.fop.cli.Main;
import org.w3c.dom.Document;

public class DocumentationWizard {
    static final Logger log = Logger.getLogger(DocumentationWizard.class.getName());
    final String DOCUMENTATION_DIRECTORY = "/documentation/";
    DocumentationException innerException = null;
    private SystemProperties properties = null;
    private File workspace = null;
    private Document modelDocument = null;
    private final LogTools.ObservableLogHandler observable = new LogTools.ObservableLogHandler(new Logger[]{Logger.getLogger(DocumentationWizard.class.getName()), Logger.getLogger(DocumentationGenerator.class.getName())});

    private void runXSLTProcessor(String docBookHome, String documentationHome, String outputXML) throws DocumentationException {
        log.fine("running xsltproc");
        if (!new File(docBookHome + "/docbook/fo/docbook.xsl").exists()) {
            throw new DocumentationException(DocumentationException.DocumentationExceptionCause.docBookXSLNotExisting);
        }
        ProcessBuilder pb = new ProcessBuilder(docBookHome + "/xsltproc.exe", "--xinclude", "--output", documentationHome + "/tmp.fo", docBookHome + "/docbook/fo/docbook.xsl", outputXML);
        pb.redirectErrorStream(true);
        for (String s : pb.command()) {
            log.finest("argument of xsltproc:" + s + "\n");
        }
        Process process = null;
        try {
            process = pb.start();
            try {
                process.exitValue();
            }
            catch (Exception e) {
                log.fine("waiting on xsltproc");
                try {
                    Thread.sleep(300L);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    throw new DocumentationException(DocumentationException.DocumentationExceptionCause.unknownError, e2.toString());
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        InputStreamReader isr = new InputStreamReader(process.getInputStream());
        BufferedReader br = new BufferedReader(isr);
        log.fine("xslt-proc messages:");
        try {
            String line;
            while ((line = br.readLine()) != null) {
                log.fine(line);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void startFOP(String[] args) throws DocumentationException {
        MyCommandLineOptions options = null;
        FOUserAgent foUserAgent = null;
        BufferedOutputStream out = null;
        try {
            String outputFormat;
            block6: {
                options = new MyCommandLineOptions();
                options.parse(args);
                foUserAgent = options.getFOUserAgent();
                outputFormat = options.getOutputFormat();
                try {
                    if (options.getOutputFile() != null) {
                        out = new BufferedOutputStream(new FileOutputStream(options.getOutputFile()));
                        foUserAgent.setOutputFile(options.getOutputFile());
                    }
                    if (!"text/xsl".equals(outputFormat)) {
                        options.getInputHandler().renderTo(foUserAgent, outputFormat, (OutputStream)out);
                        break block6;
                    }
                    options.getInputHandler().transformTo(out);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)out);
            if ("application/X-fop-awt-preview".equals(outputFormat)) return;
        }
        catch (Exception e) {
            if (options == null) throw new DocumentationException(DocumentationException.DocumentationExceptionCause.ApacheFOPFailed, e.toString());
            System.out.println(e.toString());
            throw new DocumentationException(DocumentationException.DocumentationExceptionCause.ApacheFOPFailed, e.toString());
        }
    }

    public static void startFOPWithDynamicClasspath(String[] args) throws DocumentationException {
        try {
            URL[] urls = Main.getJARList();
            URLClassLoader loader = new URLClassLoader(urls, null);
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> clazz = Class.forName("org.apache.fop.cli.Main", true, loader);
            Method mainMethod = clazz.getMethod("startFOP", String[].class);
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            System.err.println("Unable to start FOP:");
            e.printStackTrace();
            throw new DocumentationException(DocumentationException.DocumentationExceptionCause.ApacheFOPFailed, e.toString());
        }
    }

    private String runApacheFOP(String inputFile, String outputFile, String optionalLibaries) throws DocumentationException {
        log.fine("running Apache FOP");
        System.setProperty("fop.optional.lib", optionalLibaries);
        log.finest(System.getProperty("java.class.path"));
        String[] args = new String[]{System.getProperty("java.class.path"), "-fo", inputFile, "-pdf", outputFile};
        String errorLog = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = System.err;
        if (!Main.checkDependencies()) {
            throw new DocumentationException(DocumentationException.DocumentationExceptionCause.FOPDependenciesIncomplete);
        }
        log.fine("startFOP");
        DocumentationWizard.startFOP(args);
        System.out.println(baos.toString());
        return errorLog;
    }

    private void openPDF(final File f) throws DocumentationException {
        log.fine("showing pdf");
        this.innerException = null;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + f.getAbsolutePath());
                }
                catch (IOException ex) {
                    DocumentationWizard.this.innerException = new DocumentationException(DocumentationException.DocumentationExceptionCause.ViewPDFError, ex.toString());
                    return;
                }
            }
        });
        thread.start();
        try {
            thread.isAlive();
        }
        catch (Exception e) {
            log.fine("opening pdf");
            if (this.innerException != null) {
                throw this.innerException;
            }
            try {
                Thread.sleep(300L);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new DocumentationException(DocumentationException.DocumentationExceptionCause.unknownError, e2.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDocumentationProcess(File workspace, Document modelDocument, String docBookHome) throws DocumentationException {
        log.entering(DocumentationWizard.class.toString(), "runDocumentationProcess");
        log.fine("initializing");
        if (workspace == null) {
            throw new DocumentationException(DocumentationException.DocumentationExceptionCause.workspaceNull);
        }
        File documentationHome = new File(workspace + "/documentation/");
        File documentationOutputDir = new File(documentationHome, "out/");
        String documentationOutputXML = documentationOutputDir + "/" + Bundle.resources.getString("Filename") + ".xml";
        documentationOutputDir.mkdirs();
        log.finest("docbook-home:" + docBookHome);
        if (docBookHome == null) {
            throw new DocumentationException(DocumentationException.DocumentationExceptionCause.docBookPathNull);
        }
        if (!new File(docBookHome + "/xsltproc.exe").exists() && !new File(docBookHome + "/xsltproc").exists()) {
            throw new DocumentationException(DocumentationException.DocumentationExceptionCause.xsltProcNotExisting);
        }
        if (documentationHome == null || !documentationHome.exists()) {
            throw new DocumentationException(DocumentationException.DocumentationExceptionCause.documentationPathNull);
        }
        if (modelDocument == null) {
            throw new DocumentationException(DocumentationException.DocumentationExceptionCause.docBookPathNull);
        }
        log.finest("working in workspace:" + workspace);
        log.fine("creating documentation");
        DocumentationGenerator generator = new DocumentationGenerator();
        generator.createDocumentation(documentationHome, documentationOutputDir, modelDocument);
        try {
            this.runXSLTProcessor(docBookHome, documentationOutputDir.getAbsolutePath(), documentationOutputXML);
            this.runApacheFOP(documentationOutputDir + "/tmp.fo", documentationHome + "/" + Bundle.resources.getString("Filename") + ".pdf", this.properties.getProperty("libs"));
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Error during XLST processing", t);
        }
        this.openPDF(new File(documentationHome, Bundle.resources.getString("Filename") + ".pdf"));
        log.fine("finished");
        log.exiting(DocumentationWizard.class.toString(), "runDocumentationProcess");
    }

    public void createDocumentation(Frame parent, Document doc, SystemProperties props, File savePath) {
        this.properties = props;
        this.workspace = savePath.getParentFile();
        this.modelDocument = doc;
        ObserverWorkerDlg progress = new ObserverWorkerDlg(new WorkerDlg((Window)parent, Bundle.resources.getString("Generating_Documentation")));
        progress.getWorkerDlg().setAlwaysOnTop(true);
        progress.getWorkerDlg().setModal(false);
        this.observable.deleteObservers();
        this.observable.addObserver((Observer)progress);
        this.observable.setLogLevel(Level.INFO);
        progress.getWorkerDlg().setInderminate(true);
        progress.getWorkerDlg().setTask(new Runnable(){

            @Override
            public void run() {
                try {
                    JAMSLogging.registerLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.CollectAndShow, (Logger)log);
                    JAMSLogging.registerLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.CollectAndShow, (Logger)DocumentationGenerator.log);
                    JAMSLogging.registerLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.CollectAndShow, (Logger)Logger.getLogger("org.apache.fop.fo.PropertyList"));
                    JAMSLogging.registerLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.CollectAndShow, (Logger)Logger.getLogger("org.apache.fop.fo.FONode"));
                    JAMSLogging.registerLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.CollectAndShow, (Logger)Logger.getLogger("org.apache.fop.fonts.FontInfo"));
                    JAMSLogging.registerLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.CollectAndShow, (Logger)Logger.getLogger("org.apache.fop.hyphenation.Hyphenator"));
                    JAMSLogging.registerLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.CollectAndShow, (Logger)Logger.getLogger("org.apache.fop.layoutmgr.BreakingAlgorithm"));
                    JAMSLogging.registerLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.CollectAndShow, (Logger)Logger.getLogger("org.apache.fop.render"));
                    DocumentationWizard.this.runDocumentationProcess(DocumentationWizard.this.workspace, DocumentationWizard.this.modelDocument, DocumentationWizard.this.properties.getProperty("docbook-home"));
                    JAMSLogging.unregisterLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.CollectAndShow, (Logger)log);
                    JAMSLogging.unregisterLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.CollectAndShow, (Logger)DocumentationGenerator.log);
                    JAMSLogging.unregisterLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.CollectAndShow, (Logger)Logger.getLogger("org.apache.fop.fo.PropertyList"));
                    JAMSLogging.unregisterLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.CollectAndShow, (Logger)Logger.getLogger("org.apache.fop.fo.FONode"));
                    JAMSLogging.unregisterLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.CollectAndShow, (Logger)Logger.getLogger("org.apache.fop.fonts.FontInfo"));
                    JAMSLogging.unregisterLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.CollectAndShow, (Logger)Logger.getLogger("org.apache.fop.hyphenation.Hyphenator"));
                    JAMSLogging.unregisterLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.CollectAndShow, (Logger)Logger.getLogger("org.apache.fop.layoutmgr.BreakingAlgorithm"));
                    JAMSLogging.unregisterLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.CollectAndShow, (Logger)Logger.getLogger("org.apache.fop.render"));
                }
                catch (DocumentationException e) {
                    GUIHelper.showErrorDlg((Component)JUICE.getJuiceFrame(), (String)e.toString(), (String)JAMS.i18n((String)"Error"));
                }
            }
        });
        progress.getWorkerDlg().execute();
    }

    static class MyCommandLineOptions
    extends CommandLineOptions {
        MyCommandLineOptions() {
        }

        public FOUserAgent getFOUserAgent() {
            return super.getFOUserAgent();
        }

        public String getOutputFormat() throws FOPException {
            return super.getOutputFormat();
        }
    }
}

