/*
 * Decompiled with CFR 0.152.
 */
package jamsui.cmdline;

import jams.JAMS;
import jams.io.CmdLineParser;
import jams.tools.StringTools;
import java.io.File;

public class JAMSCmdLine {
    private String configFileName;
    private String modelFileName = null;
    private String parameterValues = null;
    private String snapshotFileName = null;
    private String jmpFileName = null;
    private String[] otherArgs = null;
    private boolean nogui = false;
    private static final String USAGE_STRING = JAMS.i18n((String)"[Options]") + JAMS.i18n((String)"__-h,_--help_________________________________________Print_help") + JAMS.i18n((String)"__-c,_--config_<config_file_name>____________________Provide_config_file_name") + JAMS.i18n((String)"__-m,_--model_<model_definition_file_name>___________Provide_model_file_name") + JAMS.i18n((String)"__-s,_--snapshot_<save_snapshot_file>________________Provide_model_snapshot_name") + JAMS.i18n((String)"__-n,_--nogui________________________________________Suppress_all_GUI") + JAMS.i18n((String)"__-p,_--parametervalue_<list_of_parameter_values>____Provide_initial_parameter_values_divided_by_semicolons") + JAMS.i18n((String)"__-j,_--jams_parameterfile_<parameter_file_name>___Provide_initial_parameter_values_by_jmpfile");

    public JAMSCmdLine(String[] args, String appTitle) {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option configOption = parser.addStringOption('c', "config");
        CmdLineParser.Option modelOption = parser.addStringOption('m', "model");
        CmdLineParser.Option pValueOption = parser.addStringOption('p', "parametervalue");
        CmdLineParser.Option jmpValueOption = parser.addStringOption('j', "jmpfile");
        CmdLineParser.Option snapshotOption = parser.addStringOption('s', "snapshot");
        CmdLineParser.Option noguiOption = parser.addBooleanOption('n', "nogui");
        CmdLineParser.Option helpOption = parser.addBooleanOption('h', "help");
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            System.err.println(JAMS.i18n((String)"Usage:_") + appTitle + " " + USAGE_STRING);
            System.exit(2);
        }
        boolean usage = (Boolean)parser.getOptionValue(helpOption, (Object)Boolean.FALSE);
        if (usage) {
            System.out.println(JAMS.i18n((String)"Usage:_") + appTitle + " " + USAGE_STRING);
            System.exit(0);
        }
        this.nogui = (Boolean)parser.getOptionValue(noguiOption, (Object)Boolean.FALSE);
        this.configFileName = this.sanitizeFileName((String)parser.getOptionValue(configOption, null));
        this.modelFileName = this.sanitizeFileName((String)parser.getOptionValue(modelOption, null));
        this.snapshotFileName = this.sanitizeFileName((String)parser.getOptionValue(snapshotOption, null));
        this.parameterValues = (String)parser.getOptionValue(pValueOption, null);
        this.jmpFileName = this.sanitizeFileName((String)parser.getOptionValue(jmpValueOption, null));
        this.otherArgs = parser.getRemainingArgs();
        if (StringTools.isEmptyString((String)this.modelFileName) && this.otherArgs.length > 0 && !this.otherArgs[0].startsWith("-")) {
            this.modelFileName = this.otherArgs[0];
        }
    }

    private String sanitizeFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        File f = new File(fileName);
        return f.getAbsolutePath();
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public String getModelFileName() {
        return this.modelFileName;
    }

    public String getSnapshotFileName() {
        return this.snapshotFileName;
    }

    public String[] getOtherArgs() {
        return this.otherArgs;
    }

    public String getParameterValues() {
        return this.parameterValues;
    }

    public String getJmpFileName() {
        return this.jmpFileName;
    }

    public boolean isNogui() {
        return this.nogui;
    }
}

