/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.csv;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.EncogError;
import org.encog.util.csv.CSVError;
import org.encog.util.csv.CSVFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadCSV {
    private final DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private CSVFormat format;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BufferedReader reader;
    private final Map<String, Integer> columns = new HashMap<String, Integer>();
    private String[] data;

    public static String displayDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(date);
    }

    public static Date parseDate(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public ReadCSV(InputStream inputStream, boolean bl, char c) {
        CSVFormat cSVFormat = new CSVFormat(CSVFormat.getDecimalCharacter(), c);
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.begin(bl, cSVFormat);
    }

    public ReadCSV(InputStream inputStream, boolean bl, CSVFormat cSVFormat) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.begin(bl, cSVFormat);
    }

    public ReadCSV(String string, boolean bl, char c) {
        try {
            CSVFormat cSVFormat = new CSVFormat(CSVFormat.getDecimalCharacter(), c);
            this.reader = new BufferedReader(new FileReader(string));
            this.begin(bl, cSVFormat);
        }
        catch (IOException iOException) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Exception", (Throwable)iOException);
            }
            throw new EncogError(iOException);
        }
    }

    public ReadCSV(String string, boolean bl, CSVFormat cSVFormat) {
        try {
            this.reader = new BufferedReader(new FileReader(string));
            this.begin(bl, cSVFormat);
        }
        catch (IOException iOException) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Exception", (Throwable)iOException);
            }
            throw new EncogError(iOException);
        }
    }

    private void begin(boolean bl, CSVFormat cSVFormat) {
        try {
            this.format = cSVFormat;
            if (bl) {
                String string = this.reader.readLine();
                List<String> list = this.parse(string);
                int n = 0;
                for (String string2 : list) {
                    this.columns.put(string2.toLowerCase(), n++);
                }
            }
            this.data = null;
        }
        catch (IOException iOException) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Exception", (Throwable)iOException);
            }
            throw new EncogError(iOException);
        }
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Exception", (Throwable)iOException);
            }
            throw new EncogError(iOException);
        }
    }

    public String get(int n) {
        return this.data[n];
    }

    public String get(String string) {
        Integer n = this.columns.get(string.toLowerCase());
        if (n == null) {
            return null;
        }
        return this.data[n];
    }

    public int getColumnCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    public Date getDate(String string) {
        try {
            String string2 = this.get(string);
            return this.sdf.parse(string2);
        }
        catch (ParseException parseException) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Exception", (Throwable)parseException);
            }
            throw new EncogError(parseException);
        }
    }

    public double getDouble(int n) {
        String string = this.get(n);
        return this.format.parse(string);
    }

    public double getDouble(String string) {
        String string2 = this.get(string);
        return this.format.parse(string2);
    }

    public int getInt(String string) {
        String string2 = this.get(string);
        try {
            return this.format.getNumberFormatter().parse(string2).intValue();
        }
        catch (ParseException parseException) {
            throw new CSVError(parseException);
        }
    }

    private void initData(String string) {
        List<String> list = this.parse(string);
        this.data = new String[list.size()];
    }

    public boolean next() {
        try {
            String string = this.reader.readLine();
            if (string == null) {
                return false;
            }
            if (this.data == null) {
                this.initData(string);
            }
            List<String> list = this.parse(string);
            int n = 0;
            for (String string2 : list) {
                if (n >= this.data.length) continue;
                this.data[n++] = string2;
            }
            return true;
        }
        catch (IOException iOException) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Exception", (Throwable)iOException);
            }
            throw new EncogError(iOException);
        }
    }

    private List<String> parse(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == this.format.getSeparator() && !bl) {
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                bl = false;
                continue;
            }
            if (c == '\"' && bl) {
                bl = false;
                continue;
            }
            if (c == '\"' && stringBuilder.length() == 0) {
                bl = true;
                continue;
            }
            stringBuilder.append(c);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }
}

