/*
 * Decompiled with CFR 0.152.
 */
package org.encog.solve.genetic.species;

import java.util.ArrayList;
import java.util.List;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.persist.annotations.EGReference;
import org.encog.solve.genetic.genome.Genome;
import org.encog.solve.genetic.population.Population;
import org.encog.solve.genetic.species.Species;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicSpecies
implements Species {
    private int age;
    private double bestScore;
    private int gensNoImprovement;
    private Genome leader;
    private final List<Genome> members = new ArrayList<Genome>();
    private double spawnsRequired;
    private long speciesID;
    @EGReference
    private Population population;

    public BasicSpecies() {
    }

    public BasicSpecies(Population population, Genome genome, long l) {
        this.population = population;
        this.speciesID = l;
        this.bestScore = genome.getScore();
        this.gensNoImprovement = 0;
        this.age = 0;
        this.leader = genome;
        this.spawnsRequired = 0.0;
        this.members.add(genome);
    }

    @Override
    public void calculateSpawnAmount() {
        this.spawnsRequired = 0.0;
        for (Genome genome : this.members) {
            this.spawnsRequired += genome.getAmountToSpawn();
        }
    }

    @Override
    public Genome chooseParent() {
        Genome genome;
        if (this.members.size() == 1) {
            genome = this.members.get(0);
        } else {
            int n = (int)(this.population.getSurvivalRate() * (double)this.members.size()) + 1;
            int n2 = (int)RangeRandomizer.randomize(0.0, n);
            genome = this.members.get(n2);
        }
        return genome;
    }

    @Override
    public int getAge() {
        return this.age;
    }

    @Override
    public double getBestScore() {
        return this.bestScore;
    }

    @Override
    public int getGensNoImprovement() {
        return this.gensNoImprovement;
    }

    @Override
    public Genome getLeader() {
        return this.leader;
    }

    @Override
    public List<Genome> getMembers() {
        return this.members;
    }

    @Override
    public double getNumToSpawn() {
        return this.spawnsRequired;
    }

    public Population getPopulation() {
        return this.population;
    }

    @Override
    public double getSpawnsRequired() {
        return this.spawnsRequired;
    }

    @Override
    public long getSpeciesID() {
        return this.speciesID;
    }

    @Override
    public void purge() {
        this.members.clear();
        ++this.age;
        ++this.gensNoImprovement;
        this.spawnsRequired = 0.0;
    }

    @Override
    public void setAge(int n) {
        this.age = n;
    }

    @Override
    public void setBestScore(double d) {
        this.bestScore = d;
    }

    @Override
    public void setGensNoImprovement(int n) {
        this.gensNoImprovement = n;
    }

    @Override
    public void setLeader(Genome genome) {
        this.leader = genome;
    }

    @Override
    public void setSpawnsRequired(double d) {
        this.spawnsRequired = d;
    }
}

