/*
 * Decompiled with CFR 0.152.
 */
package org.encog.solve.anneal;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimulatedAnnealing<UNIT_TYPE> {
    private double startTemperature;
    private double stopTemperature;
    private int cycles;
    private double score;
    private double temperature;
    private boolean shouldMinimize = true;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public abstract double calculateScore();

    public abstract UNIT_TYPE[] getArray();

    public abstract UNIT_TYPE[] getArrayCopy();

    public int getCycles() {
        return this.cycles;
    }

    public double getScore() {
        return this.score;
    }

    public double getStartTemperature() {
        return this.startTemperature;
    }

    public double getStopTemperature() {
        return this.stopTemperature;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void iteration() {
        this.setScore(this.calculateScore());
        UNIT_TYPE[] UNIT_TYPEArray = this.getArrayCopy();
        this.temperature = this.getStartTemperature();
        for (int i = 0; i < this.cycles; ++i) {
            this.randomize();
            double d = this.calculateScore();
            if (this.shouldMinimize) {
                if (d < this.getScore()) {
                    UNIT_TYPEArray = this.getArrayCopy();
                    this.setScore(d);
                }
            } else if (d > this.getScore()) {
                UNIT_TYPEArray = this.getArrayCopy();
                this.setScore(d);
            }
            this.putArray(UNIT_TYPEArray);
            double d2 = Math.exp(Math.log(this.getStopTemperature() / this.getStartTemperature()) / (double)(this.getCycles() - 1));
            this.temperature *= d2;
        }
    }

    public abstract void putArray(UNIT_TYPE[] var1);

    public abstract void randomize();

    public void setCycles(int n) {
        this.cycles = n;
    }

    public void setScore(double d) {
        this.score = d;
    }

    public void setStartTemperature(double d) {
        this.startTemperature = d;
    }

    public void setStopTemperature(double d) {
        this.stopTemperature = d;
    }

    public void setTemperature(double d) {
        this.temperature = d;
    }

    public boolean isShouldMinimize() {
        return this.shouldMinimize;
    }

    public void setShouldMinimize(boolean bl) {
        this.shouldMinimize = bl;
    }
}

