/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors.generic;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Collection;
import org.encog.EncogError;
import org.encog.parse.tags.Tag;
import org.encog.parse.tags.read.ReadXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.PersistError;
import org.encog.persist.persistors.generic.ObjectMapper;
import org.encog.util.obj.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XML2Object {
    private final ObjectMapper mapper = new ObjectMapper();
    private ReadXML in;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void load(ReadXML readXML, EncogPersistedObject encogPersistedObject) {
        this.in = readXML;
        this.mapper.clear();
        encogPersistedObject.setName(readXML.getTag().getAttributeValue("name"));
        encogPersistedObject.setDescription(readXML.getTag().getAttributeValue("description"));
        this.loadActualObject(null, encogPersistedObject);
        this.mapper.resolve();
    }

    private void loadActualObject(Field field, Object object) {
        try {
            Object object2;
            for (String object3 : this.in.getTag().getAttributes().keySet()) {
                if (object3.equals("native")) continue;
                if (object3.equals("idx")) {
                    int object5 = Integer.parseInt(this.in.getTag().getAttributeValue("idx"));
                    this.mapper.addObjectMapping(object5, object);
                    continue;
                }
                Field field2 = ReflectionUtil.findField(object.getClass(), object3);
                if (field2 == null) continue;
                object2 = this.in.getTag().getAttributeValue(object3);
                this.setFieldValue(field2, object, (String)object2);
            }
            while (this.in.readToTag()) {
                if (this.in.getTag().getType() == Tag.Type.BEGIN) {
                    Object object3;
                    String string = this.in.getTag().getName();
                    Field field3 = ReflectionUtil.findField(object.getClass(), string);
                    if (field3 == null) continue;
                    field3.setAccessible(true);
                    Object object4 = field3.get(object);
                    object2 = field3.getType();
                    if (((Class)object2).isEnum()) {
                        object3 = this.in.readTextToTag();
                        this.setFieldValue(field3, object, (String)object3);
                        continue;
                    }
                    if (object2 == String.class || ((Class)object2).isPrimitive()) {
                        object3 = this.in.readTextToTag();
                        this.setFieldValue(field3, object, (String)object3);
                        continue;
                    }
                    if (object4 instanceof Collection) {
                        this.loadCollection((Collection)object4);
                        continue;
                    }
                    if (field3.getType() == File.class) {
                        object3 = this.in.readTextToTag();
                        File file = new File((String)object3);
                        field3.set(object, file);
                        continue;
                    }
                    this.in.readToTag();
                    if (this.in.getTag().getType() == Tag.Type.END) continue;
                    object3 = this.loadObject(field3, object);
                    field3.set(object, object3);
                    continue;
                }
                if (this.in.getTag().getType() != Tag.Type.END || !this.in.getTag().getName().equals(object.getClass().getSimpleName())) continue;
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new EncogError(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EncogError(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new EncogError(instantiationException);
        }
    }

    private void loadCollection(Collection<Object> collection) {
        try {
            while (this.in.readToTag()) {
                if (this.in.getTag().getType() == Tag.Type.BEGIN) {
                    String string = this.in.getTag().getName();
                    Class<?> clazz = ReflectionUtil.resolveEncogClass(string);
                    Object obj = clazz.newInstance();
                    this.loadActualObject(null, obj);
                    collection.add(obj);
                    continue;
                }
                if (this.in.getTag().getType() != Tag.Type.END) continue;
                return;
            }
        }
        catch (InstantiationException instantiationException) {
            throw new EncogError(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EncogError(illegalAccessException);
        }
    }

    private Object loadObject(Field field, Object object) throws InstantiationException, IllegalAccessException {
        String string = this.in.getTag().getAttributeValue("ref");
        if (string != null) {
            int n = Integer.parseInt(this.in.getTag().getAttributeValue("ref"));
            this.mapper.addFieldMapping(n, field, object);
            this.in.readToTag();
            return null;
        }
        Class<?> clazz = ReflectionUtil.resolveEncogClass(this.in.getTag().getName());
        if (clazz == null) {
            throw new PersistError("Can't create class: " + this.in.getTag().getName());
        }
        Object obj = clazz.newInstance();
        this.loadActualObject(field, obj);
        return obj;
    }

    private void setFieldValue(Field field, Object object, String string) {
        try {
            Class<?> clazz = field.getType();
            if (clazz.isEnum()) {
                field.set(object, ReflectionUtil.resolveEnum(field, string));
            } else if (clazz == Long.TYPE) {
                field.setLong(object, Long.parseLong(string));
            } else if (clazz == Integer.TYPE) {
                field.setInt(object, Integer.parseInt(string));
            } else if (clazz == Short.TYPE) {
                field.setShort(object, Short.parseShort(string));
            } else if (clazz == Double.TYPE) {
                field.setDouble(object, Double.parseDouble(string));
            } else if (clazz == Float.TYPE) {
                field.setDouble(object, Float.parseFloat(string));
            } else if (clazz == String.class) {
                field.set(object, string);
            } else if (clazz == Boolean.TYPE) {
                field.setBoolean(object, string.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PersistError("Error parsing field:" + field.getName(), illegalAccessException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PersistError("Error on field:" + field.getName(), numberFormatException);
        }
    }
}

