/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.location;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.encog.EncogError;
import org.encog.persist.EncogPersistedCollection;
import org.encog.persist.PersistError;
import org.encog.persist.location.PersistenceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePersistence
implements PersistenceLocation {
    private final String resource;
    private final Logger logger = LoggerFactory.getLogger(EncogPersistedCollection.class);

    public ResourcePersistence(String string) {
        this.resource = string;
    }

    public InputStream createInputStream() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(this.resource);
        if (inputStream == null) {
            String string = "Can't read resource: " + this.resource;
            if (this.logger.isErrorEnabled()) {
                this.logger.error(string);
            }
            throw new PersistError(string);
        }
        return inputStream;
    }

    public OutputStream createOutputStream() {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("The ResourcePersistence location does not support write operations.");
        }
        throw new PersistError("The ResourcePersistence location does not support write operations.");
    }

    public void delete() {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("The ResourcePersistence location does not support delete operations.");
        }
        throw new PersistError("The ResourcePersistence location does not support delete operations.");
    }

    public boolean exists() {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("The ResourcePersistence location does not support exists.");
        }
        throw new PersistError("The ResourcePersistence location does not support exists.");
    }

    public void renameTo(PersistenceLocation persistenceLocation) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("The ResourcePersistence location does not support rename operations.");
        }
        throw new PersistError("The ResourcePersistence location does not support rename operations.");
    }

    public String loadString() {
        InputStream inputStream = null;
        try {
            String string;
            inputStream = this.createInputStream();
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
                stringBuilder.append("\r\n");
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        catch (IOException iOException) {
            throw new PersistError(iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new EncogError(iOException);
            }
        }
    }
}

