/*
 * Decompiled with CFR 0.152.
 */
package org.encog.normalize;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.encog.NullStatusReportable;
import org.encog.engine.StatusReportable;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.normalize.NormalizationError;
import org.encog.normalize.input.HasFixedLength;
import org.encog.normalize.input.InputField;
import org.encog.normalize.input.InputFieldCSV;
import org.encog.normalize.input.InputFieldNeuralDataSet;
import org.encog.normalize.input.NeuralDataFieldHolder;
import org.encog.normalize.output.OutputField;
import org.encog.normalize.output.OutputFieldGroup;
import org.encog.normalize.output.OutputFieldGrouped;
import org.encog.normalize.output.RequireTwoPass;
import org.encog.normalize.segregate.Segregator;
import org.encog.normalize.target.NormalizationStorage;
import org.encog.persist.BasicPersistedObject;
import org.encog.persist.annotations.EGIgnore;
import org.encog.persist.annotations.EGReferenceable;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;
import org.encog.util.obj.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EGReferenceable
public class DataNormalization
extends BasicPersistedObject {
    private static final long serialVersionUID = 4387885013771660300L;
    private final Collection<InputField> inputFields = new ArrayList<InputField>();
    private final Collection<OutputField> outputFields = new ArrayList<OutputField>();
    @EGIgnore
    private final Collection<ReadCSV> readCSV = new ArrayList<ReadCSV>();
    @EGIgnore
    private final Map<InputField, ReadCSV> csvMap = new HashMap<InputField, ReadCSV>();
    @EGIgnore
    private final Collection<Iterator<NeuralDataPair>> readDataSet = new ArrayList<Iterator<NeuralDataPair>>();
    @EGIgnore
    private final Map<InputField, NeuralDataFieldHolder> dataSetFieldMap = new HashMap<InputField, NeuralDataFieldHolder>();
    @EGIgnore
    private final Map<Iterator<NeuralDataPair>, NeuralDataFieldHolder> dataSetIteratorMap = new HashMap<Iterator<NeuralDataPair>, NeuralDataFieldHolder>();
    private final Set<OutputFieldGroup> groups = new HashSet<OutputFieldGroup>();
    private final Collection<Segregator> segregators = new ArrayList<Segregator>();
    private NormalizationStorage storage;
    @EGIgnore
    private StatusReportable report = new NullStatusReportable();
    private int recordCount;
    private int currentIndex;
    private CSVFormat csvFormat = CSVFormat.ENGLISH;
    private int lastReport;

    public void addInputField(InputField inputField) {
        this.inputFields.add(inputField);
    }

    public void addOutputField(OutputField outputField) {
        this.addOutputField(outputField, false);
    }

    public void addOutputField(OutputField outputField, boolean bl) {
        this.outputFields.add(outputField);
        outputField.setIdeal(bl);
        if (outputField instanceof OutputFieldGrouped) {
            OutputFieldGrouped outputFieldGrouped = (OutputFieldGrouped)outputField;
            this.groups.add(outputFieldGrouped.getGroup());
        }
    }

    public void addSegregator(Segregator segregator) {
        this.segregators.add(segregator);
        segregator.init(this);
    }

    private void applyMinMax() {
        for (InputField inputField : this.inputFields) {
            double d = inputField.getCurrentValue();
            inputField.applyMinMax(d);
        }
    }

    public NeuralData buildForNetworkInput(double[] dArray) {
        int n = 0;
        for (InputField object2 : this.inputFields) {
            if (!object2.getUsedForNetworkInput()) continue;
            if (n >= dArray.length) {
                throw new NormalizationError("Can't build data, input fields used for neural input, must match provided data(" + dArray.length + ").");
            }
            object2.setCurrentValue(dArray[n++]);
        }
        int n2 = 0;
        for (OutputField outputField : this.outputFields) {
            if (outputField.isIdeal()) continue;
            for (int i = 0; i < outputField.getSubfieldCount(); ++i) {
                ++n2;
            }
        }
        this.initForOutput();
        BasicNeuralData basicNeuralData = new BasicNeuralData(n2);
        int n3 = 0;
        for (OutputField outputField : this.outputFields) {
            if (outputField.isIdeal()) continue;
            for (int i = 0; i < outputField.getSubfieldCount(); ++i) {
                basicNeuralData.setData(n3++, outputField.calculate(i));
            }
        }
        return basicNeuralData;
    }

    private double determineInputFieldValue(InputField inputField, int n) {
        double d = 0.0;
        if (inputField instanceof InputFieldCSV) {
            InputFieldCSV inputFieldCSV = (InputFieldCSV)inputField;
            ReadCSV readCSV = this.csvMap.get(inputField);
            d = readCSV.getDouble(inputFieldCSV.getOffset());
        } else if (inputField instanceof InputFieldNeuralDataSet) {
            InputFieldNeuralDataSet inputFieldNeuralDataSet = (InputFieldNeuralDataSet)inputField;
            NeuralDataFieldHolder neuralDataFieldHolder = this.dataSetFieldMap.get(inputField);
            NeuralDataPair neuralDataPair = neuralDataFieldHolder.getPair();
            int n2 = inputFieldNeuralDataSet.getOffset();
            d = n2 < neuralDataPair.getInput().size() ? neuralDataPair.getInput().getData(n2) : neuralDataPair.getIdeal().getData(n2 -= neuralDataPair.getInput().size());
        } else {
            d = inputField.getValue(n);
        }
        inputField.setCurrentValue(d);
        return d;
    }

    private void determineInputFieldValues(int n) {
        for (InputField inputField : this.inputFields) {
            this.determineInputFieldValue(inputField, n);
        }
    }

    public InputField findInputField(Class<?> clazz, int n) {
        int n2 = 0;
        for (InputField inputField : this.inputFields) {
            if (!ReflectionUtil.isInstanceOf(inputField.getClass(), clazz)) continue;
            if (n2 == n) {
                return inputField;
            }
            ++n2;
        }
        return null;
    }

    public OutputField findOutputField(Class<?> clazz, int n) {
        int n2 = 0;
        for (OutputField outputField : this.outputFields) {
            if (!ReflectionUtil.isInstanceOf(outputField.getClass(), clazz)) continue;
            if (n2 == n) {
                return outputField;
            }
            ++n2;
        }
        return null;
    }

    private void firstPass() {
        this.openCSV();
        this.openDataSet();
        this.currentIndex = -1;
        this.recordCount = 0;
        this.report.report(0, 0, "Analyzing file");
        this.lastReport = 0;
        int n = 0;
        this.initForPass();
        while (this.next()) {
            this.determineInputFieldValues(n);
            if (this.shouldInclude()) {
                this.applyMinMax();
                ++this.recordCount;
                this.reportResult("First pass, analyzing file", 0, this.recordCount);
            }
            ++n;
        }
    }

    public CSVFormat getCSVFormat() {
        return this.csvFormat;
    }

    public Set<OutputFieldGroup> getGroups() {
        return this.groups;
    }

    public Collection<InputField> getInputFields() {
        return this.inputFields;
    }

    public int getNetworkInputLayerSize() {
        int n = 0;
        for (OutputField outputField : this.outputFields) {
            if (outputField.isIdeal()) continue;
            n += outputField.getSubfieldCount();
        }
        return n;
    }

    public int getNetworkOutputLayerSize() {
        int n = 0;
        for (OutputField outputField : this.outputFields) {
            if (!outputField.isIdeal()) continue;
            n += outputField.getSubfieldCount();
        }
        return n;
    }

    public int getOutputFieldCount() {
        int n = 0;
        for (OutputField outputField : this.outputFields) {
            n += outputField.getSubfieldCount();
        }
        return n;
    }

    public Collection<OutputField> getOutputFields() {
        return this.outputFields;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public StatusReportable getReport() {
        return this.report;
    }

    public Collection<Segregator> getSegregators() {
        return this.segregators;
    }

    public NormalizationStorage getStorage() {
        return this.storage;
    }

    public void initForOutput() {
        for (OutputFieldGroup object : this.groups) {
            object.rowInit();
        }
        for (OutputField outputField : this.outputFields) {
            outputField.rowInit();
        }
    }

    public void initForPass() {
        for (Segregator segregator : this.segregators) {
            segregator.passInit();
        }
    }

    private boolean next() {
        Object object;
        for (ReadCSV object2 : this.readCSV) {
            if (object2.next()) continue;
            return false;
        }
        for (Iterator iterator : this.readDataSet) {
            if (!iterator.hasNext()) {
                return false;
            }
            object = this.dataSetIteratorMap.get(iterator);
            NeuralDataPair neuralDataPair = (NeuralDataPair)iterator.next();
            ((NeuralDataFieldHolder)object).setPair(neuralDataPair);
        }
        for (InputField inputField : this.inputFields) {
            if (!(inputField instanceof HasFixedLength) || this.currentIndex + 1 < (object = (HasFixedLength)((Object)inputField)).length()) continue;
            return false;
        }
        ++this.currentIndex;
        return true;
    }

    private void openCSV() {
        this.csvMap.clear();
        this.readCSV.clear();
        HashMap<File, ReadCSV> hashMap = new HashMap<File, ReadCSV>();
        for (InputField inputField : this.inputFields) {
            if (!(inputField instanceof InputFieldCSV)) continue;
            InputFieldCSV inputFieldCSV = (InputFieldCSV)inputField;
            File file = inputFieldCSV.getFile();
            if (!hashMap.containsKey(file)) {
                ReadCSV readCSV = new ReadCSV(file.toString(), false, this.csvFormat);
                hashMap.put(file, readCSV);
                this.readCSV.add(readCSV);
            }
            this.csvMap.put(inputFieldCSV, (ReadCSV)hashMap.get(file));
        }
    }

    private void openDataSet() {
        this.readDataSet.clear();
        this.dataSetFieldMap.clear();
        this.dataSetIteratorMap.clear();
        HashMap<NeuralDataSet, NeuralDataFieldHolder> hashMap = new HashMap<NeuralDataSet, NeuralDataFieldHolder>();
        for (InputField inputField : this.inputFields) {
            Object object;
            if (!(inputField instanceof InputFieldNeuralDataSet)) continue;
            InputFieldNeuralDataSet inputFieldNeuralDataSet = (InputFieldNeuralDataSet)inputField;
            NeuralDataSet neuralDataSet = inputFieldNeuralDataSet.getNeuralDataSet();
            if (!hashMap.containsKey(neuralDataSet)) {
                object = neuralDataSet.iterator();
                NeuralDataFieldHolder neuralDataFieldHolder = new NeuralDataFieldHolder((Iterator<NeuralDataPair>)object, inputFieldNeuralDataSet);
                hashMap.put(neuralDataSet, neuralDataFieldHolder);
                this.readDataSet.add((Iterator<NeuralDataPair>)object);
            }
            object = (NeuralDataFieldHolder)hashMap.get(neuralDataSet);
            this.dataSetFieldMap.put(inputFieldNeuralDataSet, (NeuralDataFieldHolder)object);
            this.dataSetIteratorMap.put(((NeuralDataFieldHolder)object).getIterator(), (NeuralDataFieldHolder)object);
        }
    }

    public void process() {
        if (this.twoPassesNeeded()) {
            this.firstPass();
        }
        this.secondPass();
    }

    private void reportResult(String string, int n, int n2) {
        ++this.lastReport;
        if (this.lastReport >= 10000) {
            this.report.report(n, n2, string);
            this.lastReport = 0;
        }
    }

    private void secondPass() {
        boolean bl = this.twoPassesNeeded();
        this.openCSV();
        this.openDataSet();
        this.initForPass();
        this.currentIndex = -1;
        int n = this.getOutputFieldCount();
        double[] dArray = new double[n];
        this.storage.open(this);
        this.lastReport = 0;
        int n2 = 0;
        int n3 = 0;
        while (this.next()) {
            for (InputField inputField : this.inputFields) {
                this.determineInputFieldValue(inputField, n2);
            }
            if (this.shouldInclude()) {
                this.initForOutput();
                int n4 = 0;
                for (OutputField outputField : this.outputFields) {
                    for (int i = 0; i < outputField.getSubfieldCount(); ++i) {
                        dArray[n4++] = outputField.calculate(i);
                    }
                }
                if (bl) {
                    this.reportResult("Second pass, normalizing data", this.recordCount, ++n3);
                } else {
                    this.reportResult("Processing data (single pass)", this.recordCount, ++n3);
                }
                this.storage.write(dArray, 0);
            }
            ++n2;
        }
        this.storage.close();
    }

    public void setCSVFormat(CSVFormat cSVFormat) {
        this.csvFormat = cSVFormat;
    }

    public void setReport(StatusReportable statusReportable) {
        this.report = statusReportable;
    }

    public void setTarget(NormalizationStorage normalizationStorage) {
        this.storage = normalizationStorage;
    }

    private boolean shouldInclude() {
        if (this.segregators.size() == 0) {
            return true;
        }
        boolean bl = false;
        for (Segregator segregator : this.segregators) {
            if (!segregator.shouldInclude()) continue;
            bl = true;
        }
        return bl;
    }

    public boolean twoPassesNeeded() {
        for (OutputField outputField : this.outputFields) {
            if (!(outputField instanceof RequireTwoPass)) continue;
            return true;
        }
        return false;
    }
}

