/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import java.util.ArrayList;
import java.util.List;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationLinear;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.networks.synapse.neat.NEATNeuron;
import org.encog.neural.networks.synapse.neat.NEATSynapse;
import org.encog.neural.pattern.NeuralNetworkPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NEATPattern
implements NeuralNetworkPattern {
    private int inputNeurons = -1;
    private int outputNeurons = -1;
    private ActivationFunction neatActivation;
    private ActivationFunction outputActivation;
    private boolean snapshot;
    private final List<NEATNeuron> neurons = new ArrayList<NEATNeuron>();

    @Override
    public void addHiddenLayer(int n) {
        throw new NeuralNetworkError("A NEAT network will evolve its hidden layers, do not specify any.");
    }

    @Override
    public void clear() {
    }

    @Override
    public BasicNetwork generate() {
        int n = 50;
        BasicLayer basicLayer = new BasicLayer(new ActivationLinear(), false, this.inputNeurons);
        basicLayer.setX(50);
        basicLayer.setY(n);
        BasicLayer basicLayer2 = new BasicLayer(this.outputActivation, false, this.outputNeurons);
        basicLayer2.setX(50);
        basicLayer2.setY(n += 150);
        NEATSynapse nEATSynapse = new NEATSynapse(basicLayer, basicLayer2, this.neurons, this.neatActivation, 0);
        nEATSynapse.setSnapshot(this.snapshot);
        basicLayer.addSynapse(nEATSynapse);
        BasicNetwork basicNetwork = new BasicNetwork();
        basicNetwork.tagLayer("INPUT", basicLayer);
        basicNetwork.tagLayer("OUTPUT", basicLayer2);
        basicNetwork.getStructure().finalizeStructure();
        return basicNetwork;
    }

    @Override
    public void setActivationFunction(ActivationFunction activationFunction) {
        this.outputActivation = activationFunction;
    }

    public void setNEATActivationFunction(ActivationFunction activationFunction) {
        this.neatActivation = activationFunction;
    }

    @Override
    public void setInputNeurons(int n) {
        this.inputNeurons = n;
    }

    @Override
    public void setOutputNeurons(int n) {
        this.outputNeurons = n;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(boolean bl) {
        this.snapshot = bl;
    }

    public List<NEATNeuron> getNeurons() {
        return this.neurons;
    }
}

