/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationBiPolar;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.networks.logic.BAMLogic;
import org.encog.neural.networks.synapse.WeightedSynapse;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BAMPattern
implements NeuralNetworkPattern {
    public static final String TAG_F1 = "F1";
    public static final String TAG_F2 = "F2";
    private int f1Neurons;
    private int f2Neurons;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void addHiddenLayer(int n) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A BAM network has no hidden layers.");
        }
        throw new PatternError("A BAM network has no hidden layers.");
    }

    public void clear() {
        this.f1Neurons = 0;
        this.f2Neurons = 0;
    }

    public BasicNetwork generate() {
        BasicNetwork basicNetwork = new BasicNetwork(new BAMLogic());
        BasicLayer basicLayer = new BasicLayer(new ActivationBiPolar(), false, this.f1Neurons);
        BasicLayer basicLayer2 = new BasicLayer(new ActivationBiPolar(), false, this.f2Neurons);
        WeightedSynapse weightedSynapse = new WeightedSynapse(basicLayer, basicLayer2);
        WeightedSynapse weightedSynapse2 = new WeightedSynapse(basicLayer2, basicLayer);
        basicLayer.addSynapse(weightedSynapse);
        basicLayer2.addSynapse(weightedSynapse2);
        basicNetwork.tagLayer(TAG_F1, basicLayer);
        basicNetwork.tagLayer(TAG_F2, basicLayer2);
        basicNetwork.getStructure().finalizeStructure();
        basicNetwork.getStructure().finalizeStructure();
        basicLayer.setY(50);
        basicLayer2.setY(50);
        basicLayer.setX(50);
        basicLayer2.setX(300);
        return basicNetwork;
    }

    public void setActivationFunction(ActivationFunction activationFunction) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A BAM network can't specify a custom activation function.");
        }
        throw new PatternError("A BAM network can't specify a custom activation function.");
    }

    public void setF1Neurons(int n) {
        this.f1Neurons = n;
    }

    public void setF2Neurons(int n) {
        this.f2Neurons = n;
    }

    public void setInputNeurons(int n) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A BAM network has no input layer, consider setting F1 layer.");
        }
        throw new PatternError("A BAM network has no input layer, consider setting F1 layer.");
    }

    public void setOutputNeurons(int n) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A BAM network has no output layer, consider setting F2 layer.");
        }
        throw new PatternError("A BAM network has no output layer, consider setting F2 layer.");
    }
}

