/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.simple;

import org.encog.engine.util.ErrorCalculation;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.structure.FlatUpdateNeeded;
import org.encog.neural.networks.synapse.Synapse;
import org.encog.neural.networks.training.BasicTraining;
import org.encog.neural.networks.training.LearningRate;

public class TrainAdaline
extends BasicTraining
implements LearningRate {
    private final BasicNetwork network;
    private final Synapse synapse;
    private final NeuralDataSet training;
    private double learningRate;

    public TrainAdaline(BasicNetwork basicNetwork, NeuralDataSet neuralDataSet, double d) {
        if (basicNetwork.getStructure().getLayers().size() > 2) {
            throw new NeuralNetworkError("An ADALINE network only has two layers.");
        }
        this.network = basicNetwork;
        Layer layer = basicNetwork.getLayer("INPUT");
        this.synapse = layer.getNext().get(0);
        this.training = neuralDataSet;
        this.learningRate = d;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public BasicNetwork getNetwork() {
        return this.network;
    }

    public void iteration() {
        ErrorCalculation errorCalculation = new ErrorCalculation();
        Layer layer = this.network.getLayer("INPUT");
        Layer layer2 = this.network.getLayer("OUTPUT");
        for (NeuralDataPair neuralDataPair : this.training) {
            NeuralData neuralData = this.network.compute(neuralDataPair.getInput());
            for (int i = 0; i < neuralData.size(); ++i) {
                double d = neuralDataPair.getIdeal().getData(i) - neuralData.getData(i);
                for (int j = 0; j < layer.getNeuronCount(); ++j) {
                    double d2 = neuralDataPair.getInput().getData(j);
                    this.synapse.getMatrix().add(j, i, this.learningRate * d * d2);
                }
                double d3 = layer2.getBiasWeight(i);
                layer2.setBiasWeight(i, d3 += this.learningRate * d);
            }
            this.network.getStructure().setFlatUpdate(FlatUpdateNeeded.Flatten);
            errorCalculation.updateError(neuralData.getData(), neuralDataPair.getIdeal().getData());
        }
        this.setError(errorCalculation.calculate());
    }

    public void setLearningRate(double d) {
        this.learningRate = d;
    }
}

