/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.logic;

import org.encog.neural.data.bipolar.BiPolarNeuralData;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.logic.SimpleRecurrentLogic;
import org.encog.neural.networks.synapse.Synapse;

public class ThermalLogic
extends SimpleRecurrentLogic {
    private static final long serialVersionUID = -8993932460566008196L;
    private Layer thermalLayer;
    private Synapse thermalSynapse;
    private BiPolarNeuralData currentState;

    public double calculateEnergy() {
        double d = 0.0;
        int n = this.getNeuronCount();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (i == j) continue;
                d += this.thermalSynapse.getMatrix().get(i, j) * this.currentState.getData(i) * this.currentState.getData(j);
            }
        }
        return -1.0 * d / 2.0;
    }

    public void clear() {
        this.thermalSynapse.getMatrix().clear();
    }

    public BiPolarNeuralData getCurrentState() {
        return this.currentState;
    }

    public int getNeuronCount() {
        return this.thermalLayer.getNeuronCount();
    }

    public Layer getThermalLayer() {
        return this.thermalLayer;
    }

    public Synapse getThermalSynapse() {
        return this.thermalSynapse;
    }

    public void init(BasicNetwork basicNetwork) {
        super.init(basicNetwork);
        this.thermalLayer = this.getNetwork().getLayer("INPUT");
        this.thermalSynapse = this.getNetwork().getStructure().findSynapse(this.thermalLayer, this.thermalLayer, true);
        this.currentState = new BiPolarNeuralData(this.thermalLayer.getNeuronCount());
    }

    public void setCurrentState(BiPolarNeuralData biPolarNeuralData) {
        for (int i = 0; i < biPolarNeuralData.size(); ++i) {
            this.currentState.setData(i, biPolarNeuralData.getData(i));
        }
    }
}

