/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.csv;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataError;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.data.basic.BasicNeuralDataPair;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVNeuralDataSet
implements NeuralDataSet {
    public static final String ADD_NOT_SUPPORTED = "Adds are not supported with this dataset, it is read only.";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String filename;
    private final int inputSize;
    private final int idealSize;
    private final CSVFormat format;
    private final boolean headers;
    private final List<CSVNeuralIterator> iterators = new ArrayList<CSVNeuralIterator>();

    public CSVNeuralDataSet(String string, int n, int n2, boolean bl) {
        this(string, n, n2, bl, CSVFormat.ENGLISH);
    }

    public CSVNeuralDataSet(String string, int n, int n2, boolean bl, CSVFormat cSVFormat) {
        this.filename = string;
        this.inputSize = n;
        this.idealSize = n2;
        this.format = cSVFormat;
        this.headers = bl;
    }

    @Override
    public void add(NeuralData neuralData) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(ADD_NOT_SUPPORTED);
        }
        throw new NeuralDataError(ADD_NOT_SUPPORTED);
    }

    @Override
    public void add(NeuralData neuralData, NeuralData neuralData2) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(ADD_NOT_SUPPORTED);
        }
        throw new NeuralDataError(ADD_NOT_SUPPORTED);
    }

    @Override
    public void add(NeuralDataPair neuralDataPair) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(ADD_NOT_SUPPORTED);
        }
        throw new NeuralDataError(ADD_NOT_SUPPORTED);
    }

    @Override
    public void close() {
        for (CSVNeuralIterator cSVNeuralIterator : this.iterators) {
            cSVNeuralIterator.close();
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public CSVFormat getFormat() {
        return this.format;
    }

    @Override
    public int getIdealSize() {
        return this.idealSize;
    }

    @Override
    public int getInputSize() {
        return this.inputSize;
    }

    @Override
    public Iterator<NeuralDataPair> iterator() {
        return new CSVNeuralIterator();
    }

    @Override
    public boolean isSupervised() {
        return this.idealSize > 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CSVNeuralIterator
    implements Iterator<NeuralDataPair> {
        private ReadCSV reader = null;
        private boolean dataReady;

        public CSVNeuralIterator() {
            this.reader = new ReadCSV(CSVNeuralDataSet.this.filename, CSVNeuralDataSet.this.headers, CSVNeuralDataSet.this.format);
            this.dataReady = false;
        }

        public void close() {
            this.reader.close();
        }

        @Override
        public boolean hasNext() {
            if (this.reader == null) {
                return false;
            }
            if (this.dataReady) {
                return true;
            }
            if (this.reader.next()) {
                this.dataReady = true;
                return true;
            }
            this.dataReady = false;
            return false;
        }

        @Override
        public NeuralDataPair next() {
            int n;
            BasicNeuralData basicNeuralData = new BasicNeuralData(CSVNeuralDataSet.this.inputSize);
            BasicNeuralData basicNeuralData2 = null;
            for (n = 0; n < CSVNeuralDataSet.this.inputSize; ++n) {
                basicNeuralData.setData(n, this.reader.getDouble(n));
            }
            if (CSVNeuralDataSet.this.idealSize > 0) {
                basicNeuralData2 = new BasicNeuralData(CSVNeuralDataSet.this.idealSize);
                for (n = 0; n < CSVNeuralDataSet.this.idealSize; ++n) {
                    basicNeuralData2.setData(n, this.reader.getDouble(n + CSVNeuralDataSet.this.inputSize));
                }
            }
            this.dataReady = false;
            return new BasicNeuralDataPair(basicNeuralData, basicNeuralData2);
        }

        @Override
        public void remove() {
            if (CSVNeuralDataSet.this.logger.isErrorEnabled()) {
                CSVNeuralDataSet.this.logger.error("Called remove, unsupported operation.");
            }
            throw new UnsupportedOperationException();
        }
    }
}

