/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.libsvm;

import org.encog.mathutil.libsvm.QMatrix;
import org.encog.mathutil.libsvm.Solver;

final class Solver_NU
extends Solver {
    private Solver.SolutionInfo si;

    Solver_NU() {
    }

    int Solve(int n, QMatrix qMatrix, double[] dArray, byte[] byArray, double[] dArray2, double d, double d2, double d3, Solver.SolutionInfo solutionInfo, int n2) {
        this.si = solutionInfo;
        return super.Solve(n, qMatrix, dArray, byArray, dArray2, d, d2, d3, solutionInfo, n2);
    }

    int select_working_set(int[] nArray) {
        int n;
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n2 = -1;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        int n3 = -1;
        int n4 = -1;
        double d5 = Double.POSITIVE_INFINITY;
        for (n = 0; n < this.active_size; ++n) {
            if (this.y[n] == 1) {
                if (this.is_upper_bound(n) || !(-this.G[n] >= d)) continue;
                d = -this.G[n];
                n2 = n;
                continue;
            }
            if (this.is_lower_bound(n) || !(this.G[n] >= d3)) continue;
            d3 = this.G[n];
            n3 = n;
        }
        n = n2;
        int n5 = n3;
        float[] fArray = null;
        float[] fArray2 = null;
        if (n != -1) {
            fArray = this.Q.get_Q(n, this.active_size);
        }
        if (n5 != -1) {
            fArray2 = this.Q.get_Q(n5, this.active_size);
        }
        for (int i = 0; i < this.active_size; ++i) {
            double d6;
            double d7;
            double d8;
            if (this.y[i] == 1) {
                if (this.is_lower_bound(i)) continue;
                d8 = d + this.G[i];
                if (this.G[i] >= d2) {
                    d2 = this.G[i];
                }
                if (!(d8 > 0.0) || !((d7 = (d6 = (double)(fArray[n] + this.QD[i] - 2.0f * fArray[i])) > 0.0 ? -(d8 * d8) / d6 : -(d8 * d8) / 1.0E-12) <= d5)) continue;
                n4 = i;
                d5 = d7;
                continue;
            }
            if (this.is_upper_bound(i)) continue;
            d8 = d3 - this.G[i];
            if (-this.G[i] >= d4) {
                d4 = -this.G[i];
            }
            if (!(d8 > 0.0) || !((d7 = (d6 = (double)(fArray2[n5] + this.QD[i] - 2.0f * fArray2[i])) > 0.0 ? -(d8 * d8) / d6 : -(d8 * d8) / 1.0E-12) <= d5)) continue;
            n4 = i;
            d5 = d7;
        }
        if (Math.max(d + d2, d3 + d4) < this.eps) {
            return 1;
        }
        nArray[0] = this.y[n4] == 1 ? n2 : n3;
        nArray[1] = n4;
        return 0;
    }

    private boolean be_shrunk(int n, double d, double d2, double d3, double d4) {
        if (this.is_upper_bound(n)) {
            if (this.y[n] == 1) {
                return -this.G[n] > d;
            }
            return -this.G[n] > d4;
        }
        if (this.is_lower_bound(n)) {
            if (this.y[n] == 1) {
                return this.G[n] > d2;
            }
            return this.G[n] > d3;
        }
        return false;
    }

    void do_shrinking() {
        int n;
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        for (n = 0; n < this.active_size; ++n) {
            if (!this.is_upper_bound(n)) {
                if (this.y[n] == 1) {
                    if (-this.G[n] > d) {
                        d = -this.G[n];
                    }
                } else if (-this.G[n] > d4) {
                    d4 = -this.G[n];
                }
            }
            if (this.is_lower_bound(n)) continue;
            if (this.y[n] == 1) {
                if (!(this.G[n] > d2)) continue;
                d2 = this.G[n];
                continue;
            }
            if (!(this.G[n] > d3)) continue;
            d3 = this.G[n];
        }
        if (!this.unshrink && Math.max(d + d2, d3 + d4) <= this.eps * 10.0) {
            this.unshrink = true;
            this.reconstruct_gradient();
            this.active_size = this.l;
        }
        block1: for (n = 0; n < this.active_size; ++n) {
            if (!this.be_shrunk(n, d, d2, d3, d4)) continue;
            --this.active_size;
            while (this.active_size > n) {
                if (!this.be_shrunk(this.active_size, d, d2, d3, d4)) {
                    this.swap_index(n, this.active_size);
                    continue block1;
                }
                --this.active_size;
            }
        }
    }

    double calculate_rho() {
        int n = 0;
        int n2 = 0;
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < this.active_size; ++i) {
            if (this.y[i] == 1) {
                if (this.is_lower_bound(i)) {
                    d = Math.min(d, this.G[i]);
                    continue;
                }
                if (this.is_upper_bound(i)) {
                    d3 = Math.max(d3, this.G[i]);
                    continue;
                }
                ++n;
                d5 += this.G[i];
                continue;
            }
            if (this.is_lower_bound(i)) {
                d2 = Math.min(d2, this.G[i]);
                continue;
            }
            if (this.is_upper_bound(i)) {
                d4 = Math.max(d4, this.G[i]);
                continue;
            }
            ++n2;
            d6 += this.G[i];
        }
        double d7 = n > 0 ? d5 / (double)n : (d + d3) / 2.0;
        double d8 = n2 > 0 ? d6 / (double)n2 : (d2 + d4) / 2.0;
        this.si.r = (d7 + d8) / 2.0;
        return (d7 - d8) / 2.0;
    }
}

