/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.routing;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Title", author="Author", description="Description")
public class GeoFemFlowAggregator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="catchment area")
    public Attribute.Double cArea;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="direct runoff")
    public Attribute.Double dirQ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="base flow")
    public Attribute.Double basQ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="total outflow cbm")
    public Attribute.Double totQcbm;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="total outflow mm")
    public Attribute.Double totQmm;

    public void init() {
    }

    public void run() {
        double totOut = this.dirQ.getValue() + this.basQ.getValue();
        this.totQmm.setValue(totOut);
        totOut = totOut * this.cArea.getValue() / 8.64E7;
        this.totQcbm.setValue(totOut);
    }

    public void cleanup() {
    }
}

