/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.regionalisation;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Regionalisation_old
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Workspace directory name")
    public Attribute.String dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of data values for current time step")
    public Attribute.DoubleArray dataArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Regression coefficients")
    public Attribute.DoubleArray regCoeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of station elevations")
    public Attribute.DoubleArray statElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="data set descriptor")
    public Attribute.String dataSetName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of station's x coordinates")
    public Attribute.DoubleArray statX;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of station's y coordinates")
    public Attribute.DoubleArray statY;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of station's weights")
    public Attribute.DoubleArray statWeights;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array position of weights")
    public Attribute.IntegerArray wArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Attribute name x coordinate (hru)")
    public Attribute.Double unitX;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Attribute name y coordinate (hru)")
    public Attribute.Double unitY;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="regionalised data value")
    public Attribute.Double dataValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Attribute name elevation")
    public Attribute.Double entityElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Number of IDW stations")
    public Attribute.Integer nidw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Apply elevation correction to measured data")
    public Attribute.Boolean elevationCorrection;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Minimum r\u00b2 value for elevation correction application")
    public Attribute.Double rsqThreshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Absolute possible minimum value for data set")
    public Attribute.Double fixedMinimum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Caching configuration: 0 - write cache, 1 - use cache, 2 - caching off", defaultValue="0")
    public Attribute.Integer dataCaching;
    private File cacheFile;
    private boolean useCache = false;
    private boolean writeCache = false;
    private transient ObjectOutputStream writer;
    private transient ObjectInputStream reader;

    public void init() throws Attribute.Entity.NoSuchAttributeException, IOException {
        this.cacheFile = new File(this.getModel().getWorkspace().getTempDirectory(), this.getInstanceName() + ".cache");
        if (!this.cacheFile.exists() && this.dataCaching.getValue() == 1) {
            this.getModel().getRuntime().sendHalt(this.getInstanceName() + ": data caching is switched on but no cache file available!");
        }
        if (this.dataCaching.getValue() == 1) {
            this.reader = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.cacheFile)));
        } else if (this.dataCaching.getValue() == 0) {
            this.writer = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.cacheFile)));
        }
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException, IOException {
        if (this.dataCaching.getValue() == 1) {
            this.dataValue.setValue(this.reader.readDouble());
        } else {
            int i;
            int counter;
            double[] regCoeff = this.regCoeff.getValue();
            double gradient = regCoeff[1];
            double rsq = regCoeff[2];
            double[] sourceElevations = this.statElevation.getValue();
            double[] sourceData = this.dataArray.getValue();
            double[] sourceWeights = this.statWeights.getValue();
            double targetElevation = this.entityElevation.getValue();
            double value = 0.0;
            double deltaElev = 0.0;
            int nIDW = this.nidw.getValue();
            double[] data = new double[nIDW];
            double[] weights = new double[nIDW];
            double[] elev = new double[nIDW];
            for (int i2 = 0; i2 < nIDW; ++i2) {
                data[i2] = 0.0;
                weights[i2] = 0.0;
                elev[i2] = 0.0;
            }
            int[] wA = this.wArray.getValue();
            int element = counter = 0;
            boolean cont = true;
            boolean valid = false;
            while (counter < nIDW && cont) {
                int t = wA[element];
                if (sourceData[t] == JAMS.getMissingDataValue()) {
                    if (++element >= wA.length) {
                        System.out.println("BREAK1: too less data NIDW had been reduced!");
                        cont = false;
                        continue;
                    }
                    t = wA[element];
                    continue;
                }
                valid = true;
                data[counter] = sourceData[t];
                weights[counter] = sourceWeights[t];
                elev[counter] = sourceElevations[t];
                ++counter;
                ++element;
            }
            double weightsum = 0.0;
            for (i = 0; i < counter; ++i) {
                weightsum += weights[i];
            }
            for (i = 0; i < counter; ++i) {
                weights[i] = weights[i] / weightsum;
            }
            if (valid) {
                for (i = 0; i < counter; ++i) {
                    if (rsq >= this.rsqThreshold.getValue() && this.elevationCorrection.getValue()) {
                        deltaElev = targetElevation - elev[i];
                        double tVal = (deltaElev * gradient + data[i]) * weights[i];
                        if (tVal < this.fixedMinimum.getValue()) {
                            tVal = this.fixedMinimum.getValue();
                        }
                        value += tVal;
                        continue;
                    }
                    value += data[i] * weights[i];
                }
            } else {
                value = JAMS.getMissingDataValue();
            }
            this.dataValue.setValue(value);
            if (this.dataCaching.getValue() == 0) {
                this.writer.writeDouble(value);
            }
        }
    }

    public void cleanup() throws IOException {
        if (!this.useCache && this.writeCache) {
            this.writer.flush();
            this.writer.close();
        } else if (this.useCache && !this.writeCache) {
            this.reader.close();
        }
    }
}

