/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.potET;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.io.IOException;
import org.unijena.j2k.physicalCalculations.ClimatologicalVariables;

@JAMSComponentDescription(title="CalcDailyETP_PenmanMonteith", author="Peter Krause", description="Calculates potential ETP after Penman-Monteith")
public class RefET_Array
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temporal resolution [d | h | m]")
    public Attribute.String tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable wind")
    public Attribute.DoubleArray wind;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable mean temperature")
    public Attribute.DoubleArray tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable relative humidity")
    public Attribute.DoubleArray rhum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable net radiation")
    public Attribute.DoubleArray netRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute elevation")
    public Attribute.DoubleArray elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="potential refET [mm/ timeUnit]")
    public Attribute.DoubleArray refET;

    public void init() throws Attribute.Entity.NoSuchAttributeException, IOException {
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException, IOException {
        double[] netRad = this.netRad.getValue();
        double[] temperature = this.tmean.getValue();
        double[] rhum = this.rhum.getValue();
        double[] wind = this.wind.getValue();
        double[] elevation = this.elevation.getValue();
        double rs = 70.0;
        double[] ra = new double[wind.length];
        double[] abs_temp = new double[wind.length];
        double[] delta_s = new double[wind.length];
        double[] pz = new double[wind.length];
        double[] est = new double[wind.length];
        double[] ea = new double[wind.length];
        double[] latH = new double[wind.length];
        double[] psy = new double[wind.length];
        double[] G = new double[wind.length];
        double[] pet = new double[wind.length];
        for (int i = 0; i < wind.length; ++i) {
            ra[i] = 208.0 / wind[i];
            abs_temp[i] = ClimatologicalVariables.calc_absTemp(temperature[i], "degC");
            delta_s[i] = ClimatologicalVariables.calc_slopeOfSaturationPressureCurve(temperature[i]);
            pz[i] = ClimatologicalVariables.calc_atmosphericPressure(elevation[i], abs_temp[i]);
            est[i] = ClimatologicalVariables.calc_saturationVapourPressure(temperature[i]);
            ea[i] = ClimatologicalVariables.calc_vapourPressure(rhum[i], est[i]);
            latH[i] = ClimatologicalVariables.calc_latentHeatOfVaporization(temperature[i]);
            psy[i] = ClimatologicalVariables.calc_psyConst(pz[i], latH[i]);
            G[i] = this.calc_groundHeatFlux(netRad[i]);
            double tempFactor = 0.0;
            if (this.tempRes.getValue().equals("d")) {
                tempFactor = 891.0;
            } else if (this.tempRes.getValue().equals("h")) {
                tempFactor = 37.0;
            } else if (this.tempRes.getValue().equals("m")) {
                tempFactor = 891.0;
            }
            pet[i] = (0.408 * delta_s[i] * (netRad[i] - G[i]) + psy[i] * (tempFactor / (temperature[i] + 273.0)) * wind[i] * (est[i] - ea[i])) / (delta_s[i] + psy[i] * (1.0 + 0.34 * wind[i]));
            if (!(pet[i] < 0.0)) continue;
            pet[i] = 0.0;
        }
        this.refET.setValue(pet);
    }

    public void cleanup() throws IOException {
    }

    private double calcETAllen(double ds, double netRad, double G, double pa, double CP, double est, double ea, double ra, double rs, double psy, double tempFactor) {
        double Letp = ((ds /= 10.0) * (netRad - G) + pa * (CP /= 1000.0) * ((est /= 10.0) - (ea /= 10.0)) / ra * tempFactor) / (ds + (psy /= 10000.0) * (1.0 + rs / ra));
        return Letp;
    }

    private double calc_groundHeatFlux(double netRad) {
        double g = 0.1 * netRad;
        return g;
    }

    private static double calcRa(double eff_height, double wind_speed) {
        if (wind_speed <= 0.0) {
            wind_speed = 0.5;
        }
        double ra = eff_height < 10.0 ? 1.5 * Math.pow(Math.log(2.0 / (0.125 * eff_height)), 2.0) / (Math.pow(0.41, 2.0) * wind_speed) : 64.0 / (Math.pow(0.41, 2.0) * wind_speed);
        return ra;
    }

    private double calcRs(double LAI, double rsc, double rss) {
        double A = Math.pow(0.7, LAI);
        double rs = 1.0 / ((1.0 - A) / rsc + A / rss);
        return rs;
    }
}

