/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import jams.tools.FileTools;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.unijena.j2k.J2KFunctions;

public class MultiEntityReaderTS22_obsolete
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU parameter file name")
    public Attribute.String hruFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Reach parameter file name")
    public Attribute.String reachFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Parameter file name for topological linkage with receiver entities")
    public Attribute.String to_hru_FileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Parameter file name for weighting of contribution area to receiver entities")
    public Attribute.String bfl_FileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Collection of hru objects")
    public Attribute.EntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Collection of reach objects")
    public Attribute.EntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Collection of hru objects with their topology")
    public Attribute.EntityCollection topology;

    public void init() throws Attribute.Entity.NoSuchAttributeException, FileNotFoundException, IOException {
        ArrayList<Attribute.Entity> hruCollection = J2KFunctions.readParas(FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.hruFileName.getValue()), this.getModel());
        for (Attribute.Entity e : hruCollection) {
            try {
                e.setId((long)e.getDouble(this.hruFileName.getValue()));
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.getModel().getRuntime().sendErrorMsg("Couldn't find attribute \"ID\" while reading J2K HRUu parameter file (" + this.hruFileName.getValue() + ")!");
            }
        }
        this.hrus.setEntities(hruCollection);
        ArrayList<Attribute.Entity> reachCollection = J2KFunctions.readParas(FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.reachFileName.getValue()), this.getModel());
        for (Attribute.Entity e : reachCollection) {
            try {
                e.setId((long)e.getDouble(this.reachFileName.getValue()));
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.getModel().getRuntime().sendErrorMsg("Couldn't find attribute \"ID\" while reading J2K Reach parameter file (" + this.reachFileName.getValue() + ")!");
            }
        }
        this.reaches.setEntities(reachCollection);
        this.createTopology();
        this.getModel().getRuntime().println("Create ordered reach-list", 2);
        this.createOrderedList(this.reaches, "to_reach");
        this.getModel().getRuntime().println("Create ordered hru-list", 2);
        this.createOrderedList(this.hrus, "to_poly");
        this.getModel().getRuntime().println("Entities read successfull!", 2);
    }

    private void createTopology() {
        HashMap<Double, Attribute.Entity> hruMap = new HashMap<Double, Attribute.Entity>();
        HashMap<Double, Attribute.Entity> reachMap = new HashMap<Double, Attribute.Entity>();
        for (Attribute.Entity aktuelleHRU : this.hrus.getEntities()) {
            hruMap.put(aktuelleHRU.getDouble("ID"), aktuelleHRU);
        }
        for (Attribute.Entity aktuellerReach : this.reaches.getEntities()) {
            reachMap.put(aktuellerReach.getDouble("ID"), aktuellerReach);
        }
        Attribute.Entity nullEntity = this.getModel().getRuntime().getDataFactory().createEntity();
        hruMap.put(new Double(0.0), nullEntity);
        reachMap.put(new Double(0.0), nullEntity);
        try {
            BufferedReader reader1 = new BufferedReader(new FileReader(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.to_hru_FileName.getValue()));
            BufferedReader reader2 = new BufferedReader(new FileReader(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.bfl_FileName.getValue()));
            String toHRUsLine = "#";
            while (toHRUsLine.startsWith("#")) {
                toHRUsLine = reader1.readLine();
            }
            String toHRUsWeightsLine = "#";
            while (toHRUsWeightsLine.startsWith("#")) {
                toHRUsWeightsLine = reader2.readLine();
            }
            while (toHRUsLine != null && !toHRUsLine.startsWith("#")) {
                Attribute.Entity aktuelleHRU;
                String zeichenkette = ",-8888.000,";
                String[] toHRUsSplitArray = toHRUsLine.split(zeichenkette);
                String[] toHRUsWeightsSplitArray = toHRUsWeightsLine.split(zeichenkette);
                int HRUsID = Integer.parseInt(toHRUsSplitArray[0]);
                double HRUsBFl = Double.parseDouble(toHRUsSplitArray[1]);
                String toHRUsString = toHRUsSplitArray[2];
                aktuelleHRU = (Attribute.Entity)hruMap.get(HRUsID);
                aktuelleHRU.setDouble("BFLDouble", HRUsBFl);
                int HRUsID2 = Integer.parseInt(toHRUsWeightsSplitArray[0]);
                String toHRUsWeightsString = toHRUsWeightsSplitArray[2];
                if (HRUsID != HRUsID2) {
                    this.getModel().getRuntime().sendHalt("Tabellen sind nicht gleich sortiert.");
                }
                ArrayList<Attribute.Entity> toHRUsArrayList = new ArrayList<Attribute.Entity>();
                ArrayList<Attribute.Entity> toReachesArrayList = new ArrayList<Attribute.Entity>();
                ArrayList<Double> toHRUsWeightsArrayList = new ArrayList<Double>();
                ArrayList<Double> toReachesWeightsArrayList = new ArrayList<Double>();
                ArrayList toHRUsBFlArrayList = new ArrayList();
                StringTokenizer toHRUsToken = new StringTokenizer(toHRUsString, ",");
                StringTokenizer toHRUsWeightsToken = new StringTokenizer(toHRUsWeightsString, ",");
                boolean tschuessnull = false;
                double sumWeights = 1.0;
                while (toHRUsToken.hasMoreTokens() && !tschuessnull) {
                    String stringID = toHRUsToken.nextToken();
                    double toHRUsID = Double.parseDouble(stringID);
                    String stringWeight = toHRUsWeightsToken.nextToken();
                    double toHRUsWeight = Double.parseDouble(stringWeight);
                    sumWeights = 1.0E-4 * (double)Math.round((sumWeights - toHRUsWeight) * 10000.0);
                    if (toHRUsID == 0.0 && toHRUsWeight != 0.0 || toHRUsID != 0.0 && toHRUsWeight == 0.0) {
                        this.getModel().getRuntime().sendHalt("Fehler bei HRU " + HRUsID + ". Anzahl der Empfaenger-HRUs und der Wichtungen stimmen nicht ueberein.");
                    }
                    if (toHRUsID > 0.0) {
                        Attribute.Entity zielHRU = (Attribute.Entity)hruMap.get(toHRUsID);
                        toHRUsArrayList.add(zielHRU);
                        toHRUsWeightsArrayList.add(toHRUsWeight);
                    }
                    if (toHRUsID < 0.0) {
                        double toReachesID = toHRUsID * -1.0;
                        Attribute.Entity zielReach = (Attribute.Entity)reachMap.get(toReachesID);
                        toReachesArrayList.add(zielReach);
                        toReachesWeightsArrayList.add(toHRUsWeight);
                    }
                    if (toHRUsID != 0.0) continue;
                    tschuessnull = true;
                }
                if ((sumWeights = Math.abs(sumWeights)) >= 0.001) {
                    this.getModel().getRuntime().sendHalt("Fehler bei HRU " + HRUsID + ". Summe der einzelnen Gewichte ungleich 1");
                }
                Attribute.Entity[] toHRUsArray = toHRUsArrayList.toArray(new Attribute.Entity[toHRUsArrayList.size()]);
                Attribute.Entity[] toReachesArray = toReachesArrayList.toArray(new Attribute.Entity[toReachesArrayList.size()]);
                Double[] toHRUsWeightsArray = toHRUsWeightsArrayList.toArray(new Double[toHRUsWeightsArrayList.size()]);
                Double[] toReachesWeightsArray = toReachesWeightsArrayList.toArray(new Double[toReachesWeightsArrayList.size()]);
                Double[] toHRUsBflArray = toHRUsBFlArrayList.toArray(new Double[toHRUsWeightsArrayList.size()]);
                aktuelleHRU.setObject("to_poly", (Object)toHRUsArray);
                aktuelleHRU.setObject("to_reach", (Object)toReachesArray);
                aktuelleHRU.setObject("to_poly_weights", (Object)toHRUsWeightsArray);
                aktuelleHRU.setObject("to_reach_weights", (Object)toReachesWeightsArray);
                aktuelleHRU.setObject("bfl", (Object)toHRUsBflArray);
                sumWeights = 1.0;
                toHRUsLine = reader1.readLine();
                toHRUsWeightsLine = reader2.readLine();
            }
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().handle((Throwable)ioe);
        }
        for (Attribute.Entity aktuellerReach : this.reaches.getEntities()) {
            aktuellerReach.setObject("to_reach", reachMap.get((int)aktuellerReach.getDouble("to-reach")));
        }
    }

    protected void createOrderedList(Attribute.EntityCollection hrus, String asso) throws Attribute.Entity.NoSuchAttributeException, FileNotFoundException, IOException {
        int i;
        Attribute.Entity aktuelleHRU2 = null;
        ArrayList<Attribute.Entity> hruList = new ArrayList<Attribute.Entity>();
        HashMap statusMap = new HashMap();
        HashMap fromHRUMap = new HashMap();
        HashMap fromIMap = new HashMap();
        HashMap<Object, Integer> depthMap = new HashMap<Object, Integer>();
        boolean aufloesbar = false;
        boolean unaufloesbar = false;
        boolean geaendert = true;
        Iterator hruIterator = hrus.getEntities().iterator();
        while (hruIterator.hasNext()) {
            depthMap.put(hruIterator.next(), new Integer(0));
        }
        while (geaendert) {
            geaendert = false;
            for (Attribute.Entity aktuelleHRU2 : hrus.getEntities()) {
                Integer fDepth;
                Attribute.Entity[] aktuelleHRU_toHRUs;
                Integer eDepth = (Integer)depthMap.get(aktuelleHRU2);
                if (asso.toString().equals("to_poly") && (aktuelleHRU_toHRUs = (Attribute.Entity[])aktuelleHRU2.getObject(asso)).length > 0) {
                    for (int i2 = 0; i2 < aktuelleHRU_toHRUs.length; ++i2) {
                        if (aktuelleHRU_toHRUs[i2] == null || (fDepth = (Integer)depthMap.get(aktuelleHRU_toHRUs[i2])) > eDepth) continue;
                        depthMap.put(aktuelleHRU_toHRUs[i2], new Integer(eDepth + 1));
                        geaendert = true;
                    }
                }
                if (!asso.toString().equals("to_reach")) continue;
                Attribute.Entity aktuelleHRU_toReaches = (Attribute.Entity)aktuelleHRU2.getObject(asso);
                if (aktuelleHRU_toReaches.isEmpty()) {
                    aktuelleHRU_toReaches = null;
                }
                if (aktuelleHRU_toReaches == null || (fDepth = (Integer)depthMap.get(aktuelleHRU_toReaches)) > eDepth) continue;
                depthMap.put(aktuelleHRU_toReaches, new Integer(eDepth + 1));
                geaendert = true;
            }
        }
        int maxDepth = 0;
        for (Attribute.Entity aktuelleHRU2 : hrus.getEntities()) {
            maxDepth = Math.max(maxDepth, (Integer)depthMap.get(aktuelleHRU2));
        }
        ArrayList alList = new ArrayList();
        for (i = 0; i <= maxDepth; ++i) {
            alList.add(new ArrayList());
        }
        for (Attribute.Entity aktuelleHRU2 : hrus.getEntities()) {
            int depth = (Integer)depthMap.get(aktuelleHRU2);
            ((ArrayList)alList.get(depth)).add(aktuelleHRU2);
        }
        for (i = 0; i <= maxDepth; ++i) {
            for (Attribute.Entity aktuelleHRU2 : (ArrayList)alList.get(i)) {
                hruList.add(aktuelleHRU2);
            }
        }
        hrus.setEntities(hruList);
    }
}

