/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;

public class ContourBanksReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="An- bzw. Ausschalten des Moduls")
    public Attribute.Boolean cbModulAktiv;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Parameter file name for ContourBanks")
    public Attribute.String contourbankFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Collection of hru objects")
    public Attribute.EntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="ContourBank-Hoehe")
    public Attribute.Double cbWallhoehe;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="ContourBank-Boeschungswinkel vorn")
    public Attribute.Double cbBoeschungswinkelWall_vorn;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="ContourBank-Boeschungswinkel hinten")
    public Attribute.Double cbBoeschungswinkelWall_hinten;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="ContourBank-Grabentiefe direkt hinter dem Wall")
    public Attribute.Double cbTiefeGraben_vorn;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="ContourBank-Grabenbreite")
    public Attribute.Double cbBreiteGraben;
    boolean modulCBaktiv;

    public void init() throws Attribute.Entity.NoSuchAttributeException, FileNotFoundException, IOException {
        this.modulCBaktiv = this.cbModulAktiv.getValue();
        if (this.modulCBaktiv) {
            double wallhoeheCB = this.cbWallhoehe.getValue();
            double boeschungswinkelWall_vorn = this.cbBoeschungswinkelWall_vorn.getValue();
            double boeschungswinkelWall_hinten = this.cbBoeschungswinkelWall_hinten.getValue();
            double breiteGraben = this.cbBreiteGraben.getValue();
            HashMap<Double, Attribute.Entity> hruMap = new HashMap<Double, Attribute.Entity>();
            for (Attribute.Entity aktuelleHRU : this.hrus.getEntities()) {
                aktuelleHRU.setDouble("cbAnzahl", 0.0);
                aktuelleHRU.setDouble("cbGesamtlaenge", 0.0);
                aktuelleHRU.setDouble("cbGrabentiefe_vorn", 0.0);
                aktuelleHRU.setDouble("cbFassungsvermoegenMax", 0.0);
                aktuelleHRU.setDouble("cbSpeicherAkt", 0.0);
                aktuelleHRU.setDouble("cbAbfussReach", 0.0);
                double[] anteileKomponentenCBReach_Array = new double[]{0.0, 0.0, 0.0};
                aktuelleHRU.setObject("cbAnteileKomponenten", (Object)anteileKomponentenCBReach_Array);
                hruMap.put(aktuelleHRU.getDouble("ID"), aktuelleHRU);
            }
            BufferedReader reader5 = new BufferedReader(new FileReader(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.contourbankFileName.getValue()));
            String HRUsLine = "#";
            while (HRUsLine.startsWith("#")) {
                HRUsLine = reader5.readLine();
            }
            while (HRUsLine != null && !HRUsLine.startsWith("#")) {
                Attribute.Entity aktuelleHRU;
                String zeichenkette = ",-8888.000,";
                String[] HRUsSplitArray = HRUsLine.split(zeichenkette);
                double HRUsID = Double.parseDouble(HRUsSplitArray[0]);
                double anzahlCB = Double.parseDouble(HRUsSplitArray[1]);
                double gesamtlaengeCB = Double.parseDouble(HRUsSplitArray[2]);
                aktuelleHRU = (Attribute.Entity)hruMap.get(HRUsID);
                double HRUsSlope = aktuelleHRU.getDouble("slope");
                double maechtigkeitRD2_cm = aktuelleHRU.getDouble("depth");
                double maechtigkeitRG1_cm = aktuelleHRU.getDouble("depthRG1");
                double maechtigkeitRD2_senkrecht_m = maechtigkeitRD2_cm / 100.0 / Math.sin(Math.toRadians(90.0 - HRUsSlope));
                double maechtigkeitRG1_senkrecht_m = maechtigkeitRG1_cm / 100.0 / Math.sin(Math.toRadians(90.0 - HRUsSlope));
                double tiefeGraben_vorn = this.cbTiefeGraben_vorn.getValue();
                double tiefeGraben_hinten = tiefeGraben_vorn + breiteGraben * Math.tan(Math.toRadians(HRUsSlope));
                if (tiefeGraben_hinten >= maechtigkeitRD2_senkrecht_m + maechtigkeitRG1_senkrecht_m) {
                    tiefeGraben_hinten = maechtigkeitRD2_senkrecht_m + maechtigkeitRG1_senkrecht_m - 0.01;
                    tiefeGraben_vorn = tiefeGraben_hinten - breiteGraben * Math.tan(Math.toRadians(HRUsSlope));
                }
                double hoeheWallMitte = wallhoeheCB - wallhoeheCB * Math.tan(Math.toRadians(HRUsSlope)) / Math.tan(Math.toRadians(boeschungswinkelWall_vorn));
                double flaecheDreieck1 = 0.5 * Math.pow(hoeheWallMitte, 2.0) / Math.tan(Math.toRadians(HRUsSlope));
                double flaecheDreieck2 = 0.5 * Math.pow(hoeheWallMitte, 2.0) / Math.tan(Math.toRadians(boeschungswinkelWall_hinten));
                double ankatheteDreieck1 = hoeheWallMitte / Math.tan(Math.toRadians(boeschungswinkelWall_hinten));
                double ankatheteDreieck2 = ankatheteDreieck1 * Math.tan(Math.toRadians(boeschungswinkelWall_hinten)) / (Math.tan(Math.toRadians(HRUsSlope)) + Math.tan(Math.toRadians(boeschungswinkelWall_hinten)));
                double flaecheDreieck3 = 0.5 * Math.tan(Math.toRadians(HRUsSlope)) * Math.pow(ankatheteDreieck2, 2.0);
                double flaecheDreieck4 = 0.5 * Math.tan(Math.toRadians(boeschungswinkelWall_hinten)) * Math.pow(ankatheteDreieck1 - ankatheteDreieck2, 2.0);
                double teilflaeche1 = flaecheDreieck1 - flaecheDreieck2 + flaecheDreieck3 + flaecheDreieck4;
                double teilflaeche2 = tiefeGraben_vorn * breiteGraben;
                double teilflaeche3 = 0.5 * Math.pow(breiteGraben, 2.0) * Math.tan(Math.toRadians(HRUsSlope));
                double querschnittCB_max = teilflaeche1 + teilflaeche2 + teilflaeche3;
                double fassungsvermoegenCB_max = 1000.0 * querschnittCB_max * gesamtlaengeCB;
                aktuelleHRU.setDouble("cbAnzahl", anzahlCB);
                aktuelleHRU.setDouble("cbGesamtlaenge", gesamtlaengeCB);
                aktuelleHRU.setDouble("cbGrabentiefe_vorn", tiefeGraben_vorn);
                aktuelleHRU.setDouble("cbFassungsvermoegenMax", fassungsvermoegenCB_max);
                HRUsLine = reader5.readLine();
            }
        }
    }
}

