/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k;

import jams.data.Attribute;
import jams.io.GenericDataWriter;
import jams.model.Component;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSContext;
import jams.model.JAMSVarDescription;
import jams.runtime.RuntimeException;
import java.util.Random;
import java.util.StringTokenizer;

@JAMSComponentDescription(title="InErrorContext", author="Peter Krause", description="Context component which helps in estimating the uncertaintywhich results e.g. from problems with the input data. The component doesonly let the model run for a specified number of times and helps in producing specific model output.")
public class MultipleModelRunContext
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Number of model evaluations")
    public Attribute.Integer modelRuns;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="efficiency methods")
    public Attribute.String effMethodNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="efficiency values")
    public Attribute.Double[] effValues;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Flag for dis/enabling this sampler")
    public Attribute.Boolean enable;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ)
    public Attribute.String effFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ)
    public Attribute.String targetFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The model time interval")
    public Attribute.TimeInterval modelTimeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Output file attribute")
    public Attribute.DoubleArray targetValue;
    Random generator = new Random();
    GenericDataWriter effWriter;
    GenericDataWriter targetWriter;
    int currentCount;
    double[][] valueArray;
    int timeStepCounter = 0;
    int runCounter = 0;
    int timeSteps = 0;

    public void init() {
        if (this.enable.getValue()) {
            int i = 0;
            StringTokenizer tok = new StringTokenizer(this.effMethodNames.getValue(), ";");
            String[] effNames = new String[tok.countTokens()];
            i = 0;
            while (tok.hasMoreTokens()) {
                String key;
                effNames[i] = key = tok.nextToken();
                ++i;
            }
            this.effWriter = new GenericDataWriter(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.effFileName.getValue());
            this.effWriter.addColumn("Run");
            for (int e = 0; e < effNames.length; ++e) {
                this.effWriter.addColumn(effNames[e]);
            }
            this.effWriter.writeHeader();
            this.targetWriter = new GenericDataWriter(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.targetFileName.getValue());
            this.targetWriter.addComment("J2K model output");
            this.targetWriter.addComment("");
            this.targetWriter.addColumn("date/time");
            for (int s = 0; s < this.modelRuns.getValue(); ++s) {
                int counter = s + 1;
                this.targetWriter.addColumn("Run_" + counter);
            }
            this.targetWriter.writeHeader();
            this.timeSteps = (int)this.modelTimeInterval.getNumberOfTimesteps();
            this.valueArray = new double[this.modelRuns.getValue()][this.timeSteps];
            this.timeStepCounter = 0;
            this.runCounter = 0;
        }
    }

    public void run() {
        if (this.runEnumerator == null) {
            this.runEnumerator = this.getChildrenEnumerator();
        }
        if (!this.enable.getValue()) {
            this.singleRun();
        } else {
            while (this.hasNext()) {
                this.singleRun();
                this.effWriter.addData((Object)this.currentCount);
                for (int e = 0; e < this.effValues.length; ++e) {
                    this.effWriter.addData((Object)this.effValues[e].getValue());
                }
                try {
                    this.effWriter.writeData();
                    this.effWriter.flush();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                this.valueArray[this.runCounter] = this.targetValue.getValue();
                ++this.runCounter;
            }
            this.runEnumerator.reset();
            while (this.runEnumerator.hasNext() && this.doRun) {
                Component component = this.runEnumerator.next();
            }
        }
    }

    public void cleanup() {
        if (this.enable.getValue()) {
            Attribute.Calendar timeStamp = this.modelTimeInterval.getStart();
            for (int t = 0; t < this.timeSteps; ++t) {
                this.targetWriter.addData((Object)timeStamp.toString());
                timeStamp.add(this.modelTimeInterval.getTimeUnit(), 1);
                for (int r = 0; r < this.modelRuns.getValue(); ++r) {
                    this.targetWriter.addData((Object)this.valueArray[r][t]);
                }
                try {
                    this.targetWriter.writeData();
                    continue;
                }
                catch (RuntimeException jre) {
                    this.getModel().getRuntime().println(jre.getMessage());
                }
            }
            this.targetWriter.flush();
            this.targetWriter.close();
            this.effWriter.close();
        }
    }

    private void singleRun() {
        Component comp;
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            ++this.currentCount;
            try {
                comp.init();
            }
            catch (Exception exception) {}
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.initAll();
            }
            catch (Exception exception) {}
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.run();
            }
            catch (Exception exception) {}
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.cleanup();
            }
            catch (Exception exception) {}
        }
    }

    private boolean hasNext() {
        return this.currentCount < this.modelRuns.getValue();
    }
}

