/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.potET;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.io.IOException;
import org.unijena.j2k.physicalCalculations.ClimatologicalVariables;

@JAMSComponentDescription(title="CalcPotentialETSamani", author="Peter Krause", version="1.2", description="Calculates potential ET according to Hargreaves Samani")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version", date="2011-05-30"), @VersionComments.Entry(version="1.0_1", comment="Corrected description of units of potET/actET", date="2018-07-04"), @VersionComments.Entry(version="1.1", comment="Data caching removed. Increase robustness in case of tmin > tmax; this can occur if datagaps are unfortunate. Manfred ", date="2021-09-01"), @VersionComments.Entry(version="1.2", comment="Including the use of a crop factor, Manfred ", date="2021-10-22"), @VersionComments.Entry(version="1.2", comment="Including the use of an altitude factor, Manfred ", date="2022-09-28")})
public class HargreavesSamani
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temporal resolution [d | m]")
    public Attribute.String tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable minimum air temperature", unit="degC")
    public Attribute.Double tmin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable mean temperature", unit="degC")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable maximum air temperature", unit="degC")
    public Attribute.Double tmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable extraterrestrial radiation", unit="MJ m^-2 day^-1")
    public Attribute.Double extRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute area")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU attribute name elevation", defaultValue="0.0")
    public Attribute.Double elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="crop factor", defaultValue="1.0")
    public Attribute.Double Kc;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Multplier for the adaptation per meter of ET according to altitude", defaultValue="0.0", lowerBound=-0.002, upperBound=0.002)
    public Attribute.Double Altituede_factor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Base altitude for the adaptation per meter of ET according to altitude", defaultValue="400.0", lowerBound=-200.0, upperBound=9000.0)
    public Attribute.Double Altituede_base;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="potential ET", unit="L")
    public Attribute.Double potET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="actual ET", unit="L")
    public Attribute.Double actET;

    public void init() throws Attribute.Entity.NoSuchAttributeException, IOException {
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException, IOException {
        double extRad = this.extRad.getValue();
        double tmin = this.tmin.getValue();
        double tavg = this.tmean.getValue();
        double tmax = this.tmax.getValue();
        double area = this.area.getValue();
        double Kc = this.Kc.getValue();
        double deltaET = 0.0;
        double latH = ClimatologicalVariables.calc_latentHeatOfVaporization(tavg);
        double pET = 0.0;
        double aET = 0.0;
        if (tmin > tmax) {
            if (tmax > tavg) {
                tmin = tavg - (tmax - tavg);
            } else if (tmin < tavg) {
                tmax = tavg + (tavg - tmin);
            } else {
                tmin = tmax;
            }
        }
        pET = 0.0023 * extRad * Math.sqrt(tmax - tmin) * (tavg + 17.8) / latH * Kc;
        pET *= area;
        if (this.time != null && this.tempRes.getValue().equals("m")) {
            int daysInMonth = this.time.getActualMaximum(5);
            pET *= (double)daysInMonth;
        }
        if (pET < 0.0) {
            pET = 0.0;
        }
        deltaET = (this.Altituede_base.getValue() - this.elevation.getValue()) * this.Altituede_factor.getValue() * pET;
        deltaET = Math.max(-pET, deltaET);
        deltaET = Math.min(pET, deltaET);
        this.potET.setValue(pET += deltaET);
        if (!(pET >= 0.0)) {
            System.out.println("extRad = " + extRad + " tmin = " + tmin + " tavg = " + tavg + " tmax  = " + tmax + " area = " + area + "latH = " + latH);
        }
        this.actET.setValue(aET);
    }

    public void cleanup() throws IOException {
    }
}

