/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Value array provider", author="Peter Krause", description="Retreives single variables from a context and stores themin a value array for later processing")
public class ValueArrayProvider
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the timeSeries values to capture")
    public Attribute.Double theValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="the captured time series")
    public Attribute.DoubleArray theValueArray;

    public void init() {
    }

    public void run() {
        double[] newArray = null;
        double[] dataArray = this.theValueArray.getValue();
        if (dataArray == null) {
            newArray = new double[]{this.theValue.getValue()};
        } else {
            newArray = new double[dataArray.length + 1];
            for (int i = 0; i < dataArray.length; ++i) {
                newArray[i] = dataArray[i];
            }
            newArray[dataArray.length] = this.theValue.getValue();
        }
        this.theValueArray.setValue(newArray);
    }

    public void cleanup() {
    }
}

