/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.io.GenericDataWriter;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import jams.runtime.RuntimeException;
import jams.tools.JAMSTools;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class StandardDataWriter
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time interval")
    public Attribute.TimeInterval timeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file name")
    public Attribute.String fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file header descriptions")
    public Attribute.StringArray headers;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file attributes")
    public Attribute.Double[] value;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output data precision")
    public Attribute.Integer precision;
    private GenericDataWriter writer;
    private int prec;
    private DateFormat dateFormat;

    public void init() {
        this.writer = new GenericDataWriter(JAMSTools.CreateAbsoluteFileName((String)this.getModel().getWorkspace().getOutputDataDirectory().getPath(), (String)this.fileName.getValue()));
        this.writer.addComment("J2K model output");
        this.writer.addComment("");
        this.writer.addColumn("date");
        for (int i = 0; i < this.headers.getValue().length; ++i) {
            this.writer.addColumn(this.headers.getValue()[i]);
        }
        this.writer.writeHeader();
        this.prec = this.precision == null ? 3 : this.precision.getValue();
        int tu = this.timeInterval.getTimeUnit();
        String timeFormat = "%1$tY-%1$tm-%1$td %1$tH:%1$tM";
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        if (tu == 11) {
            timeFormat = "%1$td.%1$tm.%1$tY %1$tH:%1$tM";
            this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        } else if (tu == 6) {
            timeFormat = "%1$td.%1$tm.%1$tY";
            this.dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        } else if (tu == 2) {
            timeFormat = "%1$tm/%1$tY";
            this.dateFormat = new SimpleDateFormat("MM/yyyy");
        } else if (tu == 1) {
            timeFormat = "%1$tY";
            this.dateFormat = new SimpleDateFormat("yyyy");
        }
        this.dateFormat.setTimeZone(Attribute.Calendar.DEFAULT_TIME_ZONE);
    }

    public void run() {
        this.writer.addData((Object)this.time.toString(this.dateFormat));
        for (int i = 0; i < this.value.length; ++i) {
            this.writer.addData(this.value[i].getValue(), this.prec);
        }
        try {
            this.writer.writeData();
        }
        catch (RuntimeException jre) {
            this.getModel().getRuntime().println(jre.getMessage());
        }
    }

    public void cleanup() {
        try {
            this.writer.writer.flush();
            this.writer.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

