/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="CalcLanduseStateVars", author="Peter Krause", description="Calculates landuse state variables for a modelling unitThe calculation is done for a standard year (i.e. 366 days or 8784 hours).The module can be used in hourly, daily and monthly resolution.", version="1.0_2", date="2019-02-01")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", date="2011-05-30", comment="Initial version"), @VersionComments.Entry(version="1.0_1", date="2016-05-13", comment="Added default value for tempRes; added elevationAdaptation attribute to switch off adaptation of vegetation period depending on elevation"), @VersionComments.Entry(version="1.0_2", date="2019-02-01", comment="Elevation adaptation now works for both effHeigth and LAI")})
public class CalcLanduseStateVars
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The current spatial entity")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array with LAI values for a standard year")
    public Attribute.DoubleArray LAIArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array with eff. Height values for a standard year")
    public Attribute.DoubleArray effHArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Monthly stomata resistance values", lowerBound=0.0, upperBound=150.0, unit="s / m")
    public Attribute.DoubleArray rsc0Array;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="elevation of the spatial modelling entity", lowerBound=0.0, unit="m")
    public Attribute.Double elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temporal resolution [d | h | m]", defaultValue="d")
    public Attribute.String tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Adaptation of vegetation period depending on elevation", defaultValue="true")
    public Attribute.Boolean elevationAdaptation;
    int[] monthMean = new int[]{15, 45, 74, 105, 135, 166, 196, 227, 258, 288, 319, 349};
    int oldmonth = 0;
    double rsc0 = 0.0;
    boolean LAIBugReported = false;

    public void init() {
    }

    public void run() {
        int julDay;
        int j;
        Attribute.Entity entity = this.entities.getCurrent();
        double[] lai_vals = null;
        double[] effH_vals = null;
        if (this.tempRes == null || this.tempRes.getValue().equals("d") || this.tempRes.getValue().equals("h")) {
            lai_vals = new double[366];
            effH_vals = new double[366];
        } else if (this.tempRes.getValue().equals("m")) {
            lai_vals = new double[12];
            effH_vals = new double[12];
        }
        double HRUelevation = this.elevation.getValue();
        double[] lais = new double[4];
        String laiName = "LAI_d";
        for (int i = 0; i < 4; ++i) {
            int count = i + 1;
            String loopName = laiName + count;
            lais[i] = entity.getDouble(loopName);
        }
        double[] effH = new double[4];
        String effName = "effHeight_d";
        for (int i = 0; i < 4; ++i) {
            int count = i + 1;
            String loopName = effName + count;
            effH[i] = entity.getDouble(loopName);
        }
        if (this.tempRes == null || this.tempRes.getValue().equals("d") || this.tempRes.getValue().equals("h")) {
            for (j = 0; j < 366; ++j) {
                julDay = j + 1;
                lai_vals[j] = this.calcLAI(lais, HRUelevation, julDay);
                effH_vals[j] = this.calcEffHeight(effH, HRUelevation, julDay);
            }
        } else if (this.tempRes.getValue().equals("m")) {
            for (j = 0; j < 12; ++j) {
                julDay = this.monthMean[j];
                lai_vals[j] = this.calcLAI(lais, HRUelevation, julDay);
                effH_vals[j] = this.calcEffHeight(effH, HRUelevation, julDay);
            }
        }
        this.LAIArray.setValue(lai_vals);
        this.effHArray.setValue(effH_vals);
        double[] rsc0 = new double[12];
        String rsc0Name = "RSC0_";
        for (int i = 0; i < 12; ++i) {
            int count = i + 1;
            String loopName = rsc0Name + count;
            rsc0[i] = entity.getDouble(loopName);
        }
        this.rsc0Array.setValue(rsc0);
    }

    public void cleanup() {
    }

    private double calcLAI(double[] lais, double targetElevation, int julDay) {
        int d4;
        int d3;
        int d2;
        int d1;
        int dTime = 0;
        double Lait1 = 0.0;
        double dLai = 0.0;
        int d1_400 = 110;
        int d2_400 = 150;
        int d3_400 = 250;
        int d4_400 = 280;
        if (this.elevationAdaptation.getValue()) {
            d1 = (int)((double)d1_400 + 0.025 * (targetElevation - 400.0));
            d2 = (int)((double)d2_400 + 0.025 * (targetElevation - 400.0));
            d3 = (int)((double)d3_400 - 0.025 * (targetElevation - 400.0));
            d4 = (int)((double)d4_400 - 0.025 * (targetElevation - 400.0));
        } else {
            d1 = d1_400;
            d2 = d2_400;
            d3 = d3_400;
            d4 = d4_400;
        }
        if (lais[0] != lais[3] && !this.LAIBugReported) {
            this.LAIBugReported = true;
            this.getModel().getRuntime().sendInfoMsg("Warning: LAI0 and LAI3 should be the same in landuse class");
        }
        double lai0 = lais[0];
        double lai1 = lais[1];
        double lai2 = lais[2];
        double lai3 = lais[3];
        if (d1 > d3) {
            if (d1 > d4) {
                d1 = d4;
                d2 = d4;
                d3 = d4;
                lai0 = lais[0];
                lai1 = lais[0];
                lai2 = lais[0];
                lai3 = lais[3];
            } else {
                d1 = d3;
                d2 = d3;
                d3 = (d3 + d4) / 2;
                lai0 = lais[0];
                lai1 = lais[0];
                lai2 = lais[2];
                lai3 = lais[3];
            }
        } else if (d2 > d3) {
            if (d2 > d4) {
                d2 = d3;
                lai0 = lais[0];
                lai1 = lais[2];
                lai2 = lais[2];
                lai3 = lais[3];
            } else {
                d2 = d3;
                lai0 = lais[0];
                lai1 = lais[2];
                lai2 = lais[2];
                lai3 = lais[3];
            }
        }
        double LAI = 0.0;
        if (julDay <= d1) {
            LAI = lai0;
        } else if (julDay > d1 && julDay <= d2) {
            double LAI_1 = lai0;
            double LAI_2 = lai1;
            dTime = d2 - d1;
            dLai = LAI_2 - LAI_1;
            Lait1 = dLai / (double)dTime;
            LAI = Lait1 * (double)(julDay - d1) + LAI_1;
        } else if (julDay > d2 && julDay <= d3) {
            double LAI_2 = lai1;
            double LAI_3 = lai2;
            dTime = d3 - d2;
            dLai = LAI_3 - LAI_2;
            Lait1 = dLai / (double)dTime;
            LAI = Lait1 * (double)(julDay - d2) + LAI_2;
        } else if (julDay > d3 && julDay <= d4) {
            double LAI_3 = lai2;
            double LAI_4 = lai3;
            dTime = d4 - d3;
            dLai = LAI_4 - LAI_3;
            Lait1 = dLai / (double)dTime;
            LAI = Lait1 * (double)(julDay - d3) + LAI_3;
        } else {
            LAI = lai3;
        }
        return LAI;
    }

    private double calcEffHeight(double[] effHeight, double targetElevation, int julDay) {
        int d4;
        int d3;
        int d2;
        int d1;
        int dTime = 0;
        double effH_t1 = 0.0;
        double deffH = 0.0;
        int d1_400 = 110;
        int d2_400 = 150;
        int d3_400 = 250;
        int d4_400 = 280;
        if (this.elevationAdaptation.getValue()) {
            d1 = (int)((double)d1_400 + 0.025 * (targetElevation - 400.0));
            d2 = (int)((double)d2_400 + 0.025 * (targetElevation - 400.0));
            d3 = (int)((double)d3_400 - 0.025 * (targetElevation - 400.0));
            d4 = (int)((double)d4_400 - 0.025 * (targetElevation - 400.0));
        } else {
            d1 = d1_400;
            d2 = d2_400;
            d3 = d3_400;
            d4 = d4_400;
        }
        double effH = 0.0;
        if (julDay <= d1) {
            effH = effHeight[0];
        } else if (julDay > d1 && julDay <= d2) {
            double effH_1 = effHeight[0];
            double effH_2 = effHeight[1];
            dTime = d2 - d1;
            deffH = effH_2 - effH_1;
            effH_t1 = deffH / (double)dTime;
            effH = effH_t1 * (double)(julDay - d1) + effH_1;
        } else if (julDay > d2 && julDay <= d3) {
            double effH_2 = effHeight[1];
            double effH_3 = effHeight[2];
            dTime = d3 - d2;
            deffH = effH_3 - effH_2;
            effH_t1 = deffH / (double)dTime;
            effH = effH_t1 * (double)(julDay - d2) + effH_2;
        } else if (julDay > d3 && julDay <= d4) {
            double effH_3 = effHeight[2];
            double effH_4 = effHeight[3];
            dTime = d4 - d3;
            deffH = effH_4 - effH_3;
            effH_t1 = deffH / (double)dTime;
            effH = effH_t1 * (double)(julDay - d3) + effH_3;
        } else if (julDay > d4) {
            double effH_4;
            effH = effH_4 = effHeight[3];
        }
        return effH;
    }
}

