/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.thornthwaite;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Thorntwaite snowmelt", author="Sven Kralisch", date="30. September 2005", description="This component calculates the soil moisture, actual ET and surface runoff based on old soil moisture, potET, temperature and precipitation")
public class SoilMoisture
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Soil moisture storage capacity")
    public Attribute.Double soilMoistStorCap;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Potential ET")
    public Attribute.Double potET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Temperature")
    public Attribute.Double temp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Precipitation")
    public Attribute.Double precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Old soil moisture")
    public Attribute.Double prestor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Simulated soil moisture")
    public Attribute.Double soilMoistStor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Surface runoff")
    public Attribute.Double surfaceRunoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Difference between precip and potential ET")
    public Attribute.Double pmpe;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Actual ET")
    public Attribute.Double actET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Difference betwenn potential ET and actual ET")
    public Attribute.Double dff;

    public void run() {
        double soilMoistStorCap = this.soilMoistStorCap.getValue();
        double prestor = this.prestor.getValue();
        double temp = this.temp.getValue();
        double precip = this.precip.getValue();
        double potET = this.potET.getValue();
        double pmpe = precip - potET;
        double surfaceRunoff = 0.0;
        double soilMoistStor = 0.0;
        double actET = 0.0;
        if (temp < 0.0 && pmpe > 0.0) {
            surfaceRunoff = 0.0;
            soilMoistStor = prestor;
            actET = 0.0;
        } else if (pmpe > 0.0 || pmpe == 0.0) {
            actET = potET;
            if (prestor < soilMoistStorCap) {
                soilMoistStor = prestor + pmpe;
            }
            if (prestor == soilMoistStorCap) {
                soilMoistStor = soilMoistStorCap;
            }
            if (soilMoistStor > soilMoistStorCap) {
                soilMoistStor = soilMoistStorCap;
            }
            if ((surfaceRunoff = prestor + pmpe - soilMoistStorCap) < 0.0) {
                surfaceRunoff = 0.0;
            }
            prestor = soilMoistStor;
        } else {
            soilMoistStor = prestor - Math.abs(pmpe * (prestor / soilMoistStorCap));
            if (soilMoistStor < 0.0) {
                soilMoistStor = 0.0;
            }
            double delstor = soilMoistStor - prestor;
            prestor = soilMoistStor;
            actET = precip + delstor * -1.0;
            surfaceRunoff = 0.0;
        }
        this.dff.setValue(potET - actET);
        this.pmpe.setValue(pmpe);
        this.surfaceRunoff.setValue(surfaceRunoff);
        this.soilMoistStor.setValue(soilMoistStor);
        this.actET.setValue(actET);
        this.prestor.setValue(prestor);
    }
}

