/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.thornthwaite;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Thorntwaite runoff", author="Sven Kralisch", date="30. September 2005", description="This component calculates the runoff based on a runoff factor, tank storage, surface runoff and snowmelt")
public class Runoff
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="A factorn defining how much water leaves the model - the remain will be stored in the model", defaultValue="0.05")
    public Attribute.Double runoffFactor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="The remain, i.e. the models tank storage")
    public Attribute.Double remain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Surface runoff water")
    public Attribute.Double surfaceRunoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Water coming from snow melt")
    public Attribute.Double snowMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Simulated runoff as function of tank storage (remain), surface runoff water and snowmelt water")
    public Attribute.Double runoff;

    public void run() {
        double runoffFactor = this.runoffFactor.getValue();
        double surfaceRunoff = this.surfaceRunoff.getValue();
        double snowMelt = this.snowMelt.getValue();
        double remain = this.remain.getValue();
        double ro1 = (surfaceRunoff + remain) * runoffFactor;
        remain = (surfaceRunoff + remain) * (1.0 - runoffFactor);
        this.runoff.setValue(ro1 + snowMelt);
        this.remain.setValue(remain);
    }
}

