/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.layermanager;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.RenderingEvent;
import gov.nasa.worldwind.event.RenderingListener;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.TiledImageLayer;
import gov.nasa.worldwindx.examples.layermanager.LayerPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class LayerManagerPanel
extends JPanel {
    protected JPanel layerNamesPanel;
    protected List<LayerPanel> layerPanels = new ArrayList<LayerPanel>();

    public LayerManagerPanel(final WorldWindow worldWindow) {
        super(new BorderLayout(10, 10));
        this.layerNamesPanel = new JPanel(new GridLayout(0, 1, 0, 5));
        this.layerNamesPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.layerNamesPanel, "North");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 10));
        jPanel2.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Layers")));
        jPanel2.setToolTipText("Layers to Show");
        jPanel2.add(jScrollPane);
        jPanel2.setPreferredSize(new Dimension(200, 500));
        this.add((Component)jPanel2, "Center");
        this.fill(worldWindow);
        worldWindow.addRenderingListener(new RenderingListener(){

            @Override
            public void stageChanged(RenderingEvent renderingEvent) {
                LayerManagerPanel.this.updateLayerActivity(worldWindow);
            }
        });
        worldWindow.getModel().getLayers().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("gov.nasa.worldwind.avkey.LayersObject")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LayerManagerPanel.this.update(worldWindow);
                        }
                    });
                }
            }
        });
    }

    public void update(WorldWindow worldWindow) {
        this.fill(worldWindow);
    }

    protected void fill(WorldWindow worldWindow) {
        if (this.isUpToDate(worldWindow)) {
            return;
        }
        this.layerPanels.clear();
        this.layerNamesPanel.removeAll();
        for (Layer layer : worldWindow.getModel().getLayers()) {
            if (layer.getValue("gov.nasa.worldwind.avkey.Ignore") != null) continue;
            LayerPanel layerPanel = new LayerPanel(worldWindow, layer);
            this.layerNamesPanel.add(layerPanel);
            this.layerPanels.add(layerPanel);
        }
        this.updateLayerActivity(worldWindow);
    }

    protected boolean isUpToDate(WorldWindow worldWindow) {
        LayerList layerList = worldWindow.getModel().getLayers();
        if (this.layerPanels.size() != layerList.size()) {
            return false;
        }
        for (int i = 0; i < layerList.size(); ++i) {
            if (layerList.get(i) == this.layerPanels.get(i).getLayer()) continue;
            return false;
        }
        return true;
    }

    protected void updateLayerActivity(WorldWindow worldWindow) {
        for (LayerPanel layerPanel : this.layerPanels) {
            Long l = (Long)layerPanel.getLayer().getValue("gov.nasa.worldwind.avkey.FrameTimestamp");
            Long l2 = (Long)worldWindow.getSceneController().getValue("gov.nasa.worldwind.avkey.FrameTimestamp");
            if (l != null && l2 != null && l.longValue() == l2.longValue()) {
                layerPanel.setLayerNameFont(layerPanel.getLayerNameFont().deriveFont(1));
                continue;
            }
            if (layerPanel.getLayer() instanceof TiledImageLayer) {
                layerPanel.setLayerNameFont(layerPanel.getLayerNameFont().deriveFont(0));
                continue;
            }
            if (layerPanel.getLayer().isEnabled()) {
                layerPanel.setLayerNameFont(layerPanel.getLayerNameFont().deriveFont(1));
                continue;
            }
            if (layerPanel.getLayer().isEnabled()) continue;
            layerPanel.setLayerNameFont(layerPanel.getLayerNameFont().deriveFont(0));
        }
    }
}

