/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.event.PositionEvent;
import gov.nasa.worldwind.event.PositionListener;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.MarkerLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.markers.BasicMarker;
import gov.nasa.worldwind.render.markers.BasicMarkerAttributes;
import gov.nasa.worldwind.render.markers.Marker;
import gov.nasa.worldwind.util.BasicQuadTree;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.Point;
import java.io.IOException;
import java.util.HashSet;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class TreeFiltering
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Filtering by Region", AppFrame.class);
    }

    private static class MyMarkerLayer
    extends MarkerLayer {
        private static final double[] REGION_SIZES = new double[]{5.0, 2.0};
        private static final long TIME_LIMIT = 5L;
        private BasicQuadTree<Marker> database;
        private Position position;
        private Iterable<Marker> markers;

        public MyMarkerLayer(BasicQuadTree<Marker> basicQuadTree) {
            this.database = basicQuadTree;
            this.setOverrideMarkerElevation(true);
            this.setKeepSeparated(false);
        }

        public void setCursorLocation(Position position) {
            this.position = position;
        }

        @Override
        protected void draw(DrawContext drawContext, Point point) {
            if (this.position == null) {
                return;
            }
            if (!this.isPickEnabled() || drawContext.isPickingMode() || this.markers == null) {
                this.markers = this.getVisibleMarkers(drawContext);
            }
            this.setMarkers(this.markers);
            super.draw(drawContext, point);
        }

        private Iterable<Marker> getVisibleMarkers(DrawContext drawContext) {
            HashSet<Marker> hashSet = new HashSet<Marker>();
            for (Sector sector : drawContext.getVisibleSectors(REGION_SIZES, 5L, this.computeSector())) {
                this.database.getItemsInRegion(sector, hashSet);
            }
            return hashSet;
        }

        private Sector computeSector() {
            double d = 5.0;
            double d2 = this.position.getLatitude().degrees;
            double d3 = this.position.getLongitude().degrees;
            double d4 = Math.max(d2 - d, -90.0);
            double d5 = Math.min(d2 + d, 90.0);
            double d6 = Math.max(d3 - d, -180.0);
            double d7 = Math.min(d3 + d, 180.0);
            return Sector.fromDegrees(d4, d5, d6, d7);
        }
    }

    private static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() throws IOException, ParserConfigurationException, SAXException {
            super(true, true, false);
            final MyMarkerLayer myMarkerLayer = new MyMarkerLayer(this.makeDatabase());
            myMarkerLayer.setKeepSeparated(false);
            myMarkerLayer.setPickEnabled(true);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), myMarkerLayer);
            this.getLayerPanel().update(this.getWwd());
            this.getWwd().addPositionListener(new PositionListener(){

                @Override
                public void moved(PositionEvent positionEvent) {
                    myMarkerLayer.setCursorLocation(positionEvent.getPosition());
                }
            });
        }

        private BasicQuadTree<Marker> makeDatabase() {
            int n = 5;
            int n2 = 23;
            int n3 = 50;
            int n4 = 3;
            int n5 = -130;
            int n6 = -70;
            int n7 = 3;
            BasicQuadTree<Marker> basicQuadTree = new BasicQuadTree<Marker>(n, Sector.FULL_SPHERE, null);
            BasicMarkerAttributes basicMarkerAttributes = new BasicMarkerAttributes();
            for (int i = n2; i <= n3; i += n4) {
                for (int j = n5; j <= n6; j += n7) {
                    basicQuadTree.add(new BasicMarker(Position.fromDegrees(i, j, 0.0), basicMarkerAttributes), new double[]{i, j}, null);
                }
            }
            return basicQuadTree;
        }
    }
}

