/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.animation.BasicAnimator;
import gov.nasa.worldwind.animation.Interpolator;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.ExtentHolder;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.IconLayer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwind.render.SurfaceCircle;
import gov.nasa.worldwind.render.UserFacingIcon;
import gov.nasa.worldwind.render.WWIcon;
import gov.nasa.worldwind.render.airspaces.BasicAirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.SphereAirspace;
import gov.nasa.worldwind.util.BasicDragger;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.view.orbit.OrbitView;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.ExtentVisibilitySupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.Timer;

public class KeepingObjectsInView
extends ApplicationTemplate {
    public static Iterable<?> createObjectsToTrack() {
        ArrayList<AVListImpl> arrayList = new ArrayList<AVListImpl>();
        Sector sector = Sector.fromDegrees(35.0, 45.0, -110.0, -100.0);
        for (int i = 0; i < 3; ++i) {
            LatLon latLon = KeepingObjectsInView.randomLocation(sector);
            UserFacingIcon userFacingIcon = new UserFacingIcon("gov/nasa/worldwindx/examples/images/antenna.png", new Position(latLon, 0.0));
            userFacingIcon.setSize(new Dimension(64, 64));
            userFacingIcon.setValue("gov.nasa.worldwind.avkey.FeedbackEnabled", Boolean.TRUE);
            arrayList.add(userFacingIcon);
            latLon = KeepingObjectsInView.randomLocation(sector);
            SphereAirspace sphereAirspace = new SphereAirspace(latLon, 50000.0);
            sphereAirspace.setAltitude(0.0);
            sphereAirspace.setTerrainConforming(true);
            sphereAirspace.setAttributes(new BasicAirspaceAttributes(Material.GREEN, 1.0));
            arrayList.add(sphereAirspace);
            latLon = KeepingObjectsInView.randomLocation(sector);
            LatLon latLon2 = KeepingObjectsInView.randomLocation(sector);
            Polyline polyline = new Polyline(Arrays.asList(latLon, latLon2), 0.0);
            polyline.setFollowTerrain(true);
            polyline.setColor(Color.RED);
            polyline.setLineWidth(3.0);
            arrayList.add(polyline);
            latLon = KeepingObjectsInView.randomLocation(sector);
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.BLUE);
            basicShapeAttributes.setOutlineMaterial(new Material(WWUtil.makeColorBrighter(Color.BLUE)));
            basicShapeAttributes.setInteriorOpacity(0.5);
            SurfaceCircle surfaceCircle = new SurfaceCircle(basicShapeAttributes, latLon, 50000.0);
            arrayList.add(surfaceCircle);
        }
        return arrayList;
    }

    protected static LatLon randomLocation(Sector sector) {
        return new LatLon(Angle.mix(Math.random(), sector.getMinLatitude(), sector.getMaxLatitude()), Angle.mix(Math.random(), sector.getMinLongitude(), sector.getMaxLongitude()));
    }

    public static Annotation createHelpAnnotation(WorldWindow worldWindow) {
        String string = "The view tracks the antenna icons, the <font color=\"#DD0000\">red</font> lines, the <font color=\"#00DD00\">green</font> spheres, and the <font color=\"#0000DD\">blue</font> circles. Drag any object out of the window to track it.";
        Rectangle rectangle = ((Component)((Object)worldWindow)).getBounds();
        Point point = new Point(rectangle.width / 2, rectangle.height / 3);
        AnnotationAttributes annotationAttributes = new AnnotationAttributes();
        annotationAttributes.setAdjustWidthToText("gov.nasa.worldwind.avkey.SizeFitText");
        annotationAttributes.setFont(Font.decode("Arial-Bold-16"));
        annotationAttributes.setTextAlign("gov.nasa.worldwind.avkey.Center");
        annotationAttributes.setTextColor(Color.WHITE);
        annotationAttributes.setEffect("gov.nasa.worldwind.avkey.TextEffectOutline");
        annotationAttributes.setBackgroundColor(new Color(0, 0, 0, 127));
        annotationAttributes.setBorderColor(Color.LIGHT_GRAY);
        annotationAttributes.setLeader("gov.nasa.worldwind.avkey.ShapeNone");
        annotationAttributes.setCornerRadius(0);
        annotationAttributes.setSize(new Dimension(350, 0));
        return new ScreenAnnotation(string, point, annotationAttributes);
    }

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("Keeping Objects In View", AppFrame.class);
    }

    public static class ViewAnimator
    extends BasicAnimator {
        protected static final double LOCATION_EPSILON = 1.0E-9;
        protected static final double ALTITUDE_EPSILON = 0.1;
        protected OrbitView view;
        protected ViewController viewController;
        protected boolean haveTargets;
        protected Position centerPosition;
        protected double zoom;

        public ViewAnimator(final double d, OrbitView orbitView, ViewController viewController) {
            super(new Interpolator(){

                @Override
                public double nextInterpolant() {
                    return 1.0 - d;
                }
            });
            this.view = orbitView;
            this.viewController = viewController;
        }

        @Override
        public void stop() {
            super.stop();
            this.haveTargets = false;
        }

        @Override
        protected void setImpl(double d) {
            this.updateTargetValues();
            if (!this.haveTargets) {
                this.stop();
                return;
            }
            if (this.valuesMeetCriteria(this.centerPosition, this.zoom)) {
                this.view.setCenterPosition(this.centerPosition);
                this.view.setZoom(this.zoom);
                this.stop();
            } else {
                Position position = Position.interpolateGreatCircle(d, this.view.getCenterPosition(), this.centerPosition);
                double d2 = WWMath.mix(d, this.view.getZoom(), this.zoom);
                this.view.setCenterPosition(position);
                this.view.setZoom(d2);
            }
            this.view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this);
        }

        protected void updateTargetValues() {
            if (this.viewController.isSceneContained(this.view)) {
                return;
            }
            Vec4[] vec4Array = this.viewController.computeViewLookAtForScene(this.view);
            if (vec4Array == null || vec4Array.length != 3) {
                return;
            }
            this.centerPosition = this.viewController.computePositionFromPoint(vec4Array[1]);
            this.zoom = vec4Array[0].distanceTo3(vec4Array[1]);
            if (this.zoom < this.view.getZoom()) {
                this.zoom = this.view.getZoom();
            }
            this.haveTargets = true;
        }

        protected boolean valuesMeetCriteria(Position position, double d) {
            Angle angle = LatLon.greatCircleDistance(this.view.getCenterPosition(), position);
            double d2 = Math.abs(this.view.getCenterPosition().getElevation() - position.getElevation());
            double d3 = Math.abs(this.view.getZoom() - d);
            return angle.degrees < 1.0E-9 && d2 < 0.1 && d3 < 0.1;
        }
    }

    public static class ViewController {
        protected static final double SMOOTHING_FACTOR = 0.96;
        protected boolean enabled = true;
        protected WorldWindow wwd;
        protected ViewAnimator animator;
        protected Iterable<?> objectsToTrack;

        public ViewController(WorldWindow worldWindow) {
            this.wwd = worldWindow;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
            if (this.animator != null) {
                this.animator.stop();
                this.animator = null;
            }
        }

        public Iterable<?> getObjectsToTrack() {
            return this.objectsToTrack;
        }

        public void setObjectsToTrack(Iterable<?> iterable) {
            this.objectsToTrack = iterable;
        }

        public boolean isSceneContained(View view) {
            ExtentVisibilitySupport extentVisibilitySupport = new ExtentVisibilitySupport();
            this.addExtents(extentVisibilitySupport);
            return extentVisibilitySupport.areExtentsContained(view);
        }

        public Vec4[] computeViewLookAtForScene(View view) {
            Globe globe = this.wwd.getModel().getGlobe();
            double d = this.wwd.getSceneController().getVerticalExaggeration();
            ExtentVisibilitySupport extentVisibilitySupport = new ExtentVisibilitySupport();
            this.addExtents(extentVisibilitySupport);
            return extentVisibilitySupport.computeViewLookAtContainingExtents(globe, d, view);
        }

        public Position computePositionFromPoint(Vec4 vec4) {
            return this.wwd.getModel().getGlobe().computePositionFromPoint(vec4);
        }

        public void gotoScene() {
            Vec4[] vec4Array = this.computeViewLookAtForScene(this.wwd.getView());
            if (vec4Array == null || vec4Array.length != 3) {
                return;
            }
            Position position = this.wwd.getModel().getGlobe().computePositionFromPoint(vec4Array[1]);
            double d = vec4Array[0].distanceTo3(vec4Array[1]);
            this.wwd.getView().stopAnimations();
            this.wwd.getView().goTo(position, d);
        }

        public void sceneChanged() {
            OrbitView orbitView = (OrbitView)this.wwd.getView();
            if (!this.isEnabled()) {
                return;
            }
            if (this.isSceneContained(orbitView)) {
                return;
            }
            if (this.animator == null || !this.animator.hasNext()) {
                this.animator = new ViewAnimator(0.96, orbitView, this);
                this.animator.start();
                orbitView.stopAnimations();
                orbitView.addAnimator(this.animator);
                orbitView.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, orbitView);
            }
        }

        protected void addExtents(ExtentVisibilitySupport extentVisibilitySupport) {
            Iterable<?> iterable = this.getObjectsToTrack();
            if (iterable == null) {
                return;
            }
            ArrayList<ExtentHolder> arrayList = new ArrayList<ExtentHolder>();
            ArrayList<ExtentVisibilitySupport.ScreenExtent> arrayList2 = new ArrayList<ExtentVisibilitySupport.ScreenExtent>();
            for (Object obj : iterable) {
                AVList aVList;
                Object object;
                if (obj == null) continue;
                if (obj instanceof ExtentHolder) {
                    arrayList.add((ExtentHolder)obj);
                    continue;
                }
                if (!(obj instanceof AVList) || (object = (aVList = (AVList)obj).getValue("gov.nasa.worldwind.avkey.FeedbackEnabled")) == null || !Boolean.TRUE.equals(object) || aVList.getValue("gov.nasa.worldwind.avkey.FeedbackReferencePoint") == null) continue;
                arrayList2.add(new ExtentVisibilitySupport.ScreenExtent((Vec4)aVList.getValue("gov.nasa.worldwind.avkey.FeedbackReferencePoint"), (Rectangle)aVList.getValue("gov.nasa.worldwind.avkey.FeedbackScreenBounds")));
            }
            if (!arrayList.isEmpty()) {
                Globe globe = this.wwd.getModel().getGlobe();
                double d = this.wwd.getSceneController().getVerticalExaggeration();
                extentVisibilitySupport.setExtents(ExtentVisibilitySupport.extentsFromExtentHolders(arrayList, globe, d));
            }
            if (!arrayList2.isEmpty()) {
                extentVisibilitySupport.setScreenExtents(arrayList2);
            }
        }
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected Iterable<?> objectsToTrack = KeepingObjectsInView.createObjectsToTrack();
        protected ViewController viewController = new ViewController(this.getWwd());
        protected RenderableLayer helpLayer;

        public AppFrame() {
            this.viewController.setObjectsToTrack(this.objectsToTrack);
            this.addObjectsToWorldWindow(this.objectsToTrack);
            this.initSwingComponents();
            Timer timer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.enableHelpAnnotation();
                    AppFrame.this.viewController.gotoScene();
                }
            });
            timer.setRepeats(false);
            timer.start();
        }

        protected void enableHelpAnnotation() {
            if (this.helpLayer != null) {
                return;
            }
            this.helpLayer = new RenderableLayer();
            this.helpLayer.addRenderable(KeepingObjectsInView.createHelpAnnotation(this.getWwd()));
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), this.helpLayer);
        }

        protected void disableHelpAnnotation() {
            if (this.helpLayer == null) {
                return;
            }
            this.getWwd().getModel().getLayers().remove(this.helpLayer);
            this.helpLayer.removeAllRenderables();
            this.helpLayer = null;
        }

        protected void addObjectsToWorldWindow(Iterable<?> iterable) {
            IconLayer iconLayer = new IconLayer();
            iconLayer.setViewClippingEnabled(false);
            iconLayer.setName("Icons To Track");
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), iconLayer);
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.setName("Shapes to Track");
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), renderableLayer);
            this.getLayerPanel().update(this.getWwd());
            for (Object obj : iterable) {
                if (obj instanceof WWIcon) {
                    iconLayer.addIcon((WWIcon)obj);
                    continue;
                }
                if (!(obj instanceof Renderable)) continue;
                renderableLayer.addRenderable((Renderable)obj);
            }
            this.getWwd().addSelectListener(new SelectListener(){
                protected BasicDragger dragger;
                {
                    this.dragger = new BasicDragger(AppFrame.this.getWwd());
                }

                @Override
                public void selected(SelectEvent selectEvent) {
                    this.dragger.selected(selectEvent);
                    if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag")) {
                        AppFrame.this.disableHelpAnnotation();
                        AppFrame.this.viewController.sceneChanged();
                    }
                }
            });
        }

        protected void initSwingComponents() {
            JCheckBox jCheckBox = new JCheckBox("Enable view tracking", true);
            jCheckBox.setAlignmentX(0.0f);
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ((AbstractButton)actionEvent.getSource()).isSelected();
                    AppFrame.this.viewController.setEnabled(bl);
                }
            });
            JButton jButton = new JButton("Go to objects");
            jButton.setAlignmentX(0.0f);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.viewController.gotoScene();
                }
            });
            Box box = Box.createVerticalBox();
            box.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
            box.add(jCheckBox);
            box.add(Box.createVerticalStrut(5));
            box.add(jButton);
            this.getLayerPanel().add((Component)box, "South");
        }
    }
}

